<!-- Scroll To Top with Progress Ring -->
<div
    x-data="{
        show: false,
        progress: 0,
        circumference: 2 * Math.PI * 26, // 26 = circle radius

        init() {
            window.addEventListener('scroll', () => {
                const scrollTop = window.scrollY
                const docHeight = document.documentElement.scrollHeight - window.innerHeight
                this.progress = docHeight > 0 ? (scrollTop / docHeight) * 100 : 0
                this.show = scrollTop > 200
            })
        },

        scrollToTop() {
            window.scrollTo({ top: 0, behavior: 'smooth' })
        },

        dashOffset() {
            return this.circumference - (this.progress / 100) * this.circumference
        }
    }"
    x-show="show"
    x-transition:enter="transition ease-out duration-300"
    x-transition:enter-start="opacity-0 translate-y-6 scale-90"
    x-transition:enter-end="opacity-100 translate-y-0 scale-100"
    x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100 translate-y-0 scale-100"
    x-transition:leave-end="opacity-0 translate-y-6 scale-90"
    class="fixed bottom-6 left-6 z-50"
    style="display: none;"
>
    <div class="relative w-14 h-14">

        <!-- SVG Progress Ring -->
        <svg class="absolute inset-0 w-full h-full -rotate-90">
            <!-- Background Circle -->
            <circle
                cx="28"
                cy="28"
                r="26"
                stroke="rgba(255,255,255,0.15)"
                stroke-width="4"
                fill="transparent"
            />
            <!-- Progress Circle -->
            <circle
                cx="28"
                cy="28"
                r="26"
                stroke="currentColor"
                stroke-width="4"
                fill="transparent"
                stroke-linecap="round"
                :stroke-dasharray="circumference"
                :stroke-dashoffset="dashOffset()"
                class="text-primary-500 transition-all duration-150 ease-out"
            />
        </svg>

        <!-- Button -->
        <button
            @click="scrollToTop"
            aria-label="Scroll to top"
            class="absolute inset-0 m-auto
                   w-12 h-12
                   flex items-center justify-center
                   rounded-full
                   bg-primary-600 hover:bg-primary-700
                   text-white shadow-lg shadow-primary-500/30
                   transition-all duration-300
                   hover:scale-110 active:scale-95"
        >
            <?php if (isset($component)) { $__componentOriginal511d4862ff04963c3c16115c05a86a9d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal511d4862ff04963c3c16115c05a86a9d = $attributes; } ?>
<?php $component = Illuminate\View\DynamicComponent::resolve(['component' => 'flux::icon.arrow-up'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dynamic-component'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\DynamicComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $attributes = $__attributesOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__attributesOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal511d4862ff04963c3c16115c05a86a9d)): ?>
<?php $component = $__componentOriginal511d4862ff04963c3c16115c05a86a9d; ?>
<?php unset($__componentOriginal511d4862ff04963c3c16115c05a86a9d); ?>
<?php endif; ?>
        </button>

    </div>
</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/partials/scroll.blade.php ENDPATH**/ ?>