<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'title' => 'Compare Loans',
    'loans' => [],
    'cols' => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4',
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'title' => 'Compare Loans',
    'loans' => [],
    'cols' => 'grid-cols-1 md:grid-cols-2 lg:grid-cols-4',
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<section class="py-8 md:py-12 max-w-7xl mx-auto px-4 sm:px-6 lg:px-0 fade-in-up">
    <h2 class="text-3xl font-bold text-gray-900 dark:text-white text-center mb-12"><?php echo e($title); ?></h2>

    <div class="grid <?php echo e($cols); ?> gap-6">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
            <div class="flex flex-col rounded-xl border <?php echo e($loan['border'] ?? 'border-gray-200 dark:border-gray-700'); ?> bg-white dark:bg-gray-900 shadow hover:shadow-lg transition transform hover:-translate-y-1">
                <div class="p-6 flex flex-col flex-1">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-2"><?php echo e($loan['title']); ?></h3>
                    <p class="text-gray-600 dark:text-gray-300 mb-4"><?php echo e($loan['description']); ?></p>

                    <div class="grid grid-cols-2 gap-2 mb-4 text-sm text-gray-700 dark:text-gray-300">
                        <div class="p-2 rounded <?php echo e($loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50'); ?> text-center">
                            <span class="block font-semibold">Loan Amount</span>
                            <span class="block font-bold text-gray-900 dark:text-white"><?php echo e($loan['amount']); ?></span>
                        </div>
                        <div class="p-2 rounded <?php echo e($loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50'); ?> text-center">
                            <span class="block font-semibold">Term</span>
                            <span class="block font-bold text-gray-900 dark:text-white"><?php echo e($loan['term']); ?></span>
                        </div>
                        <div class="p-2 rounded <?php echo e($loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50'); ?> text-center">
                            <span class="block font-semibold">Prepay</span>
                            <span class="block font-bold text-gray-900 dark:text-white"><?php echo e($loan['prepay']); ?></span>
                        </div>
                        <div class="p-2 rounded <?php echo e($loan['color'] ?? 'bg-gray-50 dark:bg-gray-800/50'); ?> text-center">
                            <span class="block font-semibold">Apply</span>
                            <span class="block font-bold text-gray-900 dark:text-white"><?php echo e($loan['apply']); ?></span>
                        </div>
                    </div>

                    <a href="<?php echo e($loan['ctaLink'] ?? route('user.register')); ?>" 
                       class="mt-auto text-center px-4 py-2 rounded-lg text-white font-semibold <?php echo e($loan['ctaColor'] ?? 'bg-sky-600 hover:bg-sky-700'); ?> transition">
                        <?php echo e($loan['ctaText'] ?? 'Apply Now'); ?>

                    </a>
                </div>
            </div>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
    </div>
</section>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/loan-grid.blade.php ENDPATH**/ ?>