<?php

use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\Kyc;
use Livewire\Attributes\On;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

new class extends Component {
    use WithFileUploads;
    public $id_type = '';
    public $id_images = [];
    public $temp_id_images = [];

    public $unreadCount = 0;

    #[On('profile-updated')]
    public function refreshAvatar()
    {
        $this->profilePhotoUrl = Storage::disk('public')->url(Auth::user()->profile->profile_photo);
    }

    public function mount()
    {
        $this->refreshUnreadCount();
    }

    #[On('notification-sent')]
    #[On('notifications-read')]
    public function refreshUnreadCount()
    {
        $this->unreadCount = auth()->user()->unreadNotifications()->count();
    }

    public function markAsRead($id)
    {
        auth()->user()->unreadNotifications()->where('id', $id)->first()?->markAsRead();

        $this->refreshUnreadCount();
    }
    public function clearError($field)
    {
        $this->resetErrorBag($field);
    }

    public array $kyc_docs = [['value' => 'passport', 'label' => 'Passport'], ['value' => 'national_id', 'label' => 'National ID Card'], ['value' => 'driver_license', 'label' => 'Driver\'s License'], ['value' => 'voter_id', 'label' => 'Voter ID Card'], ['value' => 'residence_permit', 'label' => 'Residence Permit'], ['value' => 'others', 'label' => 'Others']];

    protected $rules = [
        'id_type' => 'required|string',
        'id_images' => 'required|array|min:1|max:3',
        'id_images.*' => 'required|image|max:10240|mimes:jpg,jpeg,png,webp',
    ];

    protected function messages()
    {
        return [
            // id_images general
            'id_images.required' => 'Please upload at least one ID image.',
            'id_images.array' => 'The ID images must be an array.',
            'id_images.min' => 'Please upload at least one ID image.',
            'id_images.max' => 'You can upload up to 3 ID images only.',

            // each individual id image
            'id_images.*.required' => 'Each ID image file is required.',
            'id_images.*.image' => 'Each file must be a valid image only jpeg, jpg, png, webp are allowed.',
            'id_images.*.max' => 'Each image must not exceed 2MB.',
            'id_images.*.mimes' => 'Only JPG and PNG images are allowed for ID images.',
        ];
    }

    public function removeImage($model, $index = null)
    {
        if (is_array($this->$model) || $this->$model instanceof \Illuminate\Support\Collection) {
            $files = collect($this->$model)->forget($index)->values()->all();
            $this->$model = $files;

            // Also sync to id_images if it's temp_id_images
            if ($model === 'temp_id_images') {
                $this->id_images = $files;
            }
        } else {
            $this->$model = null;
        }
    }

    public function updatedIdImages($newImages)
    {
        // Merge new images with old ones stored in temp_id_images
        $merged = collect($this->temp_id_images)
            ->merge($newImages)
            ->unique(function ($file) {
                return $file->getFilename();
            })
            ->values()
            ->all();

        $this->temp_id_images = $merged;
        $this->id_images = $merged;
    }

    public function submit()
    {
        $validated = $this->validate();

        $user = auth()->user();
        $storedIdImages = [];

        DB::beginTransaction();

        try {
            // 1) Store uploaded files first
            foreach ($this->id_images as $file) {
                $storedIdImages[] = $file->store('kyc-documents', 'public');
            }

            // 2) Lock user's KYC rows (prevents double submit race conditions)
            Kyc::where('user_id', $user->id)->lockForUpdate()->get();

            // 3) Mark previous latest as not latest
            Kyc::where('user_id', $user->id)
                ->where('is_latest', true)
                ->update(['is_latest' => false]);

            // 4) Determine latest version safely
            $latestVersion = Kyc::where('user_id', $user->id)->max('version') ?? 0;

            // 5) Create new latest KYC
            Kyc::create([
                'user_id' => $user->id,
                'id_type' => $this->id_type,
                'id_document_paths' => $storedIdImages,
                'status' => Kyc::STATUS_PENDING,
                'is_latest' => true,
                'version' => $latestVersion + 1,
            ]);

            DB::commit();

            // Reset form
            $this->reset(['id_type', 'id_images', 'temp_id_images']);

            $this->dispatch('showToast', message: 'KYC documents uploaded successfully!', type: 'success');
            $this->dispatch('kyc-uploaded');
        } catch (\Exception $e) {
            DB::rollBack();

            // Delete uploaded files if DB failed
            foreach ($storedIdImages as $path) {
                if (Storage::disk('public')->exists($path)) {
                    Storage::disk('public')->delete($path);
                }
            }

            Log::error('KYC submission failed', [
                'user_id' => $user->id,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            $this->dispatch('showToast', message: $e->getMessage(), type: 'error');
        }
    }
};

?>
<div
    class="px-6 py-4 bg-white dark:bg-zinc-900 shadow-sm border-b border-gray-200 dark:border-zinc-700 flex items-center justify-between">

    <?php
        $page = currentPageInfo($authUser);
    ?>
    <div wire:ignore class="flex items-center gap-2">

        <!-- Mobile hamburger -->
        <div class="lg:hidden z-50">
            <button @click="opensidebar = !opensidebar"
                class="relative w-8 h-8 flex flex-col justify-center items-center gap-1.5 p-2 bg-white dark:bg-gray-800 text-rose-600 dark:text-white rounded-md shadow-md focus:outline-none focus:ring-2 focus:ring-rose-500">

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = ['', '', '']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <span
                        :class="opensidebar
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ? ['first:rotate-45 absolute', 'second:opacity-0', 'third:-rotate-45 absolute'][$loop->index] 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        : ''"
                        class="block w-6 h-0.5 bg-current transition-transform duration-500 ease-[cubic-bezier(0.68,-0.55,0.27,1.55)]
                           transition-opacity duration-500 scale-80"></span>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
            </button>
        </div>

        <!-- Title & Welcome -->
        <div class="hidden sm:block">
            <h2 class="text-base md:text-lg font-semibold text-gray-900 dark:text-white"><?php echo e($page['title']); ?></h2>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($page['showWelcome']): ?>
                <p class="text-sm text-gray-500 dark:text-gray-400"><?php echo e($page['welcome']); ?></p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

    </div>

    <?php $impersonation = app(\App\Services\ImpersonationService::class); ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($impersonation->isImpersonating()): ?>
        <div class="bg-yellow-400 text-black text-center py-2 text-sm">
            You are logged in as a user
            <form method="POST" action="<?php echo e(route('admin.impersonation.leave')); ?>" class="inline">
                <?php echo csrf_field(); ?>
                <button class="underline ml-2 font-semibold">
                    Return to Admin
                </button>
            </form>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


    <!-- RIGHT: Notifications + Account -->
    <div class="flex items-center gap-4" x-data="{ openDropdown: null }" @click.outside="openDropdown = null">
        <div class="flex items-center gap-3 relative">
            <?php
                $kyc = Kyc::latestForUser(auth()->id())->first();
            ?>
            <!-- Buttons -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$kyc): ?>
                <!-- No KYC submitted -->
                <?php if (isset($component)) { $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::button.index','data' => ['type' => 'button','@click' => '$dispatch(\'open-kyc-modal\')','class' => 'bg-sky-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'button','@click' => '$dispatch(\'open-kyc-modal\')','class' => 'bg-sky-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                    Verify KYC
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $attributes = $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $component = $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
            <?php elseif($kyc->status === 'pending'): ?>
                <!-- KYC submitted, pending -->
                <div class="p-2 bg-yellow-100 text-yellow-800 rounded-md text-sm text-center cursor-help"
                    title="Your KYC verification is pending. Please wait for approval.">
                    Pending KYC
                </div>
            <?php elseif($kyc->status === 'rejected'): ?>
                <!-- KYC rejected, allow re-upload -->
                <?php if (isset($component)) { $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::button.index','data' => ['type' => 'button','@click' => '$dispatch(\'open-kyc-modal\')','class' => 'bg-red-500 hover:bg-red-900']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'button','@click' => '$dispatch(\'open-kyc-modal\')','class' => 'bg-red-500 hover:bg-red-900']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                    Re-upload KYC
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $attributes = $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $component = $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <!-- Single reusable modal -->
            <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['xOn:kycUploaded.window' => 'close()','@openKycModal.window' => 'openModal()','@closeOpenKycModal.window' => 'close()']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['x-on:kyc-uploaded.window' => 'close()','@open-kyc-modal.window' => 'openModal()','@close-open-kyc-modal.window' => 'close()']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                <?php echo $__env->make('partials.kyc', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>

        </div>
        <!-- Dark Mode Toggle with animation -->
        <button @click="darkMode = !darkMode; localStorage.setItem('darkMode', darkMode)"
            class="relative p-3 rounded-2xl bg-linear-to-br from-gray-50 to-gray-100 
               dark:from-gray-800 dark:to-gray-700 text-gray-600 dark:text-gray-300 
               hover:from-primary-50 hover:to-primary-100 
               dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 
               transition-all duration-300 shadow-lg hover:shadow-xl 
               hover:-translate-y-0.5 group">
            <?php if (isset($component)) { $__componentOriginald5f987720f2b51852a6659d9a2c7a66b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald5f987720f2b51852a6659d9a2c7a66b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.sun','data' => ['variant' => 'solid','xShow' => '!darkMode','xCloak' => true,'class' => 'w-5 h-5 group-hover:rotate-180 transition-transform duration-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.sun'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','x-show' => '!darkMode','x-cloak' => true,'class' => 'w-5 h-5 group-hover:rotate-180 transition-transform duration-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald5f987720f2b51852a6659d9a2c7a66b)): ?>
<?php $attributes = $__attributesOriginald5f987720f2b51852a6659d9a2c7a66b; ?>
<?php unset($__attributesOriginald5f987720f2b51852a6659d9a2c7a66b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald5f987720f2b51852a6659d9a2c7a66b)): ?>
<?php $component = $__componentOriginald5f987720f2b51852a6659d9a2c7a66b; ?>
<?php unset($__componentOriginald5f987720f2b51852a6659d9a2c7a66b); ?>
<?php endif; ?>

            <?php if (isset($component)) { $__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.moon','data' => ['variant' => 'solid','xCloak' => true,'xShow' => 'darkMode','class' => 'w-5 h-5 group-hover:rotate-12 transition-transform duration-300']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.moon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','x-cloak' => true,'x-show' => 'darkMode','class' => 'w-5 h-5 group-hover:rotate-12 transition-transform duration-300']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2)): ?>
<?php $attributes = $__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2; ?>
<?php unset($__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2)): ?>
<?php $component = $__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2; ?>
<?php unset($__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2); ?>
<?php endif; ?>
        </button>

        <!-- Notifications -->
        <div class="relative">
            <button @click="openDropdown = (openDropdown === 'notifications' ? null : 'notifications')"
                class="relative p-2 rounded-full hover:bg-sky-100 dark:hover:bg-sky-900 focus:outline-none transition">
                <?php if (isset($component)) { $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bell','data' => ['class' => 'w-6 h-6 '.e($unreadCount > 0 ? 'text-sky-500 animate-pulse' : 'text-gray-500 dark:text-gray-300').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bell'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 '.e($unreadCount > 0 ? 'text-sky-500 animate-pulse' : 'text-gray-500 dark:text-gray-300').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $attributes = $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $component = $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($unreadCount > 0): ?>
                    <span
                        class="absolute -top-1 -right-1 bg-sky-500 text-white rounded-full w-5 h-5 flex items-center justify-center text-[10px] font-semibold shadow">
                        <?php echo e($unreadCount); ?>

                    </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </button>

            
            <div x-show="openDropdown === 'notifications'" x-collapse x-cloak
                class="absolute right-0 w-96 max-h-96 overflow-y-auto bg-white dark:bg-zinc-900 shadow-2xl rounded-xl border border-gray-200 dark:border-zinc-700 mt-2 z-50">

                <div class="py-2 px-3 border-b border-gray-200 dark:border-zinc-700">
                    <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-200">Notifications</h4>
                </div>

                <div class="divide-y divide-gray-100 dark:divide-zinc-800">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = auth()->user()->notifications()->latest()->take(10)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <?php
                            $link = $notification->data['link'] ?? null;
                        ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($link): ?>
                            <a href="<?php echo e($link); ?>" class="block">
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <div class="flex items-start gap-3 p-3 hover:bg-sky-50 dark:hover:bg-sky-900 rounded-lg transition cursor-pointer"
                            <?php if(!$link): ?> @click="$wire.markAsRead('<?php echo e($notification->id); ?>')" <?php endif; ?>>

                            <div class="shrink-0">
                                <?php if (isset($component)) { $__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bell-alert','data' => ['class' => 'w-5 h-5 text-sky-500 mt-1']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bell-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 text-sky-500 mt-1']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9)): ?>
<?php $attributes = $__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9; ?>
<?php unset($__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9)): ?>
<?php $component = $__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9; ?>
<?php unset($__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9); ?>
<?php endif; ?>
                            </div>

                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-gray-900 dark:text-gray-100">
                                    <?php echo e($notification->data['title'] ?? 'Notification'); ?>

                                </p>

                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    <?php echo e($notification->data['message'] ?? ''); ?>

                                </p>


                                <span class="text-[10px] text-gray-400 dark:text-gray-500 mt-1 block">
                                    <?php echo e($notification->created_at->diffForHumans()); ?>

                                </span>
                            </div>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$notification->read_at): ?>
                                <span class="ml-2 shrink-0 w-2 h-2 bg-sky-500 rounded-full mt-1"></span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($link): ?>
                            </a>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <p class="text-center text-gray-400 dark:text-gray-500 py-6 text-sm">
                            No new notifications
                        </p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                </div>

                <div class="text-center py-2">
                    <a href="<?php echo e(route('user.transactions')); ?>"
                        class="text-sky-600 hover:text-sky-700 dark:text-sky-400 dark:hover:text-sky-300 text-sm font-medium transition">
                        View All
                    </a>
                </div>
            </div>
        </div>

        <!-- Account Menu -->
        <div class="relative">
            <button @click="openDropdown = (openDropdown === 'account' ? null : 'account')"
                class="flex items-center gap-2 px-3 py-1 rounded-full hover:bg-gray-100 dark:hover:bg-zinc-800 transition">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($authUser->profile->profile_photo): ?>
                    <img src="<?php echo e(Storage::disk('public')->url($authUser->profile->profile_photo)); ?>"
                        class="w-8 h-8 rounded-full object-cover" />
                <?php else: ?>
                    <div
                        class="w-8 h-8 rounded-full bg-gray-300 flex items-center justify-center text-sm font-semibold text-gray-700">
                        <?php echo e($authUser->initials()); ?>

                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <?php if (isset($component)) { $__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.chevron-down','data' => ['class' => 'w-3 h-3 text-gray-600']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.chevron-down'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-3 h-3 text-gray-600']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0)): ?>
<?php $attributes = $__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0; ?>
<?php unset($__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0)): ?>
<?php $component = $__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0; ?>
<?php unset($__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0); ?>
<?php endif; ?>
            </button>

            <div x-show="openDropdown === 'account'" x-collapse x-cloak
                class="absolute right-0 mt-3 w-60 bg-white dark:bg-zinc-900 shadow-xl rounded-xl overflow-hidden z-50">

                <!-- User Info -->
                <div class="px-4 py-3 border-b dark:border-zinc-700">
                    <p class="text-sm font-semibold text-gray-900 dark:text-white truncate"><?php echo e(auth()->user()->name); ?>

                    </p>
                    <p class="text-xs text-gray-500 dark:text-gray-400 truncate"><?php echo e(auth()->user()->email); ?></p>
                </div>

                <!-- KYC Status -->
                <div class="px-4 py-3 border-b dark:border-zinc-700">
                    <?php
                        $kyc = \App\Models\Kyc::latestForUser(auth()->id())->first();
                    ?>

                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$kyc): ?>
                        <div
                            class="flex items-center gap-2 px-3 py-2 bg-gray-100 dark:bg-zinc-800 text-gray-700 dark:text-gray-300 rounded-lg font-medium text-xs">
                            <?php if (isset($component)) { $__componentOriginal7f0e8d69add49581695c1337b3f85fff = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7f0e8d69add49581695c1337b3f85fff = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.exclamation-triangle','data' => ['class' => 'w-4 h-4 text-red-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.exclamation-triangle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4 text-red-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7f0e8d69add49581695c1337b3f85fff)): ?>
<?php $attributes = $__attributesOriginal7f0e8d69add49581695c1337b3f85fff; ?>
<?php unset($__attributesOriginal7f0e8d69add49581695c1337b3f85fff); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7f0e8d69add49581695c1337b3f85fff)): ?>
<?php $component = $__componentOriginal7f0e8d69add49581695c1337b3f85fff; ?>
<?php unset($__componentOriginal7f0e8d69add49581695c1337b3f85fff); ?>
<?php endif; ?>
                            <span>KYC Status: Not Submitted</span>
                        </div>
                    <?php elseif($kyc->status === 'pending'): ?>
                        <div
                            class="flex items-center gap-2 px-3 py-2 bg-yellow-100 dark:bg-yellow-900 text-yellow-800 dark:text-yellow-300 rounded-lg text-xs font-medium">
                            <?php if (isset($component)) { $__componentOriginal4a4fffe04433d6d6be16f26ad2650578 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4a4fffe04433d6d6be16f26ad2650578 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.clock','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.clock'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4a4fffe04433d6d6be16f26ad2650578)): ?>
<?php $attributes = $__attributesOriginal4a4fffe04433d6d6be16f26ad2650578; ?>
<?php unset($__attributesOriginal4a4fffe04433d6d6be16f26ad2650578); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4a4fffe04433d6d6be16f26ad2650578)): ?>
<?php $component = $__componentOriginal4a4fffe04433d6d6be16f26ad2650578; ?>
<?php unset($__componentOriginal4a4fffe04433d6d6be16f26ad2650578); ?>
<?php endif; ?>
                            <span>KYC Status: Pending</span>
                        </div>
                    <?php elseif($kyc->status === 'verified'): ?>
                        <div
                            class="flex items-center gap-2 px-3 py-2 bg-green-100 dark:bg-green-900 text-green-700 dark:text-green-300 rounded-lg text-xs font-medium">
                            <?php if (isset($component)) { $__componentOriginal99e1287553cbf55f278732425b3f00bd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal99e1287553cbf55f278732425b3f00bd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.check-circle','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.check-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal99e1287553cbf55f278732425b3f00bd)): ?>
<?php $attributes = $__attributesOriginal99e1287553cbf55f278732425b3f00bd; ?>
<?php unset($__attributesOriginal99e1287553cbf55f278732425b3f00bd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal99e1287553cbf55f278732425b3f00bd)): ?>
<?php $component = $__componentOriginal99e1287553cbf55f278732425b3f00bd; ?>
<?php unset($__componentOriginal99e1287553cbf55f278732425b3f00bd); ?>
<?php endif; ?>
                            <span>KYC Status: Approved</span>
                        </div>
                    <?php elseif($kyc->status === 'rejected'): ?>
                        <div
                            class="flex items-center gap-2 px-3 py-2 bg-red-100 dark:bg-red-900 text-red-700 dark:text-red-300 rounded-lg text-xs font-medium">
                            <?php if (isset($component)) { $__componentOriginalc684311ed41ad32bac1c158a93d68bb7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc684311ed41ad32bac1c158a93d68bb7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.x-circle','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.x-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc684311ed41ad32bac1c158a93d68bb7)): ?>
<?php $attributes = $__attributesOriginalc684311ed41ad32bac1c158a93d68bb7; ?>
<?php unset($__attributesOriginalc684311ed41ad32bac1c158a93d68bb7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc684311ed41ad32bac1c158a93d68bb7)): ?>
<?php $component = $__componentOriginalc684311ed41ad32bac1c158a93d68bb7; ?>
<?php unset($__componentOriginalc684311ed41ad32bac1c158a93d68bb7); ?>
<?php endif; ?>
                            <span>KYC Status: Rejected</span>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <!-- Links -->
                <div class="py-2 flex flex-col gap-1 text-sm">
                    <a href="<?php echo e(route('user.dashboard')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg text-gray-700 dark:text-gray-200 ">
                        <?php if (isset($component)) { $__componentOriginal9f5e9841a29fcda640625c969c766980 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f5e9841a29fcda640625c969c766980 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.home','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.home'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f5e9841a29fcda640625c969c766980)): ?>
<?php $attributes = $__attributesOriginal9f5e9841a29fcda640625c969c766980; ?>
<?php unset($__attributesOriginal9f5e9841a29fcda640625c969c766980); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f5e9841a29fcda640625c969c766980)): ?>
<?php $component = $__componentOriginal9f5e9841a29fcda640625c969c766980; ?>
<?php unset($__componentOriginal9f5e9841a29fcda640625c969c766980); ?>
<?php endif; ?> Dashboard
                    </a>

                    <a href="<?php echo e(route('user.deposit')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg text-gray-700 dark:text-gray-200">
                        <?php if (isset($component)) { $__componentOriginal4ca64116c97e8cb412511f025b00da30 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4ca64116c97e8cb412511f025b00da30 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.plus-circle','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.plus-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4ca64116c97e8cb412511f025b00da30)): ?>
<?php $attributes = $__attributesOriginal4ca64116c97e8cb412511f025b00da30; ?>
<?php unset($__attributesOriginal4ca64116c97e8cb412511f025b00da30); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4ca64116c97e8cb412511f025b00da30)): ?>
<?php $component = $__componentOriginal4ca64116c97e8cb412511f025b00da30; ?>
<?php unset($__componentOriginal4ca64116c97e8cb412511f025b00da30); ?>
<?php endif; ?> Deposit
                    </a>

                    <a href="<?php echo e(route('user.withdrawal')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg text-gray-700 dark:text-gray-200">
                        <?php if (isset($component)) { $__componentOriginal5cf1ca7732bfa8a786fa83a83b598ccb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5cf1ca7732bfa8a786fa83a83b598ccb = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrow-up-right','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrow-up-right'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5cf1ca7732bfa8a786fa83a83b598ccb)): ?>
<?php $attributes = $__attributesOriginal5cf1ca7732bfa8a786fa83a83b598ccb; ?>
<?php unset($__attributesOriginal5cf1ca7732bfa8a786fa83a83b598ccb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5cf1ca7732bfa8a786fa83a83b598ccb)): ?>
<?php $component = $__componentOriginal5cf1ca7732bfa8a786fa83a83b598ccb; ?>
<?php unset($__componentOriginal5cf1ca7732bfa8a786fa83a83b598ccb); ?>
<?php endif; ?> Withdrawal
                    </a>

                    <a href="<?php echo e(route('user.virtual.cards')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg text-gray-700 dark:text-gray-200">
                        <?php if (isset($component)) { $__componentOriginal6e0b21ef9231e6606d7ac9c0c02dc146 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6e0b21ef9231e6606d7ac9c0c02dc146 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.credit-card','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.credit-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6e0b21ef9231e6606d7ac9c0c02dc146)): ?>
<?php $attributes = $__attributesOriginal6e0b21ef9231e6606d7ac9c0c02dc146; ?>
<?php unset($__attributesOriginal6e0b21ef9231e6606d7ac9c0c02dc146); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6e0b21ef9231e6606d7ac9c0c02dc146)): ?>
<?php $component = $__componentOriginal6e0b21ef9231e6606d7ac9c0c02dc146; ?>
<?php unset($__componentOriginal6e0b21ef9231e6606d7ac9c0c02dc146); ?>
<?php endif; ?> Virtual Cards
                    </a>

                    <a href="<?php echo e(route('user.local.transfer')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg text-gray-700 dark:text-gray-200">
                        <?php if (isset($component)) { $__componentOriginalda6e47aecf1695047ea823532321ccd7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalda6e47aecf1695047ea823532321ccd7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrows-right-left','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrows-right-left'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $attributes = $__attributesOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__attributesOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $component = $__componentOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__componentOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?> Local Transfer
                    </a>

                    <a href="<?php echo e(route('user.settings.index')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-gray-100 dark:hover:bg-zinc-800 rounded-lg text-gray-700 dark:text-gray-200">
                        <?php if (isset($component)) { $__componentOriginale9ba3c30481be3e85f54046f25a8bc05 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale9ba3c30481be3e85f54046f25a8bc05 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.cog','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.cog'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale9ba3c30481be3e85f54046f25a8bc05)): ?>
<?php $attributes = $__attributesOriginale9ba3c30481be3e85f54046f25a8bc05; ?>
<?php unset($__attributesOriginale9ba3c30481be3e85f54046f25a8bc05); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale9ba3c30481be3e85f54046f25a8bc05)): ?>
<?php $component = $__componentOriginale9ba3c30481be3e85f54046f25a8bc05; ?>
<?php unset($__componentOriginale9ba3c30481be3e85f54046f25a8bc05); ?>
<?php endif; ?> Account Settings
                    </a>

                    <a href="<?php echo e(route('user.logout')); ?>"
                        class="flex items-center gap-2 px-4 py-2 hover:bg-red-50 dark:hover:bg-red-900 rounded-lg text-red-600">
                        <?php if (isset($component)) { $__componentOriginalb7812e84ad32f38420861d34dff807cd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb7812e84ad32f38420861d34dff807cd = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrow-left-start-on-rectangle','data' => ['class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrow-left-start-on-rectangle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb7812e84ad32f38420861d34dff807cd)): ?>
<?php $attributes = $__attributesOriginalb7812e84ad32f38420861d34dff807cd; ?>
<?php unset($__attributesOriginalb7812e84ad32f38420861d34dff807cd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb7812e84ad32f38420861d34dff807cd)): ?>
<?php $component = $__componentOriginalb7812e84ad32f38420861d34dff807cd; ?>
<?php unset($__componentOriginalb7812e84ad32f38420861d34dff807cd); ?>
<?php endif; ?> Logout
                    </a>
                </div>
            </div>
        </div>


    </div>

</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/⚡top-widget.blade.php ENDPATH**/ ?>