<?php

use Livewire\Component;
use Livewire\Attributes\Layout;
use App\Models\Deposit;
use App\Services\TransactionHandler;

new #[Layout('layouts::base')] class extends Component {
    public Deposit $deposit;
    public string $currencySymbol = '$';
    public array $currencies = [];

    public function mount(Deposit $deposit)
    {
        $this->deposit = $deposit;

        $profileCurrency = $deposit->account?->profile?->currency ?? 'USD';
        $this->currencySymbol = \App\Support\Currency::symbol($profileCurrency);

        $this->loadCurrencies();
    }

    public function loadCurrencies(): void
    {
        $this->currencies = \Illuminate\Support\Facades\Cache::rememberForever('currencies_json', function () {
            return collect(json_decode(file_get_contents(resource_path('data/currencies.json')), true))
                ->sortBy('name')
                ->values()
                ->toArray();
        });
    }

    /**
     * Approve deposit using the new TransactionHandler service
     */
    public function approveDeposit(): void
    {
        try {
            $transaction = app(TransactionHandler::class)->approveDeposit($this->deposit);

            if (!$transaction) {
                $this->dispatch('showToast', message: 'Deposit already processed or not pending.', type: 'warning');
                return;
            }
            $this->deposit = $this->deposit->fresh();
            $this->dispatch('notification-sent');
            $this->dispatch('showToast', message: 'Deposit approved successfully!', type: 'success');
        } catch (\Exception $e) {
            $this->dispatch('showToast', message: $e->getMessage(), type: 'error');
        }
    }

    /**
     * Reject deposit using the new TransactionHandler service
     */
    public function rejectDeposit(): void
    {
        app(TransactionHandler::class)->rejectTransaction($this->deposit);

        $this->deposit = $this->deposit->fresh();

        $this->dispatch('showToast', message: 'Deposit rejected safely!', type: 'success');
    }
};
?>

<div class="space-y-8 py-6">

    
    <?php if (isset($component)) { $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.page-header','data' => ['title' => 'Deposit #'.e($deposit->id).'','subtitle' => 'Approve or review deposit details','rightText' => 'Back to List','backUrl' => ''.e(route('admin.deposit.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('page-header'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => 'Deposit #'.e($deposit->id).'','subtitle' => 'Approve or review deposit details','rightText' => 'Back to List','back-url' => ''.e(route('admin.deposit.index')).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $attributes = $__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__attributesOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e)): ?>
<?php $component = $__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e; ?>
<?php unset($__componentOriginalf8d4ea307ab1e58d4e472a43c8548d8e); ?>
<?php endif; ?>

    <div class="space-y-6">

        
        <div
            class="bg-linear-to-r from-sky-500 to-purple-500 text-white rounded-2xl shadow-lg p-6 flex flex-col sm:flex-row justify-between items-center gap-4">
            <div>
                <h2 class="text-2xl font-bold">Deposit #<?php echo e($deposit->id); ?></h2>
                <div class="flex items-center justify-between">
                    <span>Status:</span>
                    <?php
                        $statusClasses = match ($deposit->status) {
                            Deposit::STATUS_APPROVED => 'bg-green-100 text-green-800',
                            Deposit::STATUS_REJECTED => 'bg-red-100 text-red-800',
                            default => 'bg-yellow-100 text-yellow-800',
                        };

                        $statusText = match ($deposit->status) {
                            deposit::STATUS_APPROVED => 'Approved',
                            deposit::STATUS_REJECTED => 'Rejected',
                            default => 'Pending',
                        };
                    ?>

                    <span
                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo e($statusClasses); ?>">
                        <?php echo e($statusText); ?>

                    </span>

                </div>
            </div>

            <div class="flex flex-col sm:flex-row items-center sm:space-x-6 gap-2">
                <div class="text-center sm:text-right">
                    <p class="text-xl font-bold"><?php echo e($currencySymbol . number_format($deposit->total, 2)); ?></p>
                    <p class="text-sm opacity-80">Total Amount</p>
                </div>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deposit->status === 'pending'): ?>
                    <div class="flex space-x-2">
                        <?php if (isset($component)) { $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::button.index','data' => ['wire:click' => 'approveDeposit','variant' => 'primary','color' => 'green']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:click' => 'approveDeposit','variant' => 'primary','color' => 'green']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                            Approve Deposit
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $attributes = $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $component = $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
                        <?php if (isset($component)) { $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::button.index','data' => ['wire:click' => 'rejectDeposit','variant' => 'danger']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:click' => 'rejectDeposit','variant' => 'danger']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                            Reject Deposit
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $attributes = $__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__attributesOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580)): ?>
<?php $component = $__componentOriginalc04b147acd0e65cc1a77f86fb0e81580; ?>
<?php unset($__componentOriginalc04b147acd0e65cc1a77f86fb0e81580); ?>
<?php endif; ?>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>

        
        <div class="lg:flex lg:space-x-6">

            
            <div class="lg:flex-1 space-y-6">

                <div class="lg:flex-1 space-y-6">

                    
                    <div
                        class="bg-white/30 dark:bg-gray-800/30 backdrop-blur-md rounded-xl shadow-lg p-6 grid grid-cols-2 sm:grid-cols-4 gap-6">
                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.currency-dollar','bgColor' => 'bg-sky-100','darkBgColor' => 'dark:bg-sky-800','textColor' => 'text-sky-600','darkTextColor' => 'dark:text-sky-300','label' => 'Amount','value' => ''.e($currencySymbol . number_format($deposit->amount, 2)).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.currency-dollar','bgColor' => 'bg-sky-100','darkBgColor' => 'dark:bg-sky-800','textColor' => 'text-sky-600','darkTextColor' => 'dark:text-sky-300','label' => 'Amount','value' => ''.e($currencySymbol . number_format($deposit->amount, 2)).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.credit-card','bgColor' => 'bg-red-100','darkBgColor' => 'dark:bg-red-800','textColor' => 'text-red-600','darkTextColor' => 'dark:text-red-300','label' => 'Charge','value' => ''.e($currencySymbol . number_format($deposit->charge, 2)).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.credit-card','bgColor' => 'bg-red-100','darkBgColor' => 'dark:bg-red-800','textColor' => 'text-red-600','darkTextColor' => 'dark:text-red-300','label' => 'Charge','value' => ''.e($currencySymbol . number_format($deposit->charge, 2)).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.banknotes','bgColor' => 'bg-green-100','darkBgColor' => 'dark:bg-green-800','textColor' => 'text-green-600','darkTextColor' => 'dark:text-green-300','label' => 'Total','value' => ''.e($currencySymbol . number_format($deposit->total, 2)).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.banknotes','bgColor' => 'bg-green-100','darkBgColor' => 'dark:bg-green-800','textColor' => 'text-green-600','darkTextColor' => 'dark:text-green-300','label' => 'Total','value' => ''.e($currencySymbol . number_format($deposit->total, 2)).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.calendar','bgColor' => 'bg-yellow-100','darkBgColor' => 'dark:bg-yellow-800','textColor' => 'text-yellow-600','darkTextColor' => 'dark:text-yellow-300','label' => 'Date','value' => ''.e($deposit->created_at->diffForHumans()).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.calendar','bgColor' => 'bg-yellow-100','darkBgColor' => 'dark:bg-yellow-800','textColor' => 'text-yellow-600','darkTextColor' => 'dark:text-yellow-300','label' => 'Date','value' => ''.e($deposit->created_at->diffForHumans()).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
                    </div>

                    <div class="flex items-end justify-end">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deposit->paymentMethod): ?>
                            <a href="<?php echo e(route('admin.dashboard', ['paymentMethodId' => $deposit->paymentMethod->id])); ?>"
                                class="text-blue-600 dark:text-blue-400 font-semibold hover:underline">
                                View Deposit Method Information
                            </a>
                        <?php else: ?>
                            <span class="italic text-gray-400">N/A</span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    
                    <div
                        class="bg-white/30 dark:bg-gray-800/30 backdrop-blur-md rounded-xl shadow-lg p-6 grid grid-cols-2 sm:grid-cols-4 gap-6">

                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.wallet','bgColor' => 'bg-indigo-100','darkBgColor' => 'dark:bg-indigo-800','textColor' => 'text-indigo-600','darkTextColor' => 'dark:text-indigo-300','label' => 'Payment Method','value' => ''.e($deposit->paymentMethod->name ?? 'N/A').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.wallet','bgColor' => 'bg-indigo-100','darkBgColor' => 'dark:bg-indigo-800','textColor' => 'text-indigo-600','darkTextColor' => 'dark:text-indigo-300','label' => 'Payment Method','value' => ''.e($deposit->paymentMethod->name ?? 'N/A').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.user-circle','bgColor' => 'bg-purple-100','darkBgColor' => 'dark:bg-purple-800','textColor' => 'text-purple-600','darkTextColor' => 'dark:text-purple-300','label' => 'Account:','value' => ''.e($deposit->account?->account_number ?? 'N/A').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.user-circle','bgColor' => 'bg-purple-100','darkBgColor' => 'dark:bg-purple-800','textColor' => 'text-purple-600','darkTextColor' => 'dark:text-purple-300','label' => 'Account:','value' => ''.e($deposit->account?->account_number ?? 'N/A').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.document-currency-bangladeshi','bgColor' => 'bg-teal-100','darkBgColor' => 'dark:bg-teal-800','textColor' => 'text-teal-600','darkTextColor' => 'dark:text-teal-300','label' => 'Currency:','value' => ''.e($deposit->account?->profile?->currency ?? 'USD').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.document-currency-bangladeshi','bgColor' => 'bg-teal-100','darkBgColor' => 'dark:bg-teal-800','textColor' => 'text-teal-600','darkTextColor' => 'dark:text-teal-300','label' => 'Currency:','value' => ''.e($deposit->account?->profile?->currency ?? 'USD').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>


                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deposit->account?->profile?->user?->referrer): ?>
                            <?php if (isset($component)) { $__componentOriginal3893af9b8487ab105bec37f64149e5a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3893af9b8487ab105bec37f64149e5a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transaction-card','data' => ['icon' => 'flux::icon.user-plus','bgColor' => 'bg-pink-100','darkBgColor' => 'dark:bg-pink-800','textColor' => 'text-pink-600','darkTextColor' => 'dark:text-pink-300','label' => 'Referrer:','value' => ''.e($deposit->account->profile->user->referrer->name).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transaction-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['icon' => 'flux::icon.user-plus','bgColor' => 'bg-pink-100','darkBgColor' => 'dark:bg-pink-800','textColor' => 'text-pink-600','darkTextColor' => 'dark:text-pink-300','label' => 'Referrer:','value' => ''.e($deposit->account->profile->user->referrer->name).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $attributes = $__attributesOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__attributesOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3893af9b8487ab105bec37f64149e5a9)): ?>
<?php $component = $__componentOriginal3893af9b8487ab105bec37f64149e5a9; ?>
<?php unset($__componentOriginal3893af9b8487ab105bec37f64149e5a9); ?>
<?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                </div>


                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deposit->file_path): ?>
                    <?php
                        $fileUrl = Storage::url($deposit->file_path);
                        $fileExt = strtolower(pathinfo($deposit->file_path, PATHINFO_EXTENSION));
                        $imageExtensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp'];
                    ?>

                    <section class="bg-white/30 dark:bg-gray-800/30 backdrop-blur-md rounded-xl shadow-lg p-6">
                        <h3 class="font-semibold text-lg mb-4 text-gray-900 dark:text-white">Uploaded Payment Proof</h3>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(in_array($fileExt, $imageExtensions)): ?>
                            <a href="<?php echo e($fileUrl); ?>" target="_blank"
                                class="block mx-auto w-36 h-36 overflow-hidden rounded-md shadow-md hover:shadow-xl transition">
                                <img src="<?php echo e($fileUrl); ?>" alt="Deposit File"
                                    class="w-full h-full object-cover hover:scale-105 transition-transform duration-200"
                                    loading="lazy" />
                            </a>
                            <p class="mt-2 text-sm text-gray-500 dark:text-gray-400 text-center capitalize">
                                Click to view full image
                            </p>
                        <?php else: ?>
                            <a href="<?php echo e($fileUrl); ?>" target="_blank"
                                class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md transition font-semibold">
                                <?php if (isset($component)) { $__componentOriginalf0d0b0ef1601864f79cd5a4fe6f86b73 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf0d0b0ef1601864f79cd5a4fe6f86b73 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.viewfinder-circle','data' => ['class' => 'w-4 h-4 mr-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.viewfinder-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4 h-4 mr-2']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf0d0b0ef1601864f79cd5a4fe6f86b73)): ?>
<?php $attributes = $__attributesOriginalf0d0b0ef1601864f79cd5a4fe6f86b73; ?>
<?php unset($__attributesOriginalf0d0b0ef1601864f79cd5a4fe6f86b73); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf0d0b0ef1601864f79cd5a4fe6f86b73)): ?>
<?php $component = $__componentOriginalf0d0b0ef1601864f79cd5a4fe6f86b73; ?>
<?php unset($__componentOriginalf0d0b0ef1601864f79cd5a4fe6f86b73); ?>
<?php endif; ?>
                                View File
                            </a>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($deposit->file_description): ?>
                                <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                                    <?php echo e($deposit->file_description); ?>

                                </p>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </section>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            </div>

            
            <div class="lg:w-1/3 mt-6 lg:mt-0 space-y-6 sticky top-6">

                <div
                    class="bg-white/30 dark:bg-gray-800/30 backdrop-blur-md rounded-xl shadow-lg p-6 flex flex-col items-center text-center space-y-4">
                    <?php
                        $user = $deposit->account->profile->user;
                        $avatar = $deposit->account->profile->profile_photo
                            ? Storage::disk('public')->url($deposit->account->profile->profile_photo)
                            : null;
                    ?>

                    <div
                        class="w-28 h-28 rounded-full overflow-hidden border-4 border-sky-500 flex items-center justify-center text-4xl font-semibold bg-gray-300 dark:bg-gray-700">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($avatar): ?>
                            <img src="<?php echo e(asset($avatar)); ?>" alt="User Avatar" class="w-full h-full object-cover">
                        <?php else: ?>
                            <?php echo e(strtoupper(substr($user->name ?? 'N/A', 0, 1))); ?>

                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <h4 class="font-bold text-lg text-gray-900 dark:text-white"><?php echo e($user->name ?? 'N/A'); ?></h4>
                    <p class="text-gray-500 dark:text-gray-400 lowercase"><?php echo e($user->email ?? 'N/A'); ?></p>
                    <span
                        class="px-3 py-1 bg-sky-100 dark:bg-sky-700 text-sky-800 dark:text-white rounded-full text-sm font-medium">
                        KYC: <?php echo e(ucfirst($user->kyc_status)); ?>

                    </span>

                    <a href="<?php echo e(route('admin.users.show', $user)); ?>"
                        class="mt-3 px-5 py-2 bg-sky-600 hover:bg-sky-700 text-white font-semibold rounded-lg transition">
                        View Profile
                    </a>
                </div>

                
                <div class=" text-sm text-gray-600 dark:text-gray-400">
                    <div class="bg-gray-100 dark:bg-gray-900 p-4 rounded-xl shadow-sm">
                        <p class="font-medium">Last Updated</p>
                        <p><?php echo e($deposit->updated_at->toDayDateTimeString()); ?></p>
                    </div>
                </div>

            </div>

        </div>
    </div>




</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/pages/admin/deposit/⚡show.blade.php ENDPATH**/ ?>