<?php

use Livewire\Component;
use Livewire\Attributes\On;

new class extends Component {
    public int $unreadCount = 0;
    public array $notifications = [];
    public $admin;

    public function mount()
    {
        $this->admin = auth()->guard('admin')->user();

        $this->refreshUnreadCount();
        $this->loadNotifications();
    }

    /**
     * Load the latest notifications for the admin.
     */
    public function loadNotifications(): void
    {
        $admin = auth()->guard('admin')->user();

        $this->notifications = $admin->notifications()->latest()->take(5)->get()->toArray();
    }

    /**
     * Refresh unread notification count.
     */
    public function refreshUnreadCount(): void
    {
        $this->unreadCount = auth()->guard('admin')->user()->unreadNotifications()->count();
    }

    /**
     * Mark a notification as read.
     */
    public function markAsRead(string $id): void
    {
        $note = auth()->guard('admin')->user()->unreadNotifications()->find($id);

        if ($note) {
            $note->markAsRead();
        }

        $this->refreshUnreadCount();
        $this->loadNotifications();
    }

    /**
     * Listen for new notifications sent.
     */
    #[On('notification-sent')]
    public function handleNewNotification(): void
    {
        $this->refreshUnreadCount();
        $this->loadNotifications();
    }

    /**
     * Optional: listen for notifications read event.
     */
    #[On('notifications-read')]
    public function handleNotificationsRead(): void
    {
        $this->refreshUnreadCount();
        $this->loadNotifications();
    }
};
?>


<div
    class="px-6 py-4 bg-white dark:bg-zinc-900 shadow-sm border-b border-gray-200 dark:border-zinc-700 flex items-center justify-between">
    <!-- Mobile hamburger -->
    <div wire:ignore class="flex items-center gap-2">
        <div class="lg:hidden z-50">
            <button @click="opensidebar = !opensidebar"
                class="relative w-8 h-8 flex flex-col justify-center items-center gap-1.5 p-2 bg-white dark:bg-gray-800 text-rose-600 dark:text-white rounded-md shadow-md focus:outline-none focus:ring-2 focus:ring-rose-500">

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = ['', '', '']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <span
                        :class="opensidebar
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ? ['first:rotate-45 absolute', 'second:opacity-0', 'third:-rotate-45 absolute'][$loop->index] 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                : ''"
                        class="block w-6 h-0.5 bg-current transition-transform duration-500 ease-[cubic-bezier(0.68,-0.55,0.27,1.55)]
                           transition-opacity duration-500 scale-80"></span>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
            </button>
        </div>
    </div>

    <!-- Right: Notifications & Profile -->
    <div class="flex items-center gap-4">
        <!-- Dark Mode Toggle with animation -->
        <button @click="darkMode = !darkMode; localStorage.setItem('darkMode', darkMode)"
            class="relative p-3 rounded-2xl bg-linear-to-br from-gray-50 to-gray-100 
               dark:from-gray-800 dark:to-gray-700 text-gray-600 dark:text-gray-300 
               hover:from-primary-50 hover:to-primary-100 
               dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 
               transition-all duration-300 shadow-lg hover:shadow-xl 
               hover:-translate-y-0.5 group">
            <?php if (isset($component)) { $__componentOriginald5f987720f2b51852a6659d9a2c7a66b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald5f987720f2b51852a6659d9a2c7a66b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.sun','data' => ['variant' => 'solid','xShow' => '!darkMode','xCloak' => true,'class' => 'w-5 h-5 group-hover:rotate-180 transition-transform duration-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.sun'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','x-show' => '!darkMode','x-cloak' => true,'class' => 'w-5 h-5 group-hover:rotate-180 transition-transform duration-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald5f987720f2b51852a6659d9a2c7a66b)): ?>
<?php $attributes = $__attributesOriginald5f987720f2b51852a6659d9a2c7a66b; ?>
<?php unset($__attributesOriginald5f987720f2b51852a6659d9a2c7a66b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald5f987720f2b51852a6659d9a2c7a66b)): ?>
<?php $component = $__componentOriginald5f987720f2b51852a6659d9a2c7a66b; ?>
<?php unset($__componentOriginald5f987720f2b51852a6659d9a2c7a66b); ?>
<?php endif; ?>

            <?php if (isset($component)) { $__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.moon','data' => ['variant' => 'solid','xCloak' => true,'xShow' => 'darkMode','class' => 'w-5 h-5 group-hover:rotate-12 transition-transform duration-300']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.moon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','x-cloak' => true,'x-show' => 'darkMode','class' => 'w-5 h-5 group-hover:rotate-12 transition-transform duration-300']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2)): ?>
<?php $attributes = $__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2; ?>
<?php unset($__attributesOriginal8aa8d5bc914d8b570a9db7c847a44cc2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2)): ?>
<?php $component = $__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2; ?>
<?php unset($__componentOriginal8aa8d5bc914d8b570a9db7c847a44cc2); ?>
<?php endif; ?>
        </button>
        <!-- Notifications -->
        <div class="relative" x-data="{ openDropdown: null }">
            <button @click="openDropdown = (openDropdown === 'notifications' ? null : 'notifications')"
                class="relative p-2 rounded-full hover:bg-sky-100 dark:hover:bg-sky-900 focus:outline-none transition">
                <?php if (isset($component)) { $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bell','data' => ['class' => 'w-6 h-6 '.e($unreadCount > 0 ? 'text-sky-500 animate-pulse' : 'text-gray-500 dark:text-gray-300').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bell'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 '.e($unreadCount > 0 ? 'text-sky-500 animate-pulse' : 'text-gray-500 dark:text-gray-300').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $attributes = $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $component = $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>

                
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($unreadCount > 0): ?>
                    <span
                        class="absolute -top-1 -right-1 bg-sky-500 text-white rounded-full w-5 h-5 flex items-center justify-center text-[10px] font-semibold shadow">
                        <?php echo e($unreadCount); ?>

                    </span>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </button>

            
            <div x-show="openDropdown === 'notifications'" x-collapse x-cloak
                class="absolute right-0 w-96 max-h-96 overflow-y-auto bg-white dark:bg-zinc-900 shadow-2xl rounded-xl border border-gray-200 dark:border-zinc-700 mt-2 z-50">

                <div class="py-2 px-3 border-b border-gray-200 dark:border-zinc-700">
                    <h4 class="text-sm font-semibold text-gray-700 dark:text-gray-200">Notifications</h4>
                </div>

                <div class="divide-y divide-gray-100 dark:divide-zinc-800">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <?php
                            $link = $notification['data']['link'] ?? null;
                        ?>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($link): ?>
                            <a href="<?php echo e($link); ?>" class="block">
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <div class="flex items-start gap-3 p-3 hover:bg-sky-50 dark:hover:bg-sky-900 rounded-lg transition cursor-pointer"
                            <?php if(!$link): ?> wire:click="markAsRead('<?php echo e($notification['id']); ?>')" <?php endif; ?>>

                            <div class="shrink-0">
                                <?php if (isset($component)) { $__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bell-alert','data' => ['class' => 'w-5 h-5 text-sky-500 mt-1']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bell-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 text-sky-500 mt-1']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9)): ?>
<?php $attributes = $__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9; ?>
<?php unset($__attributesOriginalf67e64b87e7f70aa9792ea8ff544a0c9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9)): ?>
<?php $component = $__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9; ?>
<?php unset($__componentOriginalf67e64b87e7f70aa9792ea8ff544a0c9); ?>
<?php endif; ?>
                            </div>

                            <div class="flex-1 min-w-0">
                                <p class="text-sm font-medium text-gray-900 dark:text-gray-100">
                                    <?php echo e($notification['data']['title'] ?? 'Notification'); ?>

                                </p>

                                <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    <?php echo e($notification['data']['message'] ?? ''); ?>

                                </p>

                                <span class="text-[10px] text-gray-400 dark:text-gray-500 mt-1 block">
                                    <?php echo e(\Illuminate\Support\Carbon::parse($notification['created_at'])->diffForHumans()); ?>

                                </span>
                            </div>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$notification['read_at']): ?>
                                <span class="ml-2 shrink-0 w-2 h-2 bg-sky-500 rounded-full mt-1"></span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($link): ?>
                            </a>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <p class="text-center text-gray-400 dark:text-gray-500 py-6 text-sm">
                            No new notifications
                        </p>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <div class="text-center py-2">
                    <a href="<?php echo e(route('user.transactions')); ?>"
                        class="text-sky-600 hover:text-sky-700 dark:text-sky-400 dark:hover:text-sky-300 text-sm font-medium transition">
                        View All
                    </a>
                </div>
            </div>
        </div>


        <!-- Profile -->
        <div
            class="flex items-center gap-3 px-3 py-2 rounded-full bg-white/60 dark:bg-gray-900/60
            ring-1 ring-gray-200 dark:ring-gray-700 shadow-sm">

            <!-- Name -->
            <div class="text-right leading-tight">
                <p class="text-sm font-semibold text-gray-900 dark:text-gray-100">
                    <?php echo e($admin->name ?? 'Admin'); ?>

                </p>
                <p class="text-[11px] text-gray-500 dark:text-gray-400">
                    Administrator
                </p>
            </div>

            <!-- Avatar -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($admin->avatar): ?>
                <img src="<?php echo e(Storage::disk('public')->url($admin->avatar)); ?>"
                    class="w-12 h-12 rounded-full object-cover shadow" />
            <?php else: ?>
                <div
                    class="w-12 h-12 rounded-full bg-gray-200 dark:bg-gray-700 flex items-center justify-center text-gray-500 dark:text-gray-400 font-semibold text-lg">
                    <?php echo e(strtoupper(substr($admin->name, 0, 1))); ?>

                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        </div>

    </div>
</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/⚡admin-top-bar.blade.php ENDPATH**/ ?>