<?php if (isset($component)) { $__componentOriginalde7351e060091d622377605e583428b9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalde7351e060091d622377605e583428b9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.emails.layout','data' => ['subject' => 'Tax Refund Receipt','headerTitle' => config('app.name'),'headerUrl' => route('user.dashboard')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('emails.layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['subject' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Tax Refund Receipt'),'headerTitle' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(config('app.name')),'headerUrl' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(route('user.dashboard'))]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>


    <!-- Header -->
    <h1 style="margin:0 0 20px 0; font-size:28px; font-weight:700; color:#0369a1; text-align:center;">
        Tax Refund Receipt
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong><?php echo e($user->name); ?></strong>,
    </p>

    <!-- Intro Message -->
    <p style="margin:0 0 30px 0; font-size:16px; line-height:1.6; color:#555;">
        Your tax refund request has been processed. Here are the details of your submission.
    </p>

    <!-- Refund Details -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Refund Details
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:20px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Filing Number</th>
            <td><?php echo e($refund->filing_number); ?></td>
        </tr>
        <tr>
            <th align="left">Status</th>
            <td><?php echo e(ucfirst($refund->status)); ?></td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Submission Date</th>
            <td><?php echo e($refund->created_at->format('Y-m-d H:i:s')); ?></td>
        </tr>
        <tr>
            <th align="left">Review Due Date</th>
            <td><?php echo e($refund->review_due_date?->format('Y-m-d') ?? '-'); ?></td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Amount</th>
            <td>$<?php echo e(number_format($refund->amount ?? 0, 2)); ?></td>
        </tr>
    </table>

    <!-- User Details -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        User Details
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:20px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Full Name</th>
            <td><?php echo e($refund->full_name); ?></td>
        </tr>
        <tr>
            <th align="left">Email</th>
            <td><?php echo e($refund->email); ?></td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Country</th>
            <td><?php echo e($refund->country_code); ?></td>
        </tr>
        <tr>
            <th align="left">State</th>
            <td><?php echo e($refund->state); ?></td>
        </tr>
    </table>

    <!-- Tax Information -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Tax Information
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:20px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Filing Status</th>
            <td><?php echo e($refund->meta['filing_status'] ?? '-'); ?></td>
        </tr>
        <tr>
            <th align="left">Income</th>
            <td>$<?php echo e(number_format($refund->meta['income'] ?? 0, 2)); ?></td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Taxes Withheld</th>
            <td>$<?php echo e(number_format($refund->meta['taxes_withheld'] ?? 0, 2)); ?></td>
        </tr>
        <tr>
            <th align="left">Deductions</th>
            <td>$<?php echo e(number_format($refund->meta['deductions'] ?? 0, 2)); ?></td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Credits</th>
            <td>$<?php echo e(number_format($refund->meta['credits'] ?? 0, 2)); ?></td>
        </tr>
    </table>

    <!-- Status History -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Status History
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:30px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Status</th>
            <th align="left">Notes</th>
            <th align="left">Changed At</th>
        </tr>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $statusHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
            <tr <?php if($loop->even): ?> style="background:#f9f9f9;" <?php endif; ?>>
                <td><?php echo e(ucfirst($history->status)); ?></td>
                <td><?php echo e($history->notes ?? '-'); ?></td>
                <td><?php echo e($history->changed_at?->format('Y-m-d H:i:s') ?? $history->created_at->format('Y-m-d H:i:s')); ?>

                </td>
            </tr>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
    </table>

    <!-- Download Button -->
    <div style="text-align:center; margin:30px 0;">
        <a href="<?php echo e($downloadUrl ?? '#'); ?>"
            style="display:inline-block; background:#0369a1; color:#ffffff; font-size:16px; font-weight:600;
                  text-decoration:none; padding:14px 36px; border-radius:8px;">
            Download Receipt (PDF)
        </a>
    </div>

    <!-- Footer / Info -->
    <p style="font-size:13px; color:#888; text-align:center; line-height:1.5; margin-bottom:10px;">
        Date: <strong><?php echo e(now()->toDayDateTimeString()); ?></strong>
    </p>
    <p style="font-size:13px; color:#888; text-align:center; line-height:1.5; margin-bottom:20px;">
        This is an automated message. Please do not reply.
    </p>

    <p style="font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for choosing <strong><?php echo e(config('app.name')); ?></strong>.<br>
        &mdash; The <?php echo e(config('app.name')); ?> Team
    </p>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalde7351e060091d622377605e583428b9)): ?>
<?php $attributes = $__attributesOriginalde7351e060091d622377605e583428b9; ?>
<?php unset($__attributesOriginalde7351e060091d622377605e583428b9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalde7351e060091d622377605e583428b9)): ?>
<?php $component = $__componentOriginalde7351e060091d622377605e583428b9; ?>
<?php unset($__componentOriginalde7351e060091d622377605e583428b9); ?>
<?php endif; ?>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/emails/tax-refund-receipt.blade.php ENDPATH**/ ?>