<!-- User / Footer -->
<div class="border-t border-gray-200 dark:border-zinc-700 p-4 space-y-3">
    <a href="<?php echo e(route('user.settings.index')); ?>"
        class="flex items-center gap-3 px-3 py-2 rounded-lg
                hover:bg-gray-100 dark:hover:bg-zinc-800 transition">
        <div x-data="{ avatarUrl: '<?php echo e($avatarUrl); ?>' }" x-on:profile-updated.window="avatarUrl = $event.detail.photoUrl ?? avatarUrl"
            class="h-9 w-9 rounded-full overflow-hidden cursor-pointer">
            <template x-if="avatarUrl">
                <img :src="avatarUrl" class="h-full w-full object-cover">
            </template>
            <template x-if="!avatarUrl">
                <span
                    class="flex items-center justify-center h-full w-full bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 font-semibold">
                    <?php echo e($authUser->initials()); ?>

                </span>
            </template>

        </div>

        <div class="leading-tight">
            <p class="font-semibold text-gray-900 dark:text-white"><?php echo e($authUser->name); ?></p>
            <p class="text-xs text-gray-500">View profile</p>
        </div>
    </a>

    <form method="POST" action="<?php echo e(route('user.logout')); ?>">
        <?php echo csrf_field(); ?>
        <button type="submit"
            class="w-full flex items-center gap-3 px-3 py-2 rounded-lg
                    text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/30 transition">
            <?php if (isset($component)) { $__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.index','data' => ['name' => 'arrow-left-start-on-rectangle','class' => 'h-5 w-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'arrow-left-start-on-rectangle','class' => 'h-5 w-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2)): ?>
<?php $attributes = $__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2; ?>
<?php unset($__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2)): ?>
<?php $component = $__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2; ?>
<?php unset($__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2); ?>
<?php endif; ?>
            <span class="text-sm font-semibold">Log out</span>
        </button>
    </form>
</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/partials/admin/sidebar-footer.blade.php ENDPATH**/ ?>