<?php

use Livewire\Component;
use Illuminate\Support\Facades\Auth;

new class extends Component {
    public $trustedDevices = [];

    public function mount()
    {
        $this->loadDevices();
    }

    public function loadDevices()
    {
        $this->trustedDevices = Auth::user()->trustedDevices()->orderByDesc('last_used_at')->get();
    }

    public function revokeDevice(int $deviceId): void
    {
        $device = Auth::user()->trustedDevices()->whereKey($deviceId)->first();

        if (!$device) {
            $this->dispatch('showToast', message: 'Device not found or already revoked.', type: 'warning');

            return;
        }

        $device->delete();

        $this->dispatch('showToast', message: 'Trusted device revoked.', type: 'success');

        $this->loadDevices();
    }
};
?>

 <?php $__env->slot('title', null, []); ?> 
    <?php echo e(config('app.name')); ?> || Manage Trusted Device's
 <?php $__env->endSlot(); ?>

<section class="w-full py-5">
    <?php if (isset($component)) { $__componentOriginal951a5936e8413b65cd052beecc1fba57 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951a5936e8413b65cd052beecc1fba57 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.settings.layout','data' => ['heading' => __('Trusted Devices'),'subheading' => __('Manage your trusted devices and revoke access')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('settings.layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['heading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Trusted Devices')),'subheading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Manage your trusted devices and revoke access'))]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

        <section class="md:col-span-3 bg-white dark:bg-gray-900 rounded-2xl p-6 shadow-sm space-y-6">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($trustedDevices->count()): ?>
                <div class="space-y-6">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $trustedDevices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <?php
                            $lastUsed = $device->last_used_at;
                            $isActive = $lastUsed && $lastUsed->greaterThan(now()->subDays(7));
                        ?>

                        <div
                            class="flex items-center justify-between bg-gray-50 dark:bg-gray-800 rounded-md p-4 shadow-sm">
                            <div class="flex items-start space-x-4 grow min-w-0">
                                <div class="text-[#0E4D92] dark:text-[#F78F20] shrink-0">
                                    <?php if (isset($component)) { $__componentOriginalf08af65e6f8e1abc9ae6e66c02da0bd2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf08af65e6f8e1abc9ae6e66c02da0bd2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.device-phone-mobile','data' => ['class' => 'w-7 h-7']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.device-phone-mobile'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-7 h-7']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf08af65e6f8e1abc9ae6e66c02da0bd2)): ?>
<?php $attributes = $__attributesOriginalf08af65e6f8e1abc9ae6e66c02da0bd2; ?>
<?php unset($__attributesOriginalf08af65e6f8e1abc9ae6e66c02da0bd2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf08af65e6f8e1abc9ae6e66c02da0bd2)): ?>
<?php $component = $__componentOriginalf08af65e6f8e1abc9ae6e66c02da0bd2; ?>
<?php unset($__componentOriginalf08af65e6f8e1abc9ae6e66c02da0bd2); ?>
<?php endif; ?>
                                </div>

                                <div class="truncate max-w-xs">
                                    <p class="font-semibold text-gray-900 dark:text-gray-100 truncate">
                                        <?php echo e($device->device_type); ?>

                                        —
                                        <span class="font-normal">
                                            <?php echo e($device->browser); ?> on <?php echo e($device->platform); ?>

                                        </span>
                                    </p>

                                    <div class="mt-2 text-gray-600 dark:text-gray-400 text-xs space-y-1">
                                        <p><strong>IP:</strong> <?php echo e($device->ip_address ?? 'Unknown'); ?></p>
                                        <p>
                                            <strong>Last used:</strong>
                                            <?php echo e($device->last_used_at?->diffForHumans() ?? 'Never used'); ?>

                                        </p>
                                        <p class="italic truncate">
                                            <strong>User agent:</strong>
                                            <?php echo e($device->user_agent ?? 'Unknown'); ?>

                                        </p>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-col items-end space-y-2 ml-4 shrink-0">
                                <span
                                    class="px-3 py-0.5 rounded-full text-xs font-semibold
                                        <?php echo e($isActive
                                            ? 'bg-green-200 text-green-800 dark:bg-green-700 dark:text-green-100'
                                            : 'bg-gray-200 text-gray-700 dark:bg-gray-600 dark:text-gray-300'); ?>">
                                    <?php echo e($isActive ? 'Active' : 'Inactive'); ?>

                                </span>

                                <?php if (isset($component)) { $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['variant' => 'danger','wire:click' => 'revokeDevice('.e($device->id).')','wire:confirm' => 'Are you sure you want to revoke this trusted device?']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'danger','wire:click' => 'revokeDevice('.e($device->id).')','wire:confirm' => 'Are you sure you want to revoke this trusted device?']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                                    Revoke device
                                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $attributes = $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $component = $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
                            </div>
                        </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                </div>
            <?php else: ?>
                <p class="text-center text-gray-600 dark:text-gray-400 italic mt-6">
                    You have no trusted devices stored.
                </p>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </section>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951a5936e8413b65cd052beecc1fba57)): ?>
<?php $attributes = $__attributesOriginal951a5936e8413b65cd052beecc1fba57; ?>
<?php unset($__attributesOriginal951a5936e8413b65cd052beecc1fba57); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951a5936e8413b65cd052beecc1fba57)): ?>
<?php $component = $__componentOriginal951a5936e8413b65cd052beecc1fba57; ?>
<?php unset($__componentOriginal951a5936e8413b65cd052beecc1fba57); ?>
<?php endif; ?>
</section>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/pages/user/settings/⚡trusted-device.blade.php ENDPATH**/ ?>