 <?php $__env->slot('title', null, []); ?> 
    <?php echo e(config('app.name')); ?> || Customer Dashboard
 <?php $__env->endSlot(); ?>

<div class="py-3 space-y-4">

    <div class="mb-4">
        <?php $filters = [ 'all' => 'All', 'yesterday' => 'Yesterday', 'this_week' => 'This Week', 'last_week' => 'Last Week', 'this_month' => 'This Month', 'last_month' => 'Last Month' ]; ?>
        <!-- Desktop buttons -->
        <div class="hidden sm:inline-flex flex-wrap rounded-xl bg-gray-200 dark:bg-zinc-800 p-1"
            wire:transition="content">
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <button wire:click="updateFilter('<?php echo e($key); ?>')" wire:loading.class="opacity-50"
                    class="px-4 py-1.5 text-sm font-medium rounded-lg transition-all duration-200
                    <?php echo e($filter === $key
                        ? 'bg-white dark:bg-zinc-900 text-sky-600 shadow-sm'
                        : 'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white'); ?>">
                    <?php echo e($label); ?>

                </button>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
        </div>

        <!-- Mobile dropdown -->
        <div class="sm:hidden " x-data="{ open: false }">
            <button @click="open = !open" class="p-2 rounded-full border-2  hover:bg-gray-300 dark:hover:bg-zinc-700">
                <!-- Three dots icon -->
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-gray-600 dark:text-gray-400" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 6v.01M12 12v.01M12 18v.01" />
                </svg>
            </button>

            <!-- Dropdown menu -->
            <div x-show="open" x-cloak @click.away="open = false" x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100 scale-100"
                x-transition:leave-end="opacity-0 scale-95"
                class="mt-2 bg-gray-200 dark:bg-zinc-800 rounded-xl shadow-lg py-2 w-40 absolute z-10">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $filters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <button @click="open = false; $wire.updateFilter('<?php echo e($key); ?>')"
                        class="block w-full text-left px-4 py-2 text-sm text-gray-600 dark:text-gray-400 hover:bg-gray-300 dark:hover:bg-zinc-700 rounded-lg
                        <?php echo e($filter === $key ? 'font-semibold text-sky-600' : ''); ?>">
                        <?php echo e($label); ?>

                    </button>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
            </div>
        </div>
    </div>

    <div class="space-y-5">
        <p class="text-sm text-gray-500 dark:text-gray-400 mb-2">
            Showing: <span class="font-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $filter))); ?></span>
        </p>

        <?php echo $__env->make('partials.ui-card', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 w-full gap-4">
        <div class="md:col-span-2 flex flex-col space-y-4">
            <?php echo $__env->make('partials.quick-account', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            <div
                class="bg-white dark:bg-gray-800 rounded-xl p-4 shadow-sm dark:shadow-gray-900/25 border border-gray-100 dark:border-gray-700">
                <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-4">Quick Actions</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    <a href="<?php echo e(route('user.local.transfer')); ?>"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-sky-500 rounded-lg flex items-center justify-center mb-2">
                            <?php if (isset($component)) { $__componentOriginalda6e47aecf1695047ea823532321ccd7 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalda6e47aecf1695047ea823532321ccd7 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrows-right-left','data' => ['variant' => 'solid','class' => 'w-5 h-5 text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrows-right-left'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5 text-white']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $attributes = $__attributesOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__attributesOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalda6e47aecf1695047ea823532321ccd7)): ?>
<?php $component = $__componentOriginalda6e47aecf1695047ea823532321ccd7; ?>
<?php unset($__componentOriginalda6e47aecf1695047ea823532321ccd7); ?>
<?php endif; ?>
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Transfer</span>
                    </a>
                    <a href="<?php echo e(route('user.international.transfer')); ?>"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center mb-2">
                            <?php if (isset($component)) { $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.clipboard-document','data' => ['variant' => 'solid','class' => 'w-5 h-5 text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.clipboard-document'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5 text-white']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $attributes = $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $component = $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Pay Bills</span>
                    </a>
                    <a href="<?php echo e(route('user.deposit')); ?>"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-sky-800 rounded-lg flex items-center justify-center mb-2">
                            <?php if (isset($component)) { $__componentOriginal970eea507e21d10a438cf9d4525d45dc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal970eea507e21d10a438cf9d4525d45dc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.currency-dollar','data' => ['variant' => 'solid','class' => 'w-5 h-5 text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.currency-dollar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5 text-white']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal970eea507e21d10a438cf9d4525d45dc)): ?>
<?php $attributes = $__attributesOriginal970eea507e21d10a438cf9d4525d45dc; ?>
<?php unset($__attributesOriginal970eea507e21d10a438cf9d4525d45dc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal970eea507e21d10a438cf9d4525d45dc)): ?>
<?php $component = $__componentOriginal970eea507e21d10a438cf9d4525d45dc; ?>
<?php unset($__componentOriginal970eea507e21d10a438cf9d4525d45dc); ?>
<?php endif; ?>
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Request</span>
                    </a>
                    <button type="button" @click="$dispatch('open-bank-details-modal')"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-sky-500 rounded-lg flex items-center text-white justify-center mb-2">
                            <?php if (isset($component)) { $__componentOriginalf432e86c7e5ebcd2aa197aac0894d525 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.building-library','data' => ['variant' => 'solid','class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.building-library'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525)): ?>
<?php $attributes = $__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525; ?>
<?php unset($__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf432e86c7e5ebcd2aa197aac0894d525)): ?>
<?php $component = $__componentOriginalf432e86c7e5ebcd2aa197aac0894d525; ?>
<?php unset($__componentOriginalf432e86c7e5ebcd2aa197aac0894d525); ?>
<?php endif; ?>
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Bank Details</span>
                    </button>

                    
                    <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['@openBankDetailsModal.window' => 'openModal()','@closeBankDetailsModal.window' => 'close()']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['@open-bank-details-modal.window' => 'openModal()','@close-bank-details-modal.window' => 'close()']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                        <div class="space-y-6">

                            <!-- Header -->
                            <div class="text-center space-y-2">
                                <div
                                    class="w-12 h-12 bg-sky-800 rounded-xl mx-auto flex items-center justify-center text-white">
                                    <?php if (isset($component)) { $__componentOriginalf432e86c7e5ebcd2aa197aac0894d525 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.building-library','data' => ['class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.building-library'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525)): ?>
<?php $attributes = $__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525; ?>
<?php unset($__attributesOriginalf432e86c7e5ebcd2aa197aac0894d525); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf432e86c7e5ebcd2aa197aac0894d525)): ?>
<?php $component = $__componentOriginalf432e86c7e5ebcd2aa197aac0894d525; ?>
<?php unset($__componentOriginalf432e86c7e5ebcd2aa197aac0894d525); ?>
<?php endif; ?>
                                </div>
                                <h2 class="text-base font-semibold tracking-wide capitalize">Bank Account Details</h2>
                                <span class="text-sm text-gray-600 dark:text-sky-200"><?php echo e(config('app.name')); ?></span>
                            </div>

                            <!-- Account Information -->
                            <div class="space-y-4">

                                <!-- Section Header -->
                                <div class="flex items-center gap-2 text-sky-600">
                                    <?php if (isset($component)) { $__componentOriginal1f8061448e375a811323d4736f7bf58b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1f8061448e375a811323d4736f7bf58b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.information-circle','data' => ['class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.information-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1f8061448e375a811323d4736f7bf58b)): ?>
<?php $attributes = $__attributesOriginal1f8061448e375a811323d4736f7bf58b; ?>
<?php unset($__attributesOriginal1f8061448e375a811323d4736f7bf58b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1f8061448e375a811323d4736f7bf58b)): ?>
<?php $component = $__componentOriginal1f8061448e375a811323d4736f7bf58b; ?>
<?php unset($__componentOriginal1f8061448e375a811323d4736f7bf58b); ?>
<?php endif; ?>
                                    <h3 class="font-semibold tracking-wide text-sm">Account Information</h3>
                                </div>

                                <!-- Account Fields -->
                                <div class="grid grid-cols-1 gap-4">

                                    <!-- Account Name -->
                                    <div x-data="{ copied: false }"
                                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">
                                            Account Name</h4>
                                        <div class="flex items-center justify-between">
                                            <span class="font-medium"><?php echo e($authUser->name); ?></span>
                                            <button
                                                @click="
                                                navigator.clipboard.writeText('<?php echo e($authUser->name); ?>').then(() => {
                                                    copied = true;
                                                    setTimeout(() => copied = false, 2000);
                                                })
                                            "
                                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                                <template x-if="!copied">
                                                    <?php if (isset($component)) { $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.clipboard-document','data' => ['class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.clipboard-document'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $attributes = $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $component = $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
                                                </template>
                                                <template x-if="copied">
                                                    <?php if (isset($component)) { $__componentOriginal9c2dfd6cb98f4df18e26d1694500af11 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.check','data' => ['class' => 'w-5 h-5 text-green-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 text-green-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11)): ?>
<?php $attributes = $__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11; ?>
<?php unset($__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9c2dfd6cb98f4df18e26d1694500af11)): ?>
<?php $component = $__componentOriginal9c2dfd6cb98f4df18e26d1694500af11; ?>
<?php unset($__componentOriginal9c2dfd6cb98f4df18e26d1694500af11); ?>
<?php endif; ?>
                                                </template>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Account Number -->
                                    <div x-data="{ copied: false }"
                                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">
                                            Account Number
                                        </h4>
                                        <div class="flex items-center justify-between">
                                            <span
                                                class="font-medium"><?php echo e($this->getFocusedAccount()->account_number); ?></span>
                                            <button
                                                @click="
                                                navigator.clipboard.writeText('<?php echo e($this->getFocusedAccount()->account_number); ?>').then(() => {
                                                    copied = true;
                                                    setTimeout(() => copied = false, 2000);
                                                })
                                            "
                                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                                <template x-if="!copied">
                                                    <?php if (isset($component)) { $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.clipboard-document','data' => ['class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.clipboard-document'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $attributes = $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $component = $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
                                                </template>
                                                <template x-if="copied">
                                                    <?php if (isset($component)) { $__componentOriginal9c2dfd6cb98f4df18e26d1694500af11 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.check','data' => ['class' => 'w-5 h-5 text-green-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 text-green-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11)): ?>
<?php $attributes = $__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11; ?>
<?php unset($__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9c2dfd6cb98f4df18e26d1694500af11)): ?>
<?php $component = $__componentOriginal9c2dfd6cb98f4df18e26d1694500af11; ?>
<?php unset($__componentOriginal9c2dfd6cb98f4df18e26d1694500af11); ?>
<?php endif; ?>
                                                </template>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Bitcoin Wallet -->
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $userCryptoBalances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                                        <div x-data="{ copied: false }"
                                            class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">

                                            <h4
                                                class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">
                                                <?php echo e($crypto->label()); ?> Wallet
                                            </h4>

                                            <div class="flex items-center justify-between">
                                                
                                                <span class="font-medium truncate">
                                                    <?php echo e($crypto->available_balance); ?> <?php echo e(strtoupper($crypto->code)); ?>

                                                </span>

                                                
                                                <button
                                                    @click="
                    navigator.clipboard.writeText('<?php echo e($crypto->available_balance); ?>').then(() => {
                        copied = true;
                        setTimeout(() => copied = false, 2000);
                    })
                "
                                                    class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">

                                                    <template x-if="!copied">
                                                        <?php if (isset($component)) { $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.clipboard-document','data' => ['class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.clipboard-document'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $attributes = $__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__attributesOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692)): ?>
<?php $component = $__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692; ?>
<?php unset($__componentOriginal4da0fb5c2f91d5abdd541ee46e42b692); ?>
<?php endif; ?>
                                                    </template>

                                                    <template x-if="copied">
                                                        <?php if (isset($component)) { $__componentOriginal9c2dfd6cb98f4df18e26d1694500af11 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.check','data' => ['class' => 'w-5 h-5 text-green-500']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 text-green-500']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11)): ?>
<?php $attributes = $__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11; ?>
<?php unset($__attributesOriginal9c2dfd6cb98f4df18e26d1694500af11); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9c2dfd6cb98f4df18e26d1694500af11)): ?>
<?php $component = $__componentOriginal9c2dfd6cb98f4df18e26d1694500af11; ?>
<?php unset($__componentOriginal9c2dfd6cb98f4df18e26d1694500af11); ?>
<?php endif; ?>
                                                    </template>
                                                </button>
                                            </div>

                                            
                                            <div class="space-y-2 text-sm mt-2">
                                                <div class="flex justify-between text-gray-500">
                                                    <span>Total</span>
                                                    <span class="font-medium text-gray-800 dark:text-gray-200">
                                                        <?php echo e($crypto->balance); ?>

                                                    </span>
                                                </div>

                                                <div class="flex justify-between text-gray-500">
                                                    <span>Locked</span>
                                                    <span class="font-medium text-yellow-500">
                                                        <?php echo e($crypto->locked_balance); ?>

                                                    </span>
                                                </div>
                                            </div>

                                            
                                            <div
                                                class="mt-4 pt-3 border-t border-gray-200 dark:border-gray-700 flex items-center justify-between text-xs">
                                                <span class="text-gray-500">Rate</span>
                                                <span class="font-semibold text-gray-800 dark:text-gray-200">
                                                    $<?php echo e(number_format((float) $crypto->getRate(), 2)); ?>

                                                </span>
                                            </div>
                                        </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>


                                </div>

                            </div>

                            <!-- Security Notice -->
                            <div
                                class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg flex flex-col sm:flex-row gap-3 items-start sm:items-center shadow-sm">
                                <?php if (isset($component)) { $__componentOriginalf870514c33bb1b53395ba02235f60146 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf870514c33bb1b53395ba02235f60146 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.shield-check','data' => ['class' => 'w-5 h-5 text-green-500 shrink-0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.shield-check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5 text-green-500 shrink-0']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $attributes = $__attributesOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__attributesOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $component = $__componentOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__componentOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
                                <div class="space-y-1">
                                    <h3 class="font-semibold text-sm tracking-wide">Security Notice</h3>
                                    <p class="text-xs text-gray-600 dark:text-sky-200 leading-relaxed">
                                        Always contact <strong><?php echo e(config('app.name')); ?></strong> Support before making
                                        payments to
                                        verify account details.
                                    </p>
                                </div>
                            </div>

                            <div class="flex items-end justify-end">
                                <button type="button" @click="$dispatch('close-bank-details-modal')"
                                    class=" bg-red-700 text-white shadow-lg text-xs font-medium rounded-full p-2 hover:bg-red-600 hover:scale-110 transition-transform duration-150 flex items-center justify-center focus:outline-none focus:ring-2 focus:ring-red-400 capitalize">
                                    <?php if (isset($component)) { $__componentOriginal155e76c41fe51242bc25d269fabf82f5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal155e76c41fe51242bc25d269fabf82f5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.x-mark','data' => ['class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.x-mark'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal155e76c41fe51242bc25d269fabf82f5)): ?>
<?php $attributes = $__attributesOriginal155e76c41fe51242bc25d269fabf82f5; ?>
<?php unset($__attributesOriginal155e76c41fe51242bc25d269fabf82f5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal155e76c41fe51242bc25d269fabf82f5)): ?>
<?php $component = $__componentOriginal155e76c41fe51242bc25d269fabf82f5; ?>
<?php unset($__componentOriginal155e76c41fe51242bc25d269fabf82f5); ?>
<?php endif; ?>
                                    <span>cancel</span>
                                </button>
                            </div>
                        </div>

                        
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
                </div>
            </div>

            <div
                class="bg-white dark:bg-gray-800 rounded-xl p-4 shadow-sm dark:shadow-gray-900/25 border border-gray-100 dark:border-gray-700">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">Quick Transfer</h3>
                    <a href="<?php echo e(route('user.local.transfer')); ?>"
                        class="text-xs text-primary-600 dark:text-primary-400 font-medium flex items-center hover:text-primary-700 dark:hover:text-primary-300 transition-colors">
                        View All
                        <?php if (isset($component)) { $__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.chevron-down','data' => ['variant' => 'solid','class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.chevron-down'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0)): ?>
<?php $attributes = $__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0; ?>
<?php unset($__attributesOriginal298ff21bbc41cebb188cbb18c6c11bc0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0)): ?>
<?php $component = $__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0; ?>
<?php unset($__componentOriginal298ff21bbc41cebb188cbb18c6c11bc0); ?>
<?php endif; ?>
                    </a>
                </div>

                <div class="flex space-x-3 overflow-x-auto pb-2">
                    <!-- Add New Beneficiary -->
                    <a href="<?php echo e(route('user.local.transfer')); ?>"
                        class="shrink-0 flex flex-col items-center justify-center group">
                        <div
                            class="w-16 h-16 rounded-full border-2 border-dashed border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-800 flex items-center justify-center mb-2 group-hover:bg-gray-100 dark:group-hover:bg-gray-700 group-hover:border-primary-400 dark:group-hover:border-primary-500 transition-all duration-200">
                            <?php if (isset($component)) { $__componentOriginal37c717510e7a32140849d8d5dd9d632e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal37c717510e7a32140849d8d5dd9d632e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.plus','data' => ['variant' => 'solid','class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.plus'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal37c717510e7a32140849d8d5dd9d632e)): ?>
<?php $attributes = $__attributesOriginal37c717510e7a32140849d8d5dd9d632e; ?>
<?php unset($__attributesOriginal37c717510e7a32140849d8d5dd9d632e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal37c717510e7a32140849d8d5dd9d632e)): ?>
<?php $component = $__componentOriginal37c717510e7a32140849d8d5dd9d632e; ?>
<?php unset($__componentOriginal37c717510e7a32140849d8d5dd9d632e); ?>
<?php endif; ?>
                        </div>
                        <span
                            class="text-xs text-gray-500 dark:text-gray-400 text-center group-hover:text-primary-600 dark:group-hover:text-primary-400 transition-colors">
                            Add New
                        </span>
                    </a>

                    <!-- Beneficiaries List -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->recentBeneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                        <div class="shrink-0 flex flex-col items-center justify-center group relative">
                            <div
                                class="relative w-16 h-16 rounded-full flex items-center justify-center mb-2 border-2 border-white dark:border-gray-800 shadow-sm dark:shadow-gray-900/25 hover:scale-105 transition-all duration-200 <?php echo e($beneficiary->color); ?>">
                                <span class="text-white font-semibold text-base"><?php echo e($beneficiary->initials); ?></span>
                            </div>

                            <span class="text-xs text-gray-700 dark:text-gray-300 text-center max-w-16 truncate">
                                <?php echo e($beneficiary->name); ?>

                            </span>
                        </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
                        <!-- Empty State -->
                        <div class="shrink-0 flex flex-col items-center justify-center py-6 px-8">
                            <div
                                class="w-16 h-16 rounded-full bg-gray-100 dark:bg-gray-700 flex items-center justify-center mb-3">
                                <?php if (isset($component)) { $__componentOriginaldeeed84ca4f29f425b89c454233ef87a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldeeed84ca4f29f425b89c454233ef87a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.user-group','data' => ['variant' => 'solid','class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.user-group'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldeeed84ca4f29f425b89c454233ef87a)): ?>
<?php $attributes = $__attributesOriginaldeeed84ca4f29f425b89c454233ef87a; ?>
<?php unset($__attributesOriginaldeeed84ca4f29f425b89c454233ef87a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldeeed84ca4f29f425b89c454233ef87a)): ?>
<?php $component = $__componentOriginaldeeed84ca4f29f425b89c454233ef87a; ?>
<?php unset($__componentOriginaldeeed84ca4f29f425b89c454233ef87a); ?>
<?php endif; ?>
                            </div>
                            <p class="text-sm text-gray-500 dark:text-gray-400 text-center">No saved beneficiaries</p>
                            <p class="text-xs text-gray-400 dark:text-gray-500 text-center mt-1">Add one to get started
                            </p>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>

            <?php echo $__env->make('partials.quick-show', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('partials.credit-card-swiper', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>

        <!-- Right Column (future content) -->
        <div class="space-y-4 md:col-span-1 flex flex-col">
            <!-- Right Column (future content) -->
            <?php echo $__env->make('partials.recent-transaction-dashboard', [
                'latestTransactions' => $latestTransactions,
                'viewAllUrl' => route('user.transactions'),
            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <?php echo $__env->make('partials.statistic', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="md:hidden">
                <?php echo $__env->make('partials.metrics-card', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

            <?php echo $__env->make('partials.contact-card', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <!-- Referral Link & Sharing -->
            <section class="bg-white dark:bg-gray-900 rounded-xl shadow-sm p-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Your Referral Link</h2>

                <!-- Referral Input + Copy Button -->
                <div x-cloak x-data="{ copied: false }"
                    class="flex flex-col md:flex-row items-stretch md:items-center flex-wrap gap-3">
                    <div class="relative flex-1">
                        <input x-ref="referralInput" type="text" readonly
                            class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-700 bg-gray-100 dark:bg-gray-800 text-gray-800 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-sky-500"
                            :value="'<?php echo e(url('/registration?ref=' . $authUser->referral_code)); ?>'" />
                    </div>
                    <button
                        @click="
                const input = $refs.referralInput;
                input.select();
                input.setSelectionRange(0, 99999); // For mobile
                try {
                    const success = document.execCommand('copy');
                    copied = success;
                    setTimeout(() => copied = false, 2000);
                } catch(e) {
                    alert('Failed to copy text.');
                }
            "
                        class="px-5 py-2 rounded-lg bg-sky-600 hover:bg-sky-700 text-white font-semibold transition focus:outline-none focus:ring-2 focus:ring-sky-400">
                        <span x-text="copied ? 'Copied!' : 'Copy Link'"></span>
                    </button>
                </div>

                <!-- Metrics Section -->
                <div class="mt-8  grid md:hidden grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 text-center text-sm">
                    <!-- Referral Growth -->
                    <div
                        class="bg-gray-50 dark:bg-gray-800 p-5 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow transition">
                        <?php if (isset($component)) { $__componentOriginalc8c9b708e33a0d493706af15486aa707 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc8c9b708e33a0d493706af15486aa707 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrow-trending-up','data' => ['class' => 'w-6 h-6 mx-auto text-sky-500 mb-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrow-trending-up'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 mx-auto text-sky-500 mb-2']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc8c9b708e33a0d493706af15486aa707)): ?>
<?php $attributes = $__attributesOriginalc8c9b708e33a0d493706af15486aa707; ?>
<?php unset($__attributesOriginalc8c9b708e33a0d493706af15486aa707); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc8c9b708e33a0d493706af15486aa707)): ?>
<?php $component = $__componentOriginalc8c9b708e33a0d493706af15486aa707; ?>
<?php unset($__componentOriginalc8c9b708e33a0d493706af15486aa707); ?>
<?php endif; ?>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-gray-100">
                            <?php echo e($authUser->referralGrowth ?? 0); ?>%</p>
                        <p class="text-gray-600 dark:text-gray-400">Referral Growth</p>
                    </div>

                    <!-- Total Referral Earnings -->
                    <div
                        class="bg-gray-50 dark:bg-gray-800 p-5 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow transition">
                        <?php if (isset($component)) { $__componentOriginal1a2aab62646bbf4070a26cfe0540f0d4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1a2aab62646bbf4070a26cfe0540f0d4 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.banknotes','data' => ['class' => 'w-6 h-6 mx-auto text-green-500 mb-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.banknotes'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 mx-auto text-green-500 mb-2']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1a2aab62646bbf4070a26cfe0540f0d4)): ?>
<?php $attributes = $__attributesOriginal1a2aab62646bbf4070a26cfe0540f0d4; ?>
<?php unset($__attributesOriginal1a2aab62646bbf4070a26cfe0540f0d4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1a2aab62646bbf4070a26cfe0540f0d4)): ?>
<?php $component = $__componentOriginal1a2aab62646bbf4070a26cfe0540f0d4; ?>
<?php unset($__componentOriginal1a2aab62646bbf4070a26cfe0540f0d4); ?>
<?php endif; ?>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-gray-100">
                            <?php echo e($currencySymbol); ?> <?php echo e(number_format($authUser->referralEarnings(), 2)); ?>

                        </p>
                        <p class="text-gray-600 dark:text-gray-400">Total Referral Earnings</p>
                    </div>

                    <!-- Total Referrals -->
                    <div
                        class="bg-gray-50 dark:bg-gray-800 p-5 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow transition">
                        <?php if (isset($component)) { $__componentOriginaldeeed84ca4f29f425b89c454233ef87a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldeeed84ca4f29f425b89c454233ef87a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.user-group','data' => ['class' => 'w-6 h-6 mx-auto text-yellow-500 mb-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.user-group'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 mx-auto text-yellow-500 mb-2']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldeeed84ca4f29f425b89c454233ef87a)): ?>
<?php $attributes = $__attributesOriginaldeeed84ca4f29f425b89c454233ef87a; ?>
<?php unset($__attributesOriginaldeeed84ca4f29f425b89c454233ef87a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldeeed84ca4f29f425b89c454233ef87a)): ?>
<?php $component = $__componentOriginaldeeed84ca4f29f425b89c454233ef87a; ?>
<?php unset($__componentOriginaldeeed84ca4f29f425b89c454233ef87a); ?>
<?php endif; ?>
                        <p class="text-2xl font-semibold text-gray-900 dark:text-gray-100">
                            <?php echo e($authUser->referrals()->count()); ?>

                        </p>
                        <p class="text-gray-600 dark:text-gray-400">Total Referrals</p>
                    </div>
                </div>
            </section>

        </div>
    </div>

</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/pages/user/⚡dashboard/dashboard.blade.php ENDPATH**/ ?>