<?php

use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\ResetPasswordController;
use App\Http\Controllers\User\TaxRefundDownloadController;
use App\Services\ImpersonationService;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;



Route::get('/', function () {
    return view('static-pages.frontend.home');
})->name('home');

Route::get('/grands-aids', function () {
    return view('static-pages.frontend.grant');
})->name('frontend.grant');


Route::name('about.')->prefix('about')->group(function () {
    Route::get('/', function () {
        return view('static-pages.frontend.about-us.overview');
    })->name('overview');

    Route::get('/vision-mission', function () {
        return view('static-pages.frontend.about-us.vision');
    })->name('vision');

    Route::get('/career', function () {
        return view('static-pages.frontend.about-us.career');
    })->name('career');

    Route::get('/team', function () {
        return view('static-pages.frontend.about-us.team');
    })->name('team');

    Route::get('/faqs', function () {
        return view('static-pages.frontend.about-us.faqs');
    })->name('faqs');

    Route::get('/contact', function () {
        return view('static-pages.frontend.about-us.contact');
    })->name('contact');
});

Route::prefix('personal-banking')->name('personal.')->group(function () {
    Route::get('/', function () {
        return view('static-pages.frontend.personal.overview');
    })->name('overview');
    Route::get('checking-account', function () {
        return view('static-pages.frontend.personal.checking');
    })->name('checking');
    Route::get('savings-account', function () {
        return view('static-pages.frontend.personal.savings');
    })->name('savings');
    Route::get('auto-loans', function () {
        return view('static-pages.frontend.personal.auto-loans');
    })->name('auto.loans');
    Route::get('credit-card', function () {
        return view('static-pages.frontend.personal.credit-cards');
    })->name('credit-cards');
});

Route::prefix('business-banking')->name('business.')->group(function () {
    Route::get('/', function () {
        return view('static-pages.frontend.business.overview');
    })->name('overview');
    Route::get('checking-accounts', function () {
        return view('static-pages.frontend.business.checking');
    })->name('checking');
    Route::get('saving-accounts', function () {
        return view('static-pages.frontend.business.savings');
    })->name('savings');
    Route::get('lending', function () {
        return view('static-pages.frontend.business.lending');
    })->name('lending');
});

Route::prefix('nonprofit-banking')->name('nonprofit.')->group(function () {
    Route::get('/', function () {
        return view('static-pages.frontend.nonprofit.overview');
    })->name('overview');
    Route::get('checking-accounts', function () {
        return view('static-pages.frontend.nonprofit.checking');
    })->name('checking');
    Route::get('saving-accounts', function () {
        return view('static-pages.frontend.nonprofit.savings');
    })->name('savings');
    Route::get('lending', function () {
        return view('static-pages.frontend.nonprofit.lending');
    })->name('lending');
    Route::get('cdars-ics', function () {
        return view('static-pages.frontend.nonprofit.cdars');
    })->name('cdars');
});

Route::prefix('privacy-policy')->name('privacy.')->group(function () {
    Route::get('/job', function () {
        return view('static-pages.frontend.privacy.job_privacy_policy');
    })->name('job');

    Route::get('/web-accessibility', function () {
        return view('static-pages.frontend.privacy.web');
    })->name('web');

    Route::get('/privacy-and-data', function () {
        return view('static-pages.frontend.privacy.data');
    })->name('data');

    Route::get('/terms', function () {
        return view('static-pages.frontend.privacy.terms');
    })->name('terms');
    Route::get('/personal-information', function () {
        return view('static-pages.frontend.privacy.personal-information');
    })->name('personal-information');
});


// Show verification notice
Route::get('/email/verify', function () {
    return view('auth.verify-email');
})->middleware('auth')->name('verification.notice');

// Handle verification link
Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
    $request->fulfill();

    return redirect('/dashboard');
})->middleware(['auth', 'signed'])->name('verification.verify');

// Resend verification email
Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();

    return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.send');


Route::middleware('guest')->group(function () {

    Route::view('/registration', 'static-pages.onboarding.register')
        ->name('user.register');

    Route::view('/login', 'static-pages.onboarding.login')
        ->name('login');

    Route::view('/forgot-password', 'pages.user.auth.forgot-password')
        ->name('password.request');

    // Invalid password reset link
    Route::get('/reset-password', function () {
        return redirect()->route('login')
            ->with([
                'message' => 'Invalid password reset link.',
                'type' => 'error'
            ]);
    });
    Route::get('/reset-password/{token}', [ResetPasswordController::class, 'create'])->name('password.reset');
    Route::post('/reset-password', [ResetPasswordController::class, 'store'])->name('password.update');

    Route::post(
        '/forgot-password',
        [ForgotPasswordController::class, 'store']
    )->name('password.email');

    Route::view('/verify-otp', 'static-pages.onboarding.verify-otp')
        ->name('user.verify.otp');
});


Route::middleware(['auth', 'web', 'session.timeout'])->group(function () {
    // Onboarding page
    Route::get('/onboarding', function () {
        return view('static-pages.onboarding.index'); // Blade page
    })->name('onboarding');

    // Logout route
    Route::post('/logout', function () {
        Auth::logout(); // 👈 THIS is the missing piece

        request()->session()->invalidate();
        request()->session()->regenerateToken();

        return redirect('/login')->with([
            'message' => 'You have been logged out successfully.',
            'type' => 'success',
        ]);
    })->name('user.logout');
});

Route::view('/account-suspended', 'auth.account-suspended')
    ->name('account.suspended');

Route::middleware(['auth', 'complete.profile', 'verified', 'session.timeout', 'prevent.suspended'])->name('user.')->group(function () {
    Route::livewire('/dashboard', 'pages::user.dashboard')->name('dashboard');

    Route::view('/transactions', 'static-pages.transactions')
        ->name('transactions');

    // ====== Deposit Page
    Route::view('/deposit', 'static-pages.deposit')
        ->name('deposit');

    // ====== Withdrawal Page
    Route::view('/withdrawal', 'static-pages.withdrawal')
        ->name('withdrawal');

    // ====== Virtual Page
    Route::view('/virtual-cards', 'static-pages.credit-cards.index')
        ->name('virtual.cards');

    // ===== Local Transfer
    Route::livewire('/local-transfer', 'pages::user.transfer.local')->name('local.transfer');

    // ===== International Transfer
    Route::livewire('/international/transfer', 'pages::user.transfer.international')->name('international.transfer');

    // ===== Balanace Swap
    Route::livewire('/balance/transfer', 'pages::user.balance-swap')->name('balance.swap');

    // ====== Loans 
    Route::view('/loans', 'static-pages.loans')
        ->name('loans');
    Route::livewire('/loans/request', "pages::user.loans")->name('loans.request');
    Route::livewire('/loans/list', "pages::user.loans.index")->name('loans.index');
    Route::livewire('/loans/show/{loan}', "pages::user.loans.show")->name('loans.show');

    // ==== Tax Refund ==== //
    Route::livewire('/tax-refund', 'pages::user.tax-refund')->name('tax.refund.index');

    Route::livewire('/tax-refund/tracking', 'pages::user.track-tax-refund')->name('tax.refund.track');

    Route::livewire('/tax-refund/details/{filing_number}', 'pages::user.view-tax-refund')
        ->name('tax.refund.view');

    Route::get('/user/tax-refund/download/{refund}', [TaxRefundDownloadController::class, 'download'])
        ->name('tax.refund.download')
        ->middleware('signed'); // ensures only authorized users can access

    // ====== Grant Page
    Route::view('/grants', 'static-pages.grants')
        ->name('grants.index');

    Route::livewire('/grant-application/personal', 'pages::user.personal-grant')
        ->name('grants.personal');

    Route::livewire('/grant-application/company', 'pages::user.company-grant')
        ->name('grants.company');

    Route::livewire('/grant/logs', 'pages::user.grant-log')
        ->name('grants.history');

    // === Settings Page === //

    Route::livewire('/account-settings', 'pages::user.settings.index')->name('settings.index');
    Route::livewire('/password-settings', 'pages::user.settings.password-setting')->name('settings.password');
    Route::livewire('/two-factor-settings', 'pages::user.settings.two-factor')->name('settings.two-factor');
    Route::livewire('/transaction-pin', 'pages::user.settings.transaction-pin')->name('settings.transaction.pin');
    Route::livewire('/trusted-devices', 'pages::user.settings.trusted-device')->name('settings.trusted.device');

    // === Support Page ===//
    Route::livewire('/create/ticket', 'pages::user.support.create')->name('ticket.create');
    Route::livewire('/tickets', 'pages::user.support.index')->name('ticket.index');
    Route::livewire('/tickets/{ticket}', 'pages::user.support.show')->name('ticket.show');
});


Route::get('locale/{locale}', function ($locale) {
    $availableLocales = ['en', 'es', 'fr'];
    if (!in_array($locale, $availableLocales)) {
        abort(400);
    }

    session(['locale' => $locale]);

    return redirect()->back();
})->name('locale.switch');


// === Admin Route === //
Route::middleware('guest.admin')->prefix('admin')->name('admin.')->group(function () {
    Route::livewire('/login', 'pages::admin.auth.login')->name('login');
});

Route::post('/admin/impersonation/leave', function (ImpersonationService $service) {
    // Get the user ID we came from
    $fromUserId = session()->get('admin_impersonator_from_user');

    $service->leave();

    if ($fromUserId) {
        return redirect()->route('admin.users.show', $fromUserId);
    }

    return redirect()->route('admin.dashboard');
})->name('admin.impersonation.leave');

Route::middleware(['ensure.admin', 'noindex.admin'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::livewire('/dashboard', 'pages::admin.dashboard')->name('dashboard');

        // === User Management ===//
        Route::livewire('/users', 'pages::admin.user.index')->name('users.index');
        Route::livewire('/users/{user}', 'pages::admin.user.show')->name('users.show');
        Route::livewire('/users/emails/history/{user}', 'pages::admin.user.email-history')
            ->name('users.emails.history');
        Route::livewire('/users/login/history/{user}', 'pages::admin.user.login-history')
            ->name('users.login.history');
        Route::livewire('/users/transactions/{user}', 'pages::admin.user.transactions')->name('users.transactions');
        Route::livewire('/users/notifications/{user}', 'pages::admin.user.notifications')->name('users.notifications');

        // === Deposit Management === //
        Route::livewire('/deposit/index', 'pages::admin.deposit.index')->name('deposit.index');
        Route::livewire('/deposit/{deposit}', 'pages::admin.deposit.show')->name('deposit.show');

        // === Withdrawal Management === //
        Route::livewire('/withdrawal/index', 'pages::admin.withdrawal.index')->name('withdrawal.index');
        Route::livewire('/withdrawal/{withdrawal}', 'pages::admin.withdrawal.show')->name('withdrawal.show');

        // === Transfer Management === //
        Route::livewire('transfer/index', 'pages::admin.transfer.index')->name('transfer.index');
        Route::livewire('transfer/show/{transfer}', 'pages::admin.transfer.show')->name('transfer.show');

        // === Loans Management ===//
    
        Route::livewire('loans/index', 'pages::admin.loans.index')->name('loans.index');
        Route::livewire('loans/show/{loan}', 'pages::admin.loans.show')->name('loans.show');

        // === Grants Management ===//
        Route::livewire('/grants', 'pages::admin.grants.manage')->name('grants.manage');

        // === Tax Refund Management ===//
        Route::livewire('/tax-refunds/management', 'pages::admin.tax-refund.manage')->name('refund.manage');

        // === Payment Method === //
    
        Route::livewire('/payment-method/deposit', 'pages::admin.paymentmethod.deposit')->name('methods-deposit')
            ->defaults('type', 'deposit');
        Route::livewire('/payment-method/withdrawal', 'pages::admin.paymentmethod.deposit')->name('methods-withdrawal')
            ->defaults('type', 'withdrawal');
        Route::livewire('/payment-method/local_transfer', 'pages::admin.paymentmethod.deposit')->name('methods-local_transfer')
            ->defaults('type', 'local_transfer');
        Route::livewire('/payment-method/international_transfer', 'pages::admin.paymentmethod.deposit')->name('methods-international_transfer')
            ->defaults('type', 'international_transfer');

        // ===== Crypto === //
        Route::livewire('/crypto-wallet', 'pages::admin.paymentmethod.crypto')->name('crypto.index');

        Route::livewire('/tickets', 'pages::admin.tickets')->name('ticket.index');
        Route::livewire('/settings', 'pages::admin.setting')->name('setting');

        Route::post('/logout', function () {
            Auth::guard('admin')->logout();
            session()->invalidate();
            session()->regenerateToken();
            return redirect('/admin/login');
        })->name('logout');
    });
