<x-layouts::front :title="__('about || Savings Account', ['app' => config('app.name')])">
<div class="">
<x-hero-static
    title="Grow Your Savings with Confidence"
    description="Whether you're building an emergency fund or saving for something special, our savings solutions help your money work harder—securely and steadily."
      badge="For individual"
    badgeIcon="user"
/>

<x-breadcrumbs config-key="personal_banking" />

<x-account-card
    title="PositiveChange Savings Accounts"
    icon="scale"
        iconVariant="solid"
    iconColor="bg-sky-900"
    :features="[
        'description' => 'Prepare for the future while saving and earning money. Add a savings account and enjoy overdraft protection transfers to your checking account for no additional fee.',
        'list' => [
            'eStatements (optional)',
            'Online and mobile account access',
        ]
    ]"
    ctaText="Open Account"
    ctaLink="{{ route('user.register') }}"
/>

<div class=" -mt-13">
      <x-benefits-section :grid-cols="2" 
      banner="**Additional fees may apply. Please see Schedule of Fees and Charges.
      
      ***$2.50 transaction fee for withdrawals at foreign ATMs (other banks may charge a fee). Any ATM not in the {{ config('app.name') }} ATM network is a non-network ATM."
    :benefitGroups="[
        [
            'title' => 'Savings',
            'subtitle' => 'An account with the essentials to begin building a healthy financial future.',
            'items' => [
                'Minimum opening balance: $50',
              [
        'text' => 'Service charge: $5/month, waived if:',
        'subitems' => [
            '$200/month average balance for this account',
            '$10,000/month average balance combined across accounts for which you are the owner or joint owner',
            'Primary tax holder is minor under 18',
        ],
    ],
    'Features: Online and mobile banking, Bill pay, ATM card***',
            ],
        ],
        [
            'title' => 'Money Market',
            'subtitle' => 'You can earn a higher interest rate than with a savings account, with check-writing ability.',
            'items' => [
                'Minimum opening balance: $50',
                       [
        'text' => 'Service charge: $5/month, waived if:',
        'subitems' => [
            '$3,000/month average balance for this account',
            '$10,000/month average balance combined across accounts for which you are the owner or joint owner',
            'Features: Online and mobile banking, Check-writing ability, ATM card***',
        ],
    ],
            ],
        ],
        [
            'title' => 'Certificate of Deposit (CD) Accounts',
            'subtitle' => 'Earn interest on your deposit for a fixed time period.',
            'items' => [
                'Minimum opening balance: $250',
                'Service charge: $0',
                'Terms of 3 to 60 months; early withdrawal penalty may apply.',
                'Paid interest may be withdrawn without penalty or rolled over at maturity into the principal balance. Assessment of penalties can reduce principal and earnings.',
                'Interest: Compounded daily, credited monthly by adding back to the CD.'
            ],
            
        ],
          [
            'title' => 'Individual Retirement Accounts (IRAs)',
            'subtitle' => 'A tax-advantaged long-term savings account to help you save for retirement.',
            'items' => [
                'Minimum opening balance: $250',
                'Service charge: N/A',
                'Terms of 3 to 60 months; early withdrawal penalty may apply',
                'Bank and IRS penalties may be imposed for early withdrawal. Assessment of penalties can reduce principal and earnings.',
                'Interest: Compounded daily. Paid quarterly.'
            ],
            
        ],
    ]"
/>
</div>

<x-cta-banner 
    primaryLinkText="Open Business Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>

</div>
</x-layouts::front>