<x-layouts::front :title="__('about || Personal Banking', ['app' => config('app.name')])">
<x-hero-static
    title="Simple Personal Account"
    description="Checking, savings, and lending solutions designed to help you manage your money with confidence."
    badge="For individual"
    badgeIcon="user"
/>

<x-breadcrumbs config-key="personal_banking" />

<x-image-top-service
  :grid-cols="3"
  description="That's reflected in the lineup of products we offer for your everyday life. We strive to build a better future by building a better banking system from the ground up—one that strengthens local communities and improves quality of life, rather than the other way around. Whether you need a deposit account to manage your day-to-day expenses or an auto loan with sensible rates and manageable payment plans, {{ config('app.name') }} emphasizes the 'person' in personal banking."
  title="Serving our communities is at the heart of everything we do at {{ config('app.name') }}."
  :cards="[
    [
      'image' => 'images/Personal-Banking-Checking-Woman-and-Granddaughter.webp',
      'title' => 'PositiveChange Checking Accounts',
      'description' => 'Our personal checking accounts are designed for a range of customers and include online and mobile banking..',
      'buttonText' => 'Checking Account',
      'buttonLink' => route('personal.checking')
    ],
    [
      'image' => 'images/home/AffordableHousing_finaldesktop.avif',
      'title' => 'PositiveChange Savings Accounts',
      'description' => 'Add a savings account and enjoy overdraft protection transfers to your checking account for no additional fee.',
      'buttonText' => 'Saving Account',
      'buttonLink' => route('personal.savings')
    ],
    [
      'image' => 'images/Personal-Banking-Auto-Loan-Man-checks-phone-next-to-electric-vehicle-charging.webp',
      'title' => 'Auto Loans',
      'description' => 'We can help you get pre-qualified for a loan before you shop or refinance your current loan to lower your interest rate.',
      'buttonText' => 'Loan Account',
      'buttonLink' => route('personal.auto.loans')
    ],
      [
      'image' => 'images/Personal-Banking-Credit-Card-Man-sits-on-couch-with-phone-and-credit-card.webp',
      'title' => 'Credit Cards',
      'description' => 'Our values-driven credit cards are available. You can learn more and apply online.',
      'buttonText' => 'Credit Card',
      'buttonLink' => route('personal.credit-cards')
    ],
     [
      'image' => 'images/Personal-Banking-Financial-Wellness-Woman-with-coffee-cup-talks-on-the-phone.webp',
      'title' => 'Financial Wellness',
      'description' => 'Our financial education materials are designed to help you achieve financial stability.',
      'buttonText' => 'Financial Wellness',
      'buttonLink' => route('login')
    ],
     [
      'image' => 'images/Personal-Banking-Contact-Us-Two-women-sit-on-couch-with-a-child-and-smile-at-camera.webp',
      'title' => 'Contact Us',
      'description' => 'You can get in touch with our team via secure message or phone. We\'re here to help.',
      'buttonText' => 'Contact Us',
      'buttonLink' => route('about.contact')
    ]
  ]"
/>

    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pb-6 fade-in-up space-y-6">
      <h2 class="text-sm md:text-base text-primary-700 font-semibold uppercase">Building a Better World</h2>
      <p class="text-gray-700 dark:text-gray-100 text-sm leading-normal">
            Depositors aren't just another line item at {{ config('app.name') }}. We value what our accountholders bring to the table—the opportunity for our organization to "crowdfund" and engage in lending practices that build toward a more inclusive, environmentally regenerative, racial- and gender-just world. That's our vision. <a href="{{ route('about.vision') }}" class="font-medium text-primary-700">Learn More</a>.
      </p>
</div>
    <x-cta-banner 
            primaryLinkText="Open an account" 
            primaryLinkUrl="{{ route('user.register') }}" 
        />
</div>


</x-layouts::front>