<x-layouts::front :title="__('about || Checking Account', ['app' => config('app.name')])">
<div class="">
<x-hero-static
    title="Checking That Works for You"
    description="Enjoy convenient, secure access to your money with checking accounts designed for your lifestyle. Manage everyday expenses with ease—online, on mobile, or in person."
     badge="For individual"
    badgeIcon="user"
/>

<x-breadcrumbs config-key="personal_banking" />
<x-account-card
    title="PositiveChange Checking Accounts"
    icon="scale"
        iconVariant="solid"
    iconColor="bg-sky-900"
    :features="[
        'description' => 'Your deposits empower change-makers working toward social justice and environmental sustainability.',
        'list' => [
            'Debit card',
            'Unlimited debit card transactions',
            'Unlimited check writing',
            'eStatements (required for eChecking, optional for other accounts)',
            'Online and mobile banking',
            'Bill pay',
        ]
    ]"
    ctaText="Open Account"
    ctaLink="{{ route('user.register') }}"
/>

<div class=" -mt-13">
      <x-benefits-section
      banner="**Additional fees may apply. Please see Schedule of Fees and Charges.
      
       ***$2.50 transaction fee for withdrawals at foreign ATMs (other banks may charge a fee). Any ATM not in the {{ config('app.name') }} ATM network is a non-network ATM."
    :benefitGroups="[
        [
            'title' => 'Checking',
            'subtitle' => 'Our full suite of features, with the option to receive statements through the mail',
            'items' => [
                'Minimum opening balance: $50',
                'Monthly service charge: $5/month, waived if:',
                '$500/month average balance for this account',
                '$10,000/month average balance combined across accounts for which you are the owner or joint owner',
                '$500 monthly direct deposit',
                'Primary tax holder is minor under 18',
            ],
        ],
        [
            'title' => 'eChecking',
            'subtitle' => 'A free online account with our full suite of features. eStatements required.',
            'items' => [
                'Minimum opening balance: $50',
                'Monthly service charge: $0/month',
                'Please note: eStatement required',
            ],
        ],
        [
            'title' => 'Interest Checking',
            'subtitle' => 'Interest-earning account for households that keep higher balances.',
            'items' => [
                'Minimum opening balance: $50',
                'Monthly service charge: $10/month, waived if:',
                '$2,500/month average balance for this account',
                '$10,000/month average balance combined across accounts for which you are the owner or joint owner',
                '$1,500 monthly direct deposit'
            ],
            
        ],
         
    ]"
/>
</div>

<x-cta-banner 
    primaryLinkText="Open Checking Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>
</div>
</x-layouts::front>