<x-layouts::front :title="__('about || Auto Loans', ['app' => config('app.name')])">
<div class="">
    <!-- Hero Section -->
  <x-hero-static
    title="Drive Forward with Confidence"
    description="Get behind the wheel with competitive auto loan rates and flexible terms. Whether you're buying new or used, we’ll help you finance your next vehicle with ease."
      badge="For individual"
    badgeIcon="user"
/>


    <!-- Breadcrumbs -->
    <x-breadcrumbs config-key="personal_banking" />

    <!-- Featured Auto Loan Card -->
    <x-account-card
        title="DriveForward Auto Loans"
        icon="car-front"
        iconColor="bg-sky-900"
        :features="[
            'description' => 'Purchase or refinance your vehicle with competitive rates and flexible terms. Enjoy personalized financing options that fit your budget and credit profile.',
            'list' => [
                'Competitive fixed and variable rates',
                'Flexible loan terms up to 84 months',
                'Online loan management and eStatements',
            ]
        ]"
        ctaText="Apply Now"
        ctaLink="{{ route('user.loans.request') }}"
    />

    <!-- Benefits / Loan Options Section -->
    <div class="-mt-13">
        <x-benefits-section :grid-cols="2" 
            banner="**Rates and terms are subject to credit approval. Other fees may apply. All loans are subject to eligibility and approval criteria.**"
            :benefitGroups="[
                [
                    'title' => 'New Vehicle Loans',
                    'subtitle' => 'Finance your new car with low rates and flexible repayment options.',
                    'items' => [
                        'Minimum loan amount: $5,000',
                        [
                            'text' => 'Loan terms:',
                            'subitems' => [
                                '24 to 84 months available depending on vehicle and credit',
                                'Option to prepay without penalty',
                            ],
                        ],
                        'Features: Online application, eStatements, automatic payments available',
                    ],
                ],
                [
                    'title' => 'Used Vehicle Loans',
                    'subtitle' => 'Affordable financing for pre-owned vehicles with competitive rates.',
                    'items' => [
                        'Minimum loan amount: $3,000',
                        [
                            'text' => 'Loan terms:',
                            'subitems' => [
                                '24 to 72 months depending on vehicle age and mileage',
                                'Option to refinance existing auto loans',
                            ],
                        ],
                        'Features: Online account management, flexible repayment schedules',
                    ],
                ],
                [
                    'title' => 'Auto Loan Refinancing',
                    'subtitle' => 'Lower your monthly payment or rate by refinancing your current auto loan.',
                    'items' => [
                        'Eligibility: Existing auto loan with another lender',
                        [
                            'text' => 'Benefits:',
                            'subitems' => [
                                'Lower interest rates based on credit score',
                                'Adjustable loan term to reduce monthly payments',
                                'No prepayment penalties',
                            ],
                        ],
                        'Features: Online application, fast approval, electronic documentation',
                    ],
                ],
                [
                    'title' => 'Lease Buyout Loans',
                    'subtitle' => 'Purchase your leased vehicle at the end of your lease term.',
                    'items' => [
                        'Eligibility: Current lessee with lease buyout option',
                        'Loan amount: Depends on residual value of the vehicle',
                        [
                            'text' => 'Terms & Features:',
                            'subitems' => [
                                'Flexible repayment options',
                                'Competitive rates for lease buyout',
                                'Online application and account management',
                            ],
                        ],
                    ],
                ],
            ]"
        />
    </div>


@php
$autoLoans = [
    [
        'title' => 'New Vehicle',
        'description' => 'Low rates and flexible repayment options for new vehicles.',
        'amount' => '$5,000+',
        'term' => '24-84 months',
        'prepay' => 'No penalty',
        'apply' => 'Online',
        'color' => 'bg-sky-50 dark:bg-gray-800/50',
        'border' => 'border-sky-200 dark:border-gray-700',
        'ctaColor' => 'bg-sky-600 hover:bg-sky-700',
        'ctaText' => 'Apply Now',
        'ctaLink' => route('user.loans.request'),
    ],
    [
        'title' => 'Used Vehicle',
        'description' => 'Affordable financing for pre-owned vehicles with competitive rates.',
        'amount' => '$3,000+',
        'term' => '24-72 months',
        'prepay' => 'No penalty',
        'apply' => 'Online',
        'color' => 'bg-gray-50 dark:bg-gray-800/50',
        'border' => 'border-gray-200 dark:border-gray-700',
        'ctaColor' => 'bg-gray-700 hover:bg-gray-800',
        'ctaText' => 'Apply Now',
        'ctaLink' => route('user.loans.request'),
    ],
    [
        'title' => 'Refinancing',
        'description' => 'Reduce your monthly payments or interest rate by refinancing your current auto loan.',
        'amount' => 'Existing loan required',
        'term' => 'Flexible',
        'prepay' => 'No penalty',
        'apply' => 'Online',
        'color' => 'bg-gray-50 dark:bg-gray-800/50',
        'border' => 'border-gray-200 dark:border-gray-700',
        'ctaColor' => 'bg-gray-700 hover:bg-gray-800',
        'ctaText' => 'Apply Now',
        'ctaLink' => route('user.loans.request'),
    ],
    [
        'title' => 'Lease Buyout',
        'description' => 'Purchase your leased vehicle at the end of your lease term with flexible financing.',
        'amount' => 'Residual Value',
        'term' => 'Flexible',
        'prepay' => 'No penalty',
        'apply' => 'Online',
        'color' => 'bg-gray-50 dark:bg-gray-800/50',
        'border' => 'border-gray-200 dark:border-gray-700',
        'ctaColor' => 'bg-gray-700 hover:bg-gray-800',
        'ctaText' => 'Apply Now',
        'ctaLink' => route('user.loans.request'),
    ],
];
@endphp

<x-loan-grid title="Compare Auto Loans" :loans="$autoLoans" cols="grid-cols-1 md:grid-cols-2" />


    <!-- CTA Banner -->
    <x-cta-banner 
        primaryLinkText="Apply for Auto Loan" 
        primaryLinkUrl="{{ route('user.loans.request') }}" 
    />

</div>
</x-layouts::front>
