<x-layouts::front :title="__('about || Nonprofit Lending', ['app' => config('app.name')])">
<div class="">

<x-hero-static
    title="Nonprofit Lending"
    description="Flexible financing solutions to support expansion, facilities, equipment, and program growth."
        badge="Non Profit"
    badgeIcon="beaker"
/>

<x-breadcrumbs config-key="nonprofit_banking" />

@php
$loanTypes = [
    [
        'heading' => 'Nonprofit Loan Types',
        'content' => '<p>'.config('app.name').' has the experience and expertise to help your organization expand its impact on the community. We offer the following financing options for nonprofit organizations:</p><ul class="list-disc pl-6"><li>Term Loans</li><li>Lines of Credit</li><li>Commercial Mortgages</li></ul>',
    ],
    [
        'heading' => 'Term Loans',
        'content' => '
            <p>We offer several ways to help your organization meet its long-term goals. Our term loans may be used to finance equipment, capital expenditures, tenant improvements, and other long-term projects..</p>
        '
    ],
        [
        'heading' => 'Lines of Credit',
        'content' => '
            <p>We offer two ways for your nonprofit to take advantage of short-term opportunities as they arise. Our revolving lines of credit let your organization finance short-term working capital needs. Our non-revolving lines of credit let your organization borrow funds disbursed over a period of time; once the project is complete, the line converts to a term loan.</p>
        '
    ],
        [
        'heading' => 'Commercial Mortgages',
        'content' => '
            <p>We offer tailored financing for all types of commercial properties for nonprofit organizations..</p>
        '
    ],
        [
        'heading' => 'Affordable Housing',
        'content' => '
            <p>We offer construction/renovation, acquisition, and refinance of Affordable Housing multifamily deed-restricted and HUD HAP properties.</p>
        '
    ],
        [
        'heading' => 'Nonprofit Builder Loan',
        'content' => '
            <p>This loan type is targeted for clients looking to loan from $10,000 to $150,000. These loans are available for working capital or multiple advances for asset purchases or tenant improvements..</p>
        '
    ],
]
    @endphp
<x-privacy-section
textColor="text-red-900 dark:text-red-50"
    :sections="$loanTypes"
/>

<x-cta-banner 
    primaryLinkText="Open Savings Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>
</div>
</x-layouts::front>