<x-layouts::front :title="__('about || Nonprofit Checking Account', ['app' => config('app.name')])">
<div class="">
 <x-hero-static
    title="Nonprofit Checking"
    description="Manage donations, operating expenses, and program funds with flexible, low-cost checking options."
      badge="Non Profit"
    badgeIcon="beaker"
/>

<x-breadcrumbs config-key="nonprofit_banking" />
<x-account-card
    title="PositiveChange Nonprofit Banking"
    :features="[
        'description' => 'Your deposits matter. Your deposits allow us to empower changemakers that are working toward meaningful social justice outcomes and environmental sustainability. Your deposits can create the positive change you want reflected in our communities.',
    ]"
/>
<div class="-mt-22">
      <x-benefits-section :grid-cols="2" 
    :benefitGroups="[
        [
            'title' => 'Small Nonprofit Checking',
            'subtitle' => 'Perfect account for low-volume nonprofits..',
            'items' => [
                'Minimum opening balance: $100',
            'Service charge: $0',
            '150 free transactions/month; then $0.25/each',
            'eStatements required'
            ],
        ],
        [
            'title' => 'Nonprofit Business Checking',
            'subtitle' => 'Great for established nonprofits with low- to medium-volume.',
            'items' => [
                'Minimum opening balance: $100',
                       [
        'text' => 'Service charge: $15/month, waived if:',
        'subitems' => [
            '$3,000/month average balance for this account',
            '$10,000/month average balance combined across accounts under the same business tax owner',
        ],
    ],
      '250 free transactions/month; then $0.25/each',
            ],
        ],
        [
            'title' => 'Changemaker Business Interest Checking',
            'subtitle' => 'An interest-bearing account for qualified changemakers, such as nonprofits, certified B Corps, CDFIs, and more..',
            'items' => [
                'Minimum opening balance: $100',
                'Service charge: $0',
                'eStatements required.',
            ],
            
        ],
          [
            'title' => 'Analyzed Nonprofit Checking',
            'subtitle' => 'Ideal for high activity, with enhanced services to accommodate your growing organization.',
            'items' => [
                'Minimum opening balance: $100',
                'Service charge: $15/month',
                'Schedule of Fees and Services',
            ],
            
        ],
    ]"
/>
</div>


<div class="-mt-20">
      <x-account-card
    title="The following account services are available:**"
    :features="[
        'list' => [
            'Debit Card*',
            'eStatements',
            'Online and Mobile Banking',
            'Mobile and Merchant Check Deposit',
            'Merchant Card Services',
            'Wholesale Lockbox',
            'Cash Services',
            'Bill Pay',
            'Fraud Tools: ACH Filters and Positive Pay',
            'ACH and Wires',
            'Sweeps',
        ]
    ]"
    ctaText="Contact Our Support"
    ctaLink="{{ route('user.register') }}"
/>
</div>

<x-cta-banner 
    primaryLinkText="Open Checking Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>
</div>
</x-layouts::front>
