<x-layouts::front :title="__('about || Business Savings Account', ['app' => config('app.name')])">
<div class="">
<x-hero-static
    title="Business Savings"
    description="Put excess funds to work while keeping your capital secure and accessible."
    badge="For Business's"
    badgeIcon="briefcase"
/>

<x-breadcrumbs config-key="business_banking" />
<div class="-mt-22">
      <x-benefits-section :grid-cols="2"  title="PositiveChange Business Savings Accounts" description="Your deposits matter. They allow us to empower changemakers who are working toward meaningful social justice outcomes and environmental sustainability. Your deposits can create the positive change you want reflected in our communities."
      banner="*$2.50 transaction fee for withdrawals at foreign ATMs (other banks may charge a fee). Any ATM not in the {{ config('app.name') }} ATM network is a non-network ATM.
      
  **Additional fees may apply. Please see Schedule of Fees and Charges."
    :benefitGroups="[
        [
            'title' => 'Business Savings',
            'subtitle' => 'An account with all the essentials designed to put you in control of your organization’s savings.',
            'items' => [
                'Minimum opening balance: $100',
                          [
        'text' => 'Service charge: $5/month, waived if:',
        'subitems' => [
            '$200/month average balance for this account',
            '$15,000/month average balance combined across accounts under the same business tax owner',
        ],
    ],
          'Features: ATM Card*, eStatements, Online and Mobile Banking, Merchant Deposit Capture',
            ],
        ],
        [
            'title' => 'Business Money Market',
            'subtitle' => 'An interest-bearing account that can earn a higher interest rate than a savings account, with check-writing ability.',
         'items' => [
                'Minimum opening balance: $100',
                          [
        'text' => 'Service charge: $15/month, waived if:',
        'subitems' => [
            '$5,000/month average balance for this account',
            '$15,000/month average balance combined across accounts under the same business tax owner',
        ],
    ],
          'Features: eStatements, Online and Mobile Banking, Merchant Deposit Capture, Positive Pay',
            ],
        ],
        [
            'title' => 'Certificate of Deposit (CD) Accounts',
            'subtitle' => 'Ideal for organizations that prefer the benefit of fixed returns.',
            'items' => [
                'Minimum opening balance: $250',
                'Service charge: $0',
                'Terms of 3 to 60 months; early withdrawal penalty may apply.',
                'Paid interest may be withdrawn without penalty or rolled over at maturity into the principal balance. Assessment of penalties can reduce principal and earnings.',
                'Interest: Compounded daily, credited monthly by adding back to the CD.',
            ],
            
        ],
              [
            'title' => 'IOLTA / State Bar Account',
            'subtitle' => 'Interest on Lawyers Trust Accounts available in California, Oregon, and Washington.',
         'items' => [
                'Minimum opening balance: $0',
                'Service charge: $0',
                'We are a Visionary Leadership Bank (Oregon)',
                          [
        'text' => 'Interest on these accounts is paid to a nonprofit that uses the funds to provide:',
        'subitems' => [
            'Access to justice in California, Oregon, or Washington by obtaining and distributing funds to provide legal services to persons of lesser means',
            'Promotional support for diversity in the legal profession',
        ],
    ],
            ],
        ],
    ]"
/>
</div>

<x-cta-banner 
    primaryLinkText="Open Savings Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>
</div>
</x-layouts::front>