<x-layouts::front :title="__('about || Overview', ['app' => config('app.name')])">
<div class="">
      <x-hero-static
    badge="Our Story"
    badgeIcon="building-library"
    title="About {{ config('app.name') }}"
    description="Trusted banking partner committed to your financial success since our founding"
/>
<x-breadcrumbs config-key="about_us" />

<x-feature-section
    title="Our Story"
    image="/images/about/overview/Kat-Taylor-and-Tom-Steyer-2016.avif"
    imageAlt="Family managing finances at the bank"
    imagePosition="right"
    buttonText="Open Account Now"
    buttonLink="{{ route('user.register') }}"
 
>
    <p>For too long, banks have enabled the concentration of wealth and power by investing in and lending to exploitive industries, prioritizing profit over all else. {{config('app.name')}} was founded to demonstrate that there is a more viable, equitable, and sustainable model for banking..</p>

    <p>In 2007, Co-Founders Kat Taylor and Tom Steyer set out to design a new kind of community bank—one that would equally prioritize people, the planet, and long-term financial sustainability (a triple bottom line approach). Kat and Tom generously donated the capital for the Bank to {{config('app.name')}} Foundation, a nonprofit organization, which is now the majority owner of the Bank’s capital. This unique ownership structure ensures that {{config('app.name')}} is owned and permanently governed in the public interest.

.</p>

    <p>As of 2024, {{config('app.name')}} is a $1.9 billion asset state-chartered, federally insured bank with branches in California, Oregon, and Washington..</p>
</x-feature-section>

<x-feature-section
    title="A Bank Built for People and Planet"
    image="/images/home/wide-commercial4.jpg"
    imageAlt="Family managing finances at the bank"
    imagePosition="left"
    buttonText="Our Vision"
    buttonLink="{{ route('about.vision') }}"
 
>
    <p>We believe that banks should nourish our communities, not extract from them, so we design our products and services to optimize positive social and environmental outcomes. As a Community Development Financial Institution (CDFI), we focus on uplifting low-to-moderate (LMI) populations and communities and ensure that at least 60% of our lending goes towards these communities.</p>

    <p>Just as important are the activities we avoid. Our commitments include no predatory lending, and no investments or lending to fossil fuel, private prisons, or weapons manufacturing industries. We consider these and other extractive lending investments to be “contra mission.”</p>

    <p>In 2024, over 90% of our total lending portfolio supported sectors that positively impact our communities and the planet, and the remaining aligned with our aspiration to “do no harm.”</p>
</x-feature-section>

<div class="bg-gray-900 py-8 md:py-12">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">
            <h2 class="text-center text-lg md:text-2xl uppercase tracking-wide text-white font-semibold">Our Certifications</h2>
                  <!-- Trust Logos -->
            <div class="flex flex-wrap justify-center items-center w-full gap-6 md:gap-16 mt-6">
                <a href="#" target="_blank" rel="noopener">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/Member-FDIC-White.png" alt="Member FDIC logo in white">
                </a>
                <a href="#">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/2018-B-Corp-Logo-White-L.png" alt="Certified B Corporation">
                </a>
                <a href="#">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/CDFI_Logo_BW.png" alt="CDFI Certified Bank SBA Preferred Lender">
                </a>
                <a href="#">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/GABV_Stamp_Basic_White.png" alt="Global Alliance for Banking on Values logo">
                </a>
                <a href="#" target="_blank" rel="noopener">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/PRB_Logo_WHITE-footer-70h.png" alt="UNEP Principles for Responsible Banking">
                </a>
                <a href="#" target="_blank" rel="noopener">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/just_logo_color_FINAL_White.png" alt="Just. label logo">
                </a>
                <a href="#">
                    <img class="h-auto w-auto max-h-24 max-w-24" loading="lazy" src="/images/Grayscale-@3x-fossil-free.png" alt="Bank.Green Fossil Free Certification">
                </a>
            </div>
      </div>
</div>

<section class="relative bg-gray-50 dark:bg-gray-900 overflow-hidden py-12">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8 fade-in-up">

        <!-- Intro -->
        <div class="space-y-4">
            <h2 class="text-primary-600 text-3xl md:text-4xl tracking-wide font-semibold">
                What is {{ config('app.name') }}™?
            </h2>
            <p class="text-gray-700 dark:text-gray-300 text-base md:text-lg leading-relaxed">
                We go beyond <a href="#" class="underline hover:text-primary-600 dark:hover:text-sky-400 transition-colors">what is considered “ethical banking”</a>. 
                Since our inception, {{config('app.name')}} has believed that banking can and should 
                <span class="font-semibold">regenerate and restore</span> our communities and our planet. 
                Beyond avoiding the bad, we actively work to help solve society’s greatest challenges.
            </p>
        </div>

        <!-- Criteria -->
        <div class="space-y-8">
            <h3 class="text-xl md:text-2xl font-semibold text-gray-900 dark:text-gray-50">
                {{ config('app.name') }}™ meets four foundational criteria:
            </h3>

            <ul class="grid grid-cols-1 gap-8 max-w-5xl mx-auto">
                
                <!-- Item 1 -->
                <li class="flex gap-6 items-start">
                    <div class="shrink-0 w-16 h-16 md:w-24 md:h-24 flex items-center justify-center rounded-full bg-primary-600 text-white font-bold text-xl md:text-2xl">
                        1
                    </div>
                    <div>
                        <h4 class="text-lg md:text-xl font-semibold text-gray-900 dark:text-gray-50">
                            Stakeholder Capitalism
                        </h4>
                        <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                            We practice stakeholder capitalism. Unlike traditional shareholder capitalism, 
                            which prioritizes profit above all else, stakeholder capitalism considers the potential impacts 
                            on all stakeholders, including clients, employees, our communities, and the planet. 
                            This is also called a <span class="italic">“triple bottom line”</span> approach.
                        </p>
                    </div>
                </li>

                <!-- Item 2 -->
                <li class="flex gap-6 items-start">
                    <div class="shrink-0 w-16 h-16 md:w-24 md:h-24 flex items-center justify-center rounded-full bg-green-500 text-white font-bold text-xl md:text-2xl">
                        2
                    </div>
                    <div>
                        <h4 class="text-lg md:text-xl font-semibold text-gray-900 dark:text-gray-50">
                  High Impact Lending Practice
                        </h4>
                        <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                      We follow a disciplined lending and investment practice. We strive for at least 75% of our lending to go towards supporting people and the planet. The remainder of our lending avoids harmful industries. We report these outcomes in our annual Impact Report.
                        </p>
                    </div>
                </li>

                <!-- Item 3 -->
                <li class="flex gap-6 items-start">
                    <div class="shrink-0 w-16 h-16 md:w-24 md:h-24 flex items-center justify-center rounded-full bg-yellow-500 text-white font-bold text-xl md:text-2xl">
                        3
                    </div>
                    <div>
                        <h4 class="text-lg md:text-xl font-semibold text-gray-900 dark:text-gray-50">
               Transparency & Accountability
                        </h4>
                        <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                           We raise the bar for transparency and accountability. Through 3rd party certifications and memberships, we seek to operate as responsibly and impactfully as possible. These include B Corp certification, CDFI certification, Fossil-Free certification, and GABV membership.
                        </p>
                    </div>
                </li>

                <!-- Item 4 -->
                <li class="flex gap-6 items-start">
                    <div class="shrink-0 w-16 h-16 md:w-24 md:h-24 flex items-center justify-center rounded-full bg-red-500 text-white font-bold text-xl md:text-2xl">
                        4
                    </div>
                    <div>
                        <h4 class="text-lg md:text-xl font-semibold text-gray-900 dark:text-gray-50">
                        
Equitable Banking Services & Solutions
                        </h4>
                        <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                          We provide equitable and inclusive access to banking and deliver services and solutions that leave those who engage with us better off than they were before.
                        </p>
                    </div>
                </li>

            </ul>
        </div>
    </div>
</section>

<!-- History Section -->
<section class="py-16 bg-white dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                Our Journey
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Building a more equitable, sustainable, and community-driven banking model
            </p>
        </div>

        <div class="space-y-8">

            <!-- Vision -->
            <div class="flex flex-col md:flex-row items-center gap-8">
                <div class="md:w-1/3">
                    <div class="bg-primary-100 dark:bg-primary-900/30 rounded-2xl p-6 text-center">
                        <div class="text-3xl font-bold text-primary-600 dark:text-primary-400 mb-2">Before 2007</div>
                        <div class="text-gray-900 dark:text-white font-semibold">A New Vision</div>
                    </div>
                </div>
                <div class="md:w-2/3">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Challenging Traditional Banking</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        For too long, banks prioritized profit over people and the planet. We were founded to prove that banking can be equitable, sustainable, and aligned with the public good.
                    </p>
                </div>
            </div>

            <!-- Founded -->
            <div class="flex flex-col md:flex-row-reverse items-center gap-8">
                <div class="md:w-1/3">
                    <div class="bg-teal-100 dark:bg-teal-900/30 rounded-2xl p-6 text-center">
                        <div class="text-3xl font-bold text-teal-600 dark:text-teal-400 mb-2">2007</div>
                        <div class="text-gray-900 dark:text-white font-semibold">Founded</div>
                    </div>
                </div>
                <div class="md:w-2/3 text-right">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">A Triple Bottom Line Bank</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Co-Founders Kat Taylor and Tom Steyer launched a new kind of community bank — one designed to equally prioritize people, the planet, and long-term financial sustainability.
                    </p>
                </div>
            </div>

            <!-- Ownership Model -->
            <div class="flex flex-col md:flex-row items-center gap-8">
                <div class="md:w-1/3">
                    <div class="bg-purple-100 dark:bg-purple-900/30 rounded-2xl p-6 text-center">
                        <div class="text-3xl font-bold text-purple-600 dark:text-purple-400 mb-2">Public Interest</div>
                        <div class="text-gray-900 dark:text-white font-semibold">Unique Ownership</div>
                    </div>
                </div>
                <div class="md:w-2/3">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Governed for the Greater Good</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        The founding capital was donated to a nonprofit foundation, making it the majority owner of the Bank. This structure ensures permanent governance in the public interest.
                    </p>
                </div>
            </div>

            <!-- Present -->
            <div class="flex flex-col md:flex-row-reverse items-center gap-8">
                <div class="md:w-1/3">
                    <div class="bg-orange-100 dark:bg-orange-900/30 rounded-2xl p-6 text-center">
                        <div class="text-3xl font-bold text-orange-600 dark:text-orange-400 mb-2">2024</div>
                        <div class="text-gray-900 dark:text-white font-semibold">$1.9B Assets</div>
                    </div>
                </div>
                <div class="md:w-2/3 text-right">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">Growing With Purpose</h3>
                    <p class="text-gray-600 dark:text-gray-300">
                        Today, we are a $1.9 billion asset, state-chartered, federally insured bank serving communities across California, Oregon, and Washington — continuing to scale impact-driven banking.
                    </p>
                </div>
            </div>

        </div>
    </div>
</section>

<x-image-top-service :grid-cols="3" py="py-8 md:py-12" title="Learn More About {{ config('app.name') }}" :cards="[
    [
        'image' => '/images/about/Monarch-Butterfly-on-White-Background.webp',
        'title' => 'Vision & Mission',
        'description' => 'Our vision and mission guide every aspect of our work, and help us advance toward a common goal.',
        'buttonText' => 'Learn More',
        'buttonLink' => route('about.vision')
    ],
    [
        'image' => '/images/about/Tuttle-BSB-PDX-2022-0034-Mayshin-Keltner-Jonah-Schuster-Becky-Gordon.webp',
        'title' => 'Career\'s',
        'description' => 'We\'re looking for team members who share our passion for community, equity, inclusion, and the environmen',
        'buttonText' => 'Learn More',
        'buttonLink' => route('about.career')
    ],
    [
        'image' => '/images/about/Beneficial-State-Bank-Seattle-Team-Members.webp',
        'title' => 'Leadership Team',
        'description' => 'Our leaders have diverse backgrounds and deep expertise in industries such as finance, nonprofits, start-ups, law, and banking.',
        'buttonText' => 'Learn More',
        'buttonLink' => route('about.team')
    ],
      [
        'image' => '/images/about/lost-card.webp',
        'title' => 'Frequently Asked Questions',
        'description' => 'Help finding your account and routing number, managing your debit or credit card, making a payment on a loan, and much more.',
        'buttonText' => 'Learn More',
        'buttonLink' => route('about.faqs')
    ],
      [
        'image' => '/images/about/videobanking_woman.webp',
        'title' => 'Contact Us',
        'description' => 'We\'re here to help. You can connect with our team via secure message, phone, email, video banking, or by visiting a branch.',
        'buttonText' => 'Learn More',
        'buttonLink' => route('about.contact')
    ],
      [
        'image' => '/images/about/Perla-Cantu-at-Chabot-flipped-nametag-edit.webp',
        'title' => 'Sponsorships',
        'description' => 'We provide sponsorships to nonprofits in California, Oregon, and Washington that are engaged in social justice and environmental work.',
        'buttonText' => 'Learn More',
        'buttonLink' => route('nonprofit.lending')
    ]
]" />

<!-- Stats Section -->
<section class="py-16 bg-primary-600 dark:bg-primary-700">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-white mb-4">
                By the Numbers
            </h2>
            <p class="text-xl text-primary-100">
                Our growth reflects the trust our customers place in us
            </p>
        </div>

        <div class="grid grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="text-center">
                <div class="text-4xl lg:text-5xl font-bold text-white mb-2">50K+</div>
                <div class="text-primary-100">Active Customers</div>
            </div>
            <div class="text-center">
                <div class="text-4xl lg:text-5xl font-bold text-white mb-2">$2.5B</div>
                <div class="text-primary-100">Assets Under Management</div>
            </div>
            <div class="text-center">
                <div class="text-4xl lg:text-5xl font-bold text-white mb-2">25</div>
                <div class="text-primary-100">Branch Locations</div>
            </div>
            <div class="text-center">
                <div class="text-4xl lg:text-5xl font-bold text-white mb-2">99.9%</div>
                <div class="text-primary-100">Uptime Guarantee</div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 bg-white dark:bg-gray-900">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center fade-in-up">
        <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
            Ready to Join Our Family?
        </h2>
        <p class="text-xl text-gray-600 dark:text-gray-300 mb-8">
            Experience the difference of banking with a trusted partner who puts your financial success first.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('user.register') }}" class="inline-flex items-center px-8 py-4 bg-primary-600 hover:bg-primary-700 text-white font-bold rounded-2xl transition-all duration-300 shadow-lg hover:shadow-xl hover:-translate-y-1">
                 <x-flux::icon.user-plus variant="solid" class="w-5 h-5 mr-3" />
                Open an Account
            </a>
            <a href="{{ route('about.contact') }}" class="inline-flex items-center px-8 py-4 bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 text-gray-900 dark:text-white font-semibold rounded-2xl transition-all duration-300">
                <x-flux::icon.phone variant="solid" class="w-5 h-5 mr-3" />
                Contact Us
            </a>
        </div>
    </div>
</section>
</div>
</x-layouts::front>