<x-layouts::front :title="__('about || career', ['app' => config('app.name')])">
<div class="">
      <x-hero-static
    title="Join Our Team"
    description="Explore exciting career opportunities and be part of a team that’s making a real impact. Discover how you can grow, contribute, and thrive with us."
    badge="Career"
    badgeIcon="briefcase"
/>
<x-breadcrumbs config-key="about_us" />

<section id="career" class="relative bg-gray-50 dark:bg-gray-900 overflow-hidden py-12">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-8 fade-in-up">

        <!-- Intro -->
        <div class="space-y-4">
            <h2 class="text-primary-600 text-3xl md:text-4xl tracking-wide font-semibold">
             Join the Ethical Banking Movement
            </h2>
            <p class="text-gray-700 dark:text-gray-300 text-base md:text-lg leading-relaxed">
             If you have a passion for building a better banking industry, we invite you to join us.
            </p>
                 <span class="text-primary-600 font-medium capitalize text-center italic text-base">no open position right now check back</span>
        </div>

      <div class="space-y-6">
                   <h2 class="text-primary-600 text-3xl md:text-4xl tracking-wide font-semibold">
     What is {{ config('app.name') }}™?
            </h2>
                <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                     {{ config('app.name') }} is a B Corp and a triple-bottom-line bank. This means that rather than serving the single bottom line of profit, as do most traditional businesses, we equally prioritize the three goals of serving our communities, supporting positive environmental outcomes, and achieving long-term financial sustainability.
                        </p>
                <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
                     We design our products and services to optimize social and environmental impact, and our commitments include no predatory lending, no investments (meaning lending) to the fossil fuel, private prison, or weapons manufacturing industries. Instead of working to maximize shareholder profits, we work to further social justice and equity, invest in environmental sustainability and regeneration, and strive to extend prosperity to all members of our communities..
                        </p>
                <p class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
            We operate with purpose and strive toward a lofty goal: building an economy that restores our planet and extends prosperity to everyone.
                        </p>
                <b class="text-gray-700 dark:text-gray-300 mt-2 leading-relaxed text-sm md:text-base">
       Help us work toward a world where we bank with purpose.
                        </b>
      </div>
    </div>
</section>

<x-benefits-section
    title="Our Benefits Include*:"
    banner="*Benefit information as of July 1, 2025"
    :benefitGroups="[
        [
            'title' => 'Insurance Coverage',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Begins on first day of employment',
                'Medical (Blue Shield and Kaiser where available)',
                'High Deductible Health Plan (HDHP) available, with Health Savings Account',
                'Dental and vision through Guardian',
                'Life insurance with options for employees to increase coverage or for spouse/children coverage',
                'Employer-paid short- and long-term disability',
                'Employer-paid mental health benefits with Employee Assistance Program (EAP) for employees and their household',
                'Tax-advantaged medical and dependent care programs',
                'Supplemental health plans',
            ],
        ],
        [
            'title' => 'Retirement Plans',
            'bgColor' => 'bg-sky-900',
            'items' => [
                '401(k) and ROTH SAFE Harbor plans with up to 5% employer matching',
                'Eligible to contribute the first day of the month after employment begins',
                'Financial wellness workshops',
            ],
        ],
        [
            'title' => 'Paid Time Off',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Vacation: 2-4 weeks per year, depending on role',
                'Sick time',
                'Birthday float: an extra day off to use on or around your birthday',
                'Holidays: bank-wide closure for all federally recognized holidays',
                'Rejuvenation days to support overall wellbeing'
            ],
            
        ],
         [
            'title' => 'Incentive & Discretionary Bonus Programs',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Vacation: Most employees are eligible to participate in an annual discretionary bonus program based on individual and bank performance.',
                'Some positions participate in a performance-based incentive program.',
                'Wellness: $25 per month with a wellness pledge to support each employee’s wellbeing.',
                'Commuting: $100 per month to make it easier to get to work. Also available: tax-advantaged programs for transit and parking.'
            ],
            
        ],
          [
            'title' => 'Giving Back to Our Communities',
            'bgColor' => 'bg-sky-900',
            'items' => [
                '4 days of paid volunteer time each year.',
                '$250 annual match of qualifying employee donations.',
            ],
            
        ],
            [
            'title' => 'Pet Benefits',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Dog-friendly workplaces',
                'Pet rescue reimbursement',
                'Pet insurance',
                'Paid sick pet and pet bereavement days'
            ],
            
        ],
         [
            'title' => 'Reimbursement Programs',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Health Savings Account, Flexible Spending Account, and Dependent Flexible Spending Account',
                'Commuter Flexible Savings Account for transportation and parking',
                'Pet insurance',
                'Adoption Assistance Program'
            ],
            
        ],
          [
            'title' => 'Sabbatical Program',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Following 5th, 10th, and 15th anniversaries',
                'Extra paid time off',
                'Travel and entertainment reimbursement',
                'Adoption Assistance Program'
            ],
            
        ],
          [
            'title' => 'Other Benefits',
            'bgColor' => 'bg-sky-900',
            'items' => [
                'Banking products with discounted rates',
                'Tuition reimbursement',
            ],
            
        ],
    ]"
/>

@php
$careerFaqs = [
    [
        'question' => 'How do I apply for a job?',
        'answer' => 'You can apply via our <a href="#career" class="text-primary-600 hover:underline">careers page</a>.'
    ],
    [
        'question' => 'What benefits do you offer?',
        'answer' => 'We offer health, dental, vision, retirement plans, and flexible work options.'
    ],
    [
        'question' => 'Do you offer remote positions?',
        'answer' => 'Yes! Many of our roles support remote or hybrid work.'
    ],
];
@endphp

<x-faq-section
    title="Career FAQs"
    :faqs="$careerFaqs"
/>



@php
$employmentLinks = [
    ['text' => 'Employee Polygraph Protection Act', 'href' => asset('/documents/US-Department-of-Labor-Employee-Polygraph-Protection-Act.pdf')],
    ['text' => 'E-Verify Notification', 'href' => asset('/documents/E-Verify-Participation-Poster.pdf')],
    ['text' => 'Family and Medical Leave Act (FMLA)', 'href' => asset('/documents/US-Department-of-Labor-Family-and-Medical-Leave-Act.pdf')],
    ['text' => 'Job Applicant Privacy Policy', 'href' => route('privacy.job')],
    ['text' => 'Know Your Rights: Workplace Discrimination is Illegal', 'href' => asset('/documents/EEOC-Know-Your-Rights-Workplace-Discrimination.pdf')],
    ['text' => 'Right to Work Notification', 'href' => asset('/documents/Right-to-Work-Poster.pdf')],
];
@endphp

<section class="relative bg-gray-50 dark:bg-gray-900 py-12">
    <div class="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-10 fade-in-up">
        <!-- Intro -->
        <div class="space-y-4 max-w-3xl">
            <h2 class="text-primary-600 text-3xl md:text-4xl font-semibold tracking-wide">
                You are welcome here at {{ config('app.name') }}™
            </h2>
            <p class="text-gray-700 dark:text-gray-300 text-base md:text-lg leading-relaxed">
                We are an equal opportunity employer and all qualified applicants will receive consideration for employment, regardless of race, color, religion, sex, sexual orientation, national origin, gender identity, disability, or veteran status.
            </p>
        </div>

        <!-- Employment Rights -->
        <div class="space-y-6 max-w-4xl">
            <h3 class="text-xl md:text-2xl font-semibold text-gray-900 dark:text-gray-50">
                Applicants have rights under federal employment laws
            </h3>

            <ul class="space-y-3">
                @foreach($employmentLinks as $link)
                    <li>
                        <a href="{{ $link['href'] }}" target="_blank" class="flex items-start gap-3 text-gray-700 dark:text-gray-300 text-sm md:text-base leading-relaxed underline hover:text-sky-800 focus:outline-none focus:ring-2 focus:ring-primary-500 transition-colors duration-200">
                            <span class="w-2 h-2 rounded-full bg-primary-600 mt-2 shrink-0"></span>
                            <span>{{ $link['text'] }}</span>
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
</section>

</div>




</x-layouts::front>