<div
    class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-lg dark:shadow-gray-900/50 overflow-hidden border border-white/20 dark:border-gray-700/50">
    <!-- Header -->
    <div
        class="px-4 py-2 bg-linear-to-r from-slate-50/80 to-slate-100/50 dark:from-slate-800/50 dark:to-slate-700/50 border-b border-slate-100/50 dark:border-slate-600/70">
        <div class="flex items-center">
            <div class="w-6 h-6 bg-slate-500 dark:bg-slate-600 rounded-lg flex items-center justify-center mr-2">
                <x-flux::icon.chart-line class="w-3 h-3 text-white" />
            </div>
            <h3 class="text-sm font-bold text-slate-900 dark:text-slate-50">Account Statistics</h3>
        </div>
    </div>

    <!-- Stats Content -->
    <div class="p-3 space-y-2">
        @foreach ($summaryStats as $stat)
            <div tabindex="0"
                class="group p-2 bg-linear-to-br from-gray-50/50 to-white/50 dark:from-gray-700/50 dark:to-gray-800/50 hover:from-sky-50/50 hover:to-sky-100/30 dark:hover:from-sky-900/30 dark:hover:to-sky-800/30 rounded-xl border border-gray-100/50 dark:border-gray-600/50 hover:border-sky-200/50 dark:hover:border-sky-700/50 transition-all duration-300 hover:shadow-md hover:shadow-sky-500/10 dark:hover:shadow-sky-900/20">
                <div class="flex items-center">
                    <!-- Icon -->
                    <div class="relative">
                        <div
                            class="w-8 h-8 bg-linear-to-br from-sky-500 to-sky-600 rounded-lg flex items-center justify-center shadow-md shadow-sky-500/25 dark:shadow-sky-900/50 group-hover:scale-110 transition-transform duration-300">
                            <x-flux::icon variant="solid" :name="$stat['icon']" class="w-5 h-5 text-white" />
                        </div>
                        <div
                            class="absolute -top-0.5 -right-0.5 w-2 h-2 bg-white dark:bg-gray-800 rounded-full border border-sky-500 opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        </div>
                    </div>

                    <!-- Content -->
                    <div class="flex-1 min-w-0 ml-3">
                        <div class="flex items-center justify-between mb-0.5">
                            <p class="text-xs font-semibold text-gray-500 dark:text-gray-400 uppercase tracking-wider">
                                {{ $stat['label'] }}</p>
                            <div
                                class="w-1.5 h-1.5 bg-sky-500 rounded-full opacity-60 group-hover:opacity-100 transition-opacity duration-300">
                            </div>
                        </div>
                        <p
                            class="text-sm font-bold text-gray-900 dark:text-white truncate group-hover:text-sky-700 dark:group-hover:text-sky-300 transition-colors duration-300">
                            @if ($stat['has_symbol'])
                                {{ $currencySymbol }}{{ $stat['value'] }}
                            @else
                                {{ $stat['value'] }}
                            @endif
                        </p>
                        <p
                            class="text-xs text-gray-500 dark:text-gray-400 group-hover:text-sky-600 dark:group-hover:text-sky-400 transition-colors duration-300">
                            {{ $stat['description'] }}</p>

                        @isset($stat['progress'])
                            @php
                                $progress = min(100, max(0, round($stat['progress'], 1)));
                            @endphp

                            <div class="mt-2 w-full h-1.5 rounded-full bg-gray-200 dark:bg-gray-700 overflow-hidden">
                                <div @class([
                                    'h-full transition-[width] duration-500 ease-out rounded-full',
                                    'bg-red-500 dark:bg-red-400' => $progress < 40,
                                    'bg-yellow-500 dark:bg-yellow-400' => $progress >= 40 && $progress < 70,
                                    'bg-green-500 dark:bg-green-400' => $progress >= 70
                                ]) style="width: {{ $progress }}%">
                                </div>
                            </div>
                        @endisset
                    </div>
                </div>

                <!-- Progress indicator -->
                <div class="mt-2 h-0.5 bg-gray-200 dark:bg-gray-600 rounded-full overflow-hidden">
                    <div
                        class="h-full bg-linear-to-r from-sky-500 to-sky-600 rounded-full transform scale-x-0 group-hover:scale-x-100 transition-transform duration-500 origin-left">
                    </div>
                </div>
            </div>
        @endforeach
    </div>

    <!-- Footer -->
    <div
        class="px-3 py-2 bg-linear-to-r from-gray-50/50 to-white/50 dark:from-gray-700/50 dark:to-gray-800/50 border-t border-gray-100/50 dark:border-gray-600/50">
        <div class="flex items-center justify-center text-xs text-gray-500 dark:text-gray-400">
            <i class="fa-solid fa-clock mr-1 text-sky-500 text-xs"></i>
            <span>Updated in real-time</span>
        </div>
    </div>
</div>
