@php
    $cards = $this->focusedCards(); // fetch loan, grant, tax_refund, credit_card
    $currency = $this->currencySymbol;
@endphp

@if ($cards['loan'] || $cards['grant'] || $cards['tax_refund'])
    <div
        class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-lg dark:shadow-gray-900/50 overflow-hidden border border-white/20 dark:border-gray-700/50">

        <!-- Header -->
        <div
            class="px-4 py-2 bg-linear-to-r from-slate-50/80 to-slate-100/50 dark:from-slate-800/50 dark:to-slate-700/50 border-b border-slate-100/50 dark:border-slate-600/70 flex items-center justify-between gap-3 flex-wrap">
            <div class="flex items-center">
                <div class="w-6 h-6 bg-slate-500 dark:bg-slate-600 rounded-lg flex items-center justify-center mr-2">
                    <x-flux::icon.arrows-right-left class="w-3 h-3 text-white" />
                </div>
                <h3 class="text-sm font-bold text-slate-900 dark:text-slate-50">Financial Services</h3>
            </div>

            <a href="{{ route('user.transactions') }}"
                class="text-xs font-medium text-sky-700 dark:text-sky-400 hover:underline">View Details</a>
        </div>

        <!-- Services Grid -->
        <div class="grid grid-cols-1 gap-4">

            {{-- Loan --}}
            @if ($cards['loan'])
                <x-financial-card title="Loans" status="Processed"
                    amount="{{ $currency }}{{ number_format($cards['loan']->amount, 2) }}" icon="building-library"
                    bgFrom="from-blue-50" bgTo="to-blue-100" textColor="text-blue-700" :link="route('user.loans.index')" />
            @endif

            {{-- Grant --}}
            @if ($cards['grant'])
                <x-financial-card title="Grants" status="Processed"
                    amount="{{ $currency }}{{ number_format($cards['grant']->amount, 2) }}" icon="hand-helping"
                    bgFrom="from-green-50" bgTo="to-green-100" textColor="text-green-700" :link="route('user.grants.index')" />
            @endif

            {{-- Tax Refund --}}
            @if ($cards['tax_refund'])
                <x-financial-card title="Tax Refund" status="Pending"
                    amount="Filing ID: {{ $cards['tax_refund']->filing_id ?? 'Required' }}" icon="hand-helping"
                    bgFrom="from-purple-50" bgTo="to-purple-100" textColor="text-purple-700" :link="route('user.tax.refund.index')" />
            @endif

        </div>


    </div>
@endif
