<div class="space-y-6">

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <x-flux::select label="Country" placeholder="Select a country" wire:model.live.debounce.500ms="country">
                @foreach ($countries as $c)
                    <flux:select.option value="{{ $c['code'] }}">
                        {{ $c['emoji'] }} {{ $c['name'] }}
                    </flux:select.option>
                @endforeach
            </x-flux::select>
        </div>

        <div class="relative">
            @if (!empty($states))
                <x-flux::select label="State / Province" placeholder="Select a state" wire:model.live.blur="state"
                    wire:loading.attr="disabled" wire:target="country">
                    @foreach ($states as $s)
                        <flux:select.option value="{{ $s['name'] }}">
                            {{ $s['name'] }}
                        </flux:select.option>
                    @endforeach
                </x-flux::select>

                <!-- Spinner inside the select -->
                <div wire:loading wire:target="country" class="absolute top-1/2 right-3 -translate-y-1/2">
                    <svg class="animate-spin h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                            stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                    </svg>
                </div>
            @else
                <x-flux::input label="State / Province" placeholder="Enter your state or province"
                    wire:model.live.blur="state" wire:loading.attr="disabled" wire:target="country" />

                <!-- Optional spinner for input as well -->
                <div wire:loading wire:target="country" class="absolute top-1/2 right-3 -translate-y-1/2">
                    <svg class="animate-spin h-5 w-5 text-gray-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                            stroke-width="4"></circle>
                        <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                    </svg>
                </div>
            @endif
        </div>
    </div>

    <flux:input.group label="Phone Number">
        <!-- Dial Code -->
        <flux:select wire:model.defer="formData.dial_code" class="max-w-fit">
            <flux:select.option value="">Code</flux:select.option>
            @foreach ($countries as $countryItem)
                <flux:select.option value="{{ $countryItem['dial_code'] }}">
                    {{ $countryItem['emoji'] }} {{ $countryItem['code'] }} {{ $countryItem['dial_code'] }}
                </flux:select.option>
            @endforeach
        </flux:select>

        <!-- Phone Number -->
        <div class="w-full">
            <flux:input wire:model.defer="formData.phone" prefix="{{ $formData['dial_code'] ?? '' }}"
                placeholder="777-777-0000" class="flex-1" />
            <flux:error name="formData.phone" />
        </div>
    </flux:input.group>

    <!-- Address -->
    <div>
        <x-input wire:model.defer="formData.address_1" label="Street address line 1" placeholder="123 Main St" />
    </div>
    <div>
        <x-input wire:model.defer="formData.address_2" label="Street address line 2"
            placeholder="Apartment, studio, or floor" />
    </div>
    <div>
        <x-input wire:model.defer="formData.city" label="City" placeholder="San Francisco" />
    </div>
    <div>
        <x-input wire:model.defer="formData.zip_code" label="Postal / Zip code" placeholder="12345" />
    </div>

</div>
