<div
    class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-lg dark:shadow-gray-900/50 overflow-hidden border border-white/20 dark:border-gray-700/50">

    <!-- Header -->
    <div
        class="px-4 py-2 bg-linear-to-r from-slate-50/80 to-slate-100/50 dark:from-slate-800/50 dark:to-slate-700/50 border-b border-slate-100/50 dark:border-slate-600/70 flex items-center justify-between gap-3 flex-wrap">
        <div class="flex items-center">
            <div class="w-6 h-6 bg-slate-500 dark:bg-slate-600 rounded-lg flex items-center justify-center mr-2">
                <x-flux::icon.arrow-path-rounded-square class="w-3 h-3 text-white" />
            </div>
            <h3 class="text-sm font-bold text-slate-900 dark:text-slate-50">Account Health Dashboard</h3>
        </div>

        <a href="#" class="text-xs font-medium text-sky-700 dark:text-sky-400 hover:underline">View Details</a>

    </div>

    <!-- Health Metrics Grid -->
    <div class="space-y-3 p-3">

        @php
            $period = $healthPeriod ?? 'daily';
            $health = $healthStats['account_health'][$period] ?? null;

            $progress = $health['progress'] ?? 0;

            // Risk tiers
            if ($progress >= 90) {
                $riskColor = 'red';
                $riskLabel = 'Critical';
            } elseif ($progress >= 75) {
                $riskColor = 'yellow';
                $riskLabel = 'Near Limit';
            } else {
                $riskColor = 'green';
                $riskLabel = 'Healthy';
            }

            // Monthly availability (30-day rule)
            $monthlyAvailable = $accounts->firstWhere('id', $focusedAccountId)?->created_at?->lte(now()->subDays(30));
        @endphp

        <!-- Account Health -->
        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">

            <!-- Header -->
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div
                        class="w-12 h-12 flex items-center justify-center rounded-lg
                bg-{{ $riskColor }}-50 dark:bg-{{ $riskColor }}-800">
                        <x-flux::icon.exclamation-triangle
                            class="w-6 h-6 text-{{ $riskColor }}-700 dark:text-{{ $riskColor }}-300" />
                    </div>

                    <div>
                        <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">
                            Account Health
                        </h3>

                        <span
                            class="text-xs px-2 py-1 rounded-full
                    bg-{{ $riskColor }}-100 text-{{ $riskColor }}-700 font-medium">
                            {{ $riskLabel }}
                        </span>
                    </div>
                </div>

                <!-- Toggle -->
                <div class="flex gap-1">
                    <button wire:click="$set('healthPeriod','daily')"
                        class="px-3 py-1 text-xs rounded-full transition
                {{ $healthPeriod === 'daily' ? 'bg-' . $riskColor . '-600 text-white' : 'bg-gray-200 dark:bg-gray-700' }}">
                        Daily
                    </button>

                    <button wire:click="{{ $monthlyAvailable ? "\$set('healthPeriod','monthly')" : '' }}"
                        @disabled(!$monthlyAvailable)
                        class="px-3 py-1 text-xs rounded-full transition
                {{ $healthPeriod === 'monthly' ? 'bg-' . $riskColor . '-600 text-white' : 'bg-gray-200 dark:bg-gray-700' }}
                {{ !$monthlyAvailable ? 'opacity-50 cursor-not-allowed' : '' }}">
                        Monthly
                    </button>
                </div>
            </div>

            <!-- Limit Breach Banner -->
            @if ($progress >= 90)
                <div class="text-xs px-3 py-2 rounded-md
            bg-red-50 text-red-700 border border-red-200">
                    ⚠ Critical usage level reached. Transactions may be declined.
                </div>
            @elseif ($progress >= 75)
                <div
                    class="text-xs px-3 py-2 rounded-md
            bg-yellow-50 text-yellow-700 border border-yellow-200">
                    ⚠ You are nearing your {{ $period }} transaction limit.
                </div>
            @endif

            <!-- Progress Bar -->
            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                <div class="h-2 rounded-full bg-{{ $riskColor }}-600 transition-all duration-300"
                    style="width: {{ $progress }}%">
                </div>
            </div>

            <!-- Usage Text -->
            <div class="text-gray-600 dark:text-gray-400 text-xs">
                {{ $currencySymbol }}{{ number_format($health['used'] ?? 0, 2) }}
                of {{ $currencySymbol }}{{ number_format($health['limit'] ?? 0, 2) }} used
            </div>

            <!-- Monthly availability note -->
            @if (!$monthlyAvailable)
                <div class="text-[10px] text-gray-400">
                    Monthly limits available after 30 days of account activity
                </div>
            @endif
        </div>

        <!-- Activity Consistency Card -->
        @php
            $activity = $healthStats['activity_consistency'] ?? ['percent' => 0, 'active_days' => 0, 'total_days' => 0];
            $percent = $activity['percent'];

            // Tier logic
            if ($percent >= 80) {
                $tierColor = 'green';
                $tierLabel = 'Consistent';
            } elseif ($percent >= 50) {
                $tierColor = 'yellow';
                $tierLabel = 'Moderate';
            } else {
                $tierColor = 'red';
                $tierLabel = 'Low';
            }
        @endphp

        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">

            <!-- Header -->
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div
                        class="w-12 h-12 flex items-center justify-center rounded-lg
                bg-{{ $tierColor }}-50 dark:bg-{{ $tierColor }}-800">
                        <x-flux::icon.clock
                            class="w-6 h-6 text-{{ $tierColor }}-700 dark:text-{{ $tierColor }}-300" />
                    </div>

                    <div>
                        <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">
                            Activity Consistency
                        </h3>

                        <span
                            class="text-xs px-2 py-1 rounded-full
                    bg-{{ $tierColor }}-100 text-{{ $tierColor }}-700 font-medium">
                            {{ $tierLabel }}
                        </span>
                    </div>
                </div>
            </div>

            <!-- Progress Bar -->
            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 mt-2">
                <div class="h-2 rounded-full bg-{{ $tierColor }}-600 transition-all"
                    style="width: {{ $percent }}%">
                </div>
            </div>

            <!-- Usage Text -->
            <div class="text-gray-600 dark:text-gray-400 text-xs">
                Active {{ $activity['active_days'] }} of {{ $activity['total_days'] }} days this month
            </div>

            <!-- Tier Alert Banner -->
            @if ($percent < 50)
                <div class="text-xs px-3 py-2 rounded-md
        bg-red-50 text-red-700 border border-red-200">
                    ⚠ Low account activity. Consider using your account regularly.
                </div>
            @elseif($percent >= 50 && $percent < 80)
                <div class="text-xs px-3 py-2 rounded-md
        bg-yellow-50 text-yellow-700 border border-yellow-200">
                    ⚠ Moderate activity. Aim for more consistent usage.
                </div>
            @endif
        </div>

        <!-- Spending Trends -->
        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">

            <div class="flex items-center gap-3">
                <div
                    class="w-12 h-12 flex items-center justify-center rounded-lg
                bg-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-50
                dark:bg-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-800">
                    <x-flux::icon.chart-bar
                        class="w-6 h-6 text-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-700
                    dark:text-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-300" />
                </div>

                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">
                        Spending Trends
                    </h3>

                    <span
                        class="text-xs px-2 py-1 rounded-full
                    bg-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-100
                    text-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-700 font-medium">
                        {{ $healthStats['spending_trends']['label'] ?? 'No Data' }}
                    </span>
                </div>
            </div>

            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 mt-2">
                <div class="h-2 rounded-full bg-{{ $healthStats['spending_trends']['color'] ?? 'gray' }}-600 transition-all"
                    style="width: {{ $healthStats['spending_trends']['progress'] ?? 0 }}%">
                </div>
            </div>

            <div class="text-gray-600 dark:text-gray-400 text-xs">
                {{ $currencySymbol }}{{ number_format($healthStats['spending_trends']['value'] ?? 0, 2) }}
                spent this month
            </div>
        </div>

        <!-- Alerts / Notifications -->
        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">
            <div class="flex items-center gap-3">
                <div
                    class="w-12 h-12 flex items-center justify-center rounded-lg bg-linear-to-br from-purple-50 to-purple-100 dark:from-purple-800 dark:to-purple-700">
                    <x-flux::icon.bell class="w-6 h-6 text-purple-700 dark:text-purple-300" />
                </div>
                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">Alerts</h3>
                    <span
                        class="text-xs px-2 py-1 rounded-full bg-purple-50 dark:bg-purple-800 text-purple-700 dark:text-purple-300 font-medium">
                        {{ $unreadAlerts }} Unread
                    </span>
                </div>
            </div>
            <div class="mt-2 text-gray-600 dark:text-gray-400 text-xs">
                Review account notifications and security alerts.
            </div>
        </div>

    </div>
</div>
