<header x-data="{
    lastScroll: 0,
    isHidden: false,
    isCompact: false,
    scrollThreshold: 80,
    scrollBuffer: 12,
    handleScroll() {
        const current = window.pageYOffset;
        const delta = current - this.lastScroll;
        this.isCompact = current > this.scrollThreshold;
        if (current <= 0) {
            this.isHidden = false;
            this.lastScroll = current;
            return;
        }
        if (delta > this.scrollBuffer && current > this.scrollThreshold) this.isHidden = true;
        if (delta < -this.scrollBuffer) this.isHidden = false;
        this.lastScroll = current;
    }
}" @scroll.window="handleScroll"
    :class="{ '-translate-y-full': isHidden, 'translate-y-0': !isHidden }"
    class="hidden lg:block fixed top-0 left-0 right-0 transition-all duration-300 ease-out z-50">
    <!-- Utility Top Bar -->
    <div
        class="bg-linear-to-r from-primary-50 via-white to-primary-50 dark:from-primary-900 dark:via-gray-900 dark:to-primary-900 border-b border-primary-200/60 dark:border-primary-800/60">
        <div
            class="max-w-7xl mx-auto px-6 h-9 flex items-center justify-between text-xs font-medium text-primary-700 dark:text-primary-200">
            <div class="flex items-center gap-6">
                <a href="{{ route('about.contact') }}"
                    class="flex items-center gap-1 hover:text-primary-600 dark:hover:text-white transition-colors duration-200">
                    <x-flux::icon.phone class="w-3.5 h-3.5 text-primary-500 dark:text-primary-400" /> Contact Us
                </a>
                <a href="{{ route('about.faqs') }}"
                    class="flex items-center gap-1 hover:text-primary-600 dark:hover:text-white transition-colors duration-200">
                    <x-flux::icon.question-mark-circle class="w-3.5 h-3.5 text-primary-500 dark:text-primary-400" />
                    Help & Support
                </a>
            </div>
            <div class="flex items-center gap-6">
                <span class="flex items-center gap-1 tracking-wide">
                    <x-flux::icon.building-office class="w-3.5 h-3.5 text-primary-500 dark:text-primary-400" />
                    Routing #: {{ config('app.routing_number') }}
                </span>
                <a href="mailto:{{ config('app.email') }}"
                    class="flex items-center gap-1 hover:text-primary-600 dark:hover:text-white transition-colors duration-200">
                    <x-flux::icon.calendar class="w-3.5 h-3.5 text-primary-500 dark:text-primary-400" />
                    Schedule Appointment
                </a>
            </div>
        </div>
    </div>

    <!-- Navigation -->
    <nav :class="{ 'backdrop-blur-xl shadow-xl border-b border-primary-200/50 dark:border-primary-700/40': isCompact, 'shadow-none border-transparent':
            !isCompact }"
        class="transition-all duration-300 bg-linear-to-r from-white/90 via-primary-50/90 to-white/90 dark:from-gray-900/90 dark:via-primary-900/90 dark:to-gray-900/90 relative">
        <!-- Animated Background Pattern -->
        <div class="absolute inset-0 overflow-hidden">
            <div
                class="absolute -top-10 -left-10 w-20 h-20 bg-primary-200/20 dark:bg-primary-800/20 rounded-full blur-xl animate-pulse">
            </div>
            <div class="absolute -top-5 right-1/4 w-16 h-16 bg-teal-200/20 dark:bg-teal-800/20 rounded-full blur-lg animate-pulse"
                style="animation-delay: 1s;"></div>
            <div class="absolute -bottom-10 -right-10 w-24 h-24 bg-purple-200/20 dark:bg-purple-800/20 rounded-full blur-xl animate-pulse"
                style="animation-delay: 2s;"></div>
        </div>

        <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div :class="{ 'h-14 lg:h-16': isCompact, 'h-16 lg:h-18': !isCompact }"
                class="flex justify-between items-center transition-all duration-300">
                <!-- Logo -->
                <div class="flex items-center group">
                    <div class="relative">
                        <div
                            class="absolute inset-0 bg-primary-400/20 rounded-xl blur-lg group-hover:bg-primary-400/30 transition-all duration-300">
                        </div>
                        <a href="{{ route('home') }}" class="flex items-center gap-3">
                            <x-app-logo-icon class="size-9 fill-current text-black dark:text-white" />
                            <span
                                class="text-lg font-semibold z-20 tracking-wide text-gray-900 dark:text-white">{{ config('app.name') }}</span>
                        </a>
                    </div>
                </div>

                <!-- Desktop Navigation with modern styling -->
                <div class="hidden lg:flex items-center space-x-1">
                    <a href="{{ route('home') }}"
                        class="relative px-4 py-2 text-gray-700 dark:text-gray-300 font-medium transition-all duration-300 hover:text-primary-600 dark:hover:text-primary-400 group">
                        <span class="relative z-10">Home</span>
                        <div
                            class="absolute inset-0 bg-primary-50 dark:bg-primary-900/30 rounded-xl scale-0 group-hover:scale-100 transition-transform duration-300 origin-center">
                        </div>
                    </a>
                    <div class="relative group">
                        <button
                            class="relative px-4 py-2 text-gray-700 dark:text-gray-300 font-medium transition-all duration-300 hover:text-primary-600 dark:hover:text-primary-400 flex items-center">
                            <span class="relative z-10">About</span>
                            <x-flux::icon.chevron-down variant="solid"
                                class="w-4 h-4 ml-1 z-20 group-hover:rotate-180 transition-transform duration-300" />
                            <div
                                class="absolute inset-0 bg-primary-50 dark:bg-primary-900/30 rounded-xl scale-0 group-hover:scale-100 transition-transform duration-300 origin-center">
                            </div>
                        </button>
                        <!-- About Dropdown -->
                        <div
                            class="absolute top-full left-0 mt-2 w-64 bg-white dark:bg-gray-800 rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="p-2">
                                <a href="{{ route('about.overview') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.squares-plus variant="solid" class="w-5 h-5 text-primary-500 mr-3" />
                                    Overview
                                </a>
                                <a href="{{ route('about.vision') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.eye variant="solid" class="w-5 h-5 text-primary-500 mr-3" />
                                    Vision & Mission
                                </a>
                                <a href="{{ route('about.career') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.briefcase class="w-5 h-5 text-primary-500 mr-3" />
                                    Career
                                </a>
                                <a href="{{ route('about.team') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.user-group variant="solid" class="w-5 h-5 text-primary-500 mr-3" />
                                    Leadership Team
                                </a>
                                <a href="{{ route('about.faqs') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.question-mark-circle variant="solid"
                                        class="w-5 h-5 text-primary-500 mr-3" />
                                    Faqs
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="relative group">
                        <button
                            class="relative px-4 py-2 text-gray-700 dark:text-gray-300 font-medium transition-all duration-300 hover:text-primary-600 dark:hover:text-primary-400 flex items-center">
                            <span class="relative z-10">Services</span>
                            <x-flux::icon.chevron-down variant="solid"
                                class="w-4 z-20 h-4 ml-1 group-hover:rotate-180 transition-transform duration-300" />
                            <div
                                class="absolute inset-0 bg-primary-50 dark:bg-primary-900/30 rounded-xl scale-0 group-hover:scale-100 transition-transform duration-300 origin-center">
                            </div>
                        </button>
                        <!-- Services Dropdown -->
                        <div
                            class="absolute top-full left-0 mt-2 w-64 bg-white dark:bg-gray-800 rounded-2xl shadow-2xl border border-gray-200 dark:border-gray-700 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="p-2">
                                <a href="{{ route('personal.overview') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.user variant="solid" class="w-5 h-5 text-primary-500 mr-3" />
                                    Personal Banking
                                </a>
                                <a href="{{ route('business.overview') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.briefcase variant="solid" class="w-5 h-5 text-primary-500 mr-3" />
                                    Business Banking
                                </a>
                                <a href="{{ route('nonprofit.overview') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.handshake class="w-5 h-5 text-primary-500 mr-3" />
                                    Non-profit Banking
                                </a>
                                <a href="{{ route('personal.credit-cards') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.credit-card variant="solid" class="w-5 h-5 text-primary-500 mr-3" />
                                    Cards
                                </a>
                                <a href="{{ route('frontend.grant') }}"
                                    class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 hover:bg-primary-50 dark:hover:bg-primary-900/30 rounded-xl transition-all duration-300">
                                    <x-flux::icon.hand-coins class="w-5 h-5 text-primary-500 mr-3" />
                                    Grants & Aid
                                </a>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('about.contact') }}"
                        class="relative px-4 py-2 text-gray-700 dark:text-gray-300 font-medium transition-all duration-300 hover:text-primary-600 dark:hover:text-primary-400 group">
                        <span class="relative z-10">Contact</span>
                        <div
                            class="absolute inset-0 bg-primary-50 dark:bg-primary-900/30 rounded-xl scale-0 group-hover:scale-100 transition-transform duration-300 origin-center">
                        </div>
                    </a>
                </div>

                <!-- Desktop Action Buttons with enhanced styling -->
                <div class="hidden lg:flex items-center space-x-3">


                    <!-- Dark Mode Toggle with animation -->
                    <button @click="darkMode = !darkMode; localStorage.setItem('darkMode', darkMode)"
                        class="relative p-3 rounded-2xl bg-linear-to-br from-gray-50 to-gray-100 
               dark:from-gray-800 dark:to-gray-700 text-gray-600 dark:text-gray-300 
               hover:from-primary-50 hover:to-primary-100 
               dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 
               transition-all duration-300 shadow-lg hover:shadow-xl 
               hover:-translate-y-0.5 group">
                        <x-flux::icon.sun variant="solid" x-show="!darkMode" x-cloak
                            class="w-5 h-5 group-hover:rotate-180 transition-transform duration-500" />

                        <x-flux::icon.moon variant="solid" x-cloak x-show="darkMode"
                            class="w-5 h-5 group-hover:rotate-12 transition-transform duration-300" />
                    </button>

                    @guest
                        <!-- Login Button with hover effects -->
                        <a href="{{ route('login') }}"
                            class="relative px-4 py-2.5 text-primary-600 dark:text-primary-400 hover:text-primary-700 dark:hover:text-primary-300 font-semibold transition-all duration-300 group">
                            <span class="relative z-10">Login</span>
                            <div
                                class="absolute inset-0 bg-linear-to-r from-primary-50 to-primary-100 dark:from-primary-900/30 dark:to-primary-800/30 rounded-xl scale-0 group-hover:scale-100 transition-transform duration-300">
                            </div>
                        </a>

                        <!-- Open Account Button with premium styling -->
                        <a href="{{ route('user.register') }}"
                            class="relative px-6 py-2.5 bg-linear-to-r from-primary-600 via-primary-500 to-primary-600 hover:from-primary-700 hover:via-primary-600 hover:to-primary-700 text-white font-semibold rounded-2xl transition-all duration-300 shadow-lg shadow-primary-600/25 hover:shadow-xl hover:shadow-primary-600/40 hover:-translate-y-0.5 group overflow-hidden">
                            <span class="relative z-10 flex items-center">
                                <x-flux::icon.sparkles variant="solid" class="mr-2 group-hover:animate-spin w-4 h-4" />
                                Open Account
                            </span>
                            <div
                                class="absolute inset-0 bg-linear-to-r from-transparent via-white/20 to-transparent -translate-x-full group-hover:translate-x-full transition-transform duration-700">
                            </div>
                        </a>
                    </div>

                @endguest

                @auth
                    <a href="{{ route('user.dashboard') }}"
                        class="relative px-6 py-2.5 bg-linear-to-r from-primary-600 via-primary-500 to-primary-600 hover:from-primary-700 hover:via-primary-600 hover:to-primary-700 text-white font-semibold rounded-2xl transition-all duration-300 shadow-lg shadow-primary-600/25 hover:shadow-xl hover:shadow-primary-600/40 hover:-translate-y-0.5 group overflow-hidden">
                        <span class="relative z-10 flex items-center">
                            <x-flux::icon.user variant="solid" class="mr-2 group-hover:animate-spin w-4 h-4" />
                            My Account
                        </span>
                        <div
                            class="absolute inset-0 bg-linear-to-r from-transparent via-white/20 to-transparent -translate-x-full group-hover:translate-x-full transition-transform duration-700">
                        </div>
                    </a>
                @endauth
            </div>
        </div>
    </nav>
</header>

<header
    class="lg:hidden fixed top-0 left-0 right-0 z-50 bg-linear-to-br from-white via-primary-50 to-white dark:from-gray-900 dark:via-primary-900 dark:to-gray-900 shadow-xl">
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex justify-between items-center h-16">
        <!-- Logo -->
        <a href="{{ route('home') }}" class="flex items-center gap-2">
            <x-app-logo-icon class="size-9 fill-current text-black dark:text-white" />
            <span class="font-semibold z-20 text-lg text-gray-900 dark:text-white">{{ config('app.name') }}</span>
        </a>

        <!-- Mobile Menu Button -->
        <button @click="mobileMenuOpen = !mobileMenuOpen"
            class="lg:hidden relative p-3 rounded-2xl bg-linear-to-br 
               from-gray-50 to-gray-100 
               dark:from-gray-800 dark:to-gray-700 
               text-gray-600 dark:text-gray-300 
               shadow-lg hover:shadow-xl 
               transition-all duration-300 
               hover:-translate-y-0.5">

            <x-flux::icon.bars-3 variant="solid" class="w-4 h-4 transition-all duration-300" ::class="mobileMenuOpen
                ?
                'rotate-90 opacity-0 scale-75' :
                'rotate-0 opacity-100 scale-100'" />

            <x-flux::icon.x-mark variant="solid" class="w-4 h-4 absolute inset-0 m-auto transition-all duration-300"
                ::class="mobileMenuOpen
                    ?
                    'rotate-0 opacity-100 scale-100' :
                    '-rotate-90 opacity-0 scale-75'" />


        </button>
    </div>

    <!-- Enhanced Mobile Menu -->
    <div x-show="mobileMenuOpen" x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="opacity-0 -translate-y-4" x-transition:enter-end="opacity-1 translate-y-0"
        x-transition:leave="transition ease-in duration-200" x-transition:leave-start="opacity-1 translate-y-0"
        x-transition:leave-end="opacity-0 -translate-y-4"
        class="lg:hidden absolute top-full left-0 right-0 bg-linear-to-br from-white via-primary-50 to-white dark:from-gray-900 dark:via-primary-900 dark:to-gray-900 backdrop-blur-xl border-t border-primary-200/70 dark:border-primary-700/50 shadow-2xl shadow-primary-500/20">

        <!-- Mobile menu background pattern -->
        <div class="absolute inset-0 overflow-hidden">
            <div
                class="absolute top-0 left-1/4 w-32 h-32 bg-primary-200/20 dark:bg-primary-800/20 rounded-full blur-2xl">
            </div>
            <div class="absolute bottom-0 right-1/4 w-24 h-24 bg-teal-200/20 dark:bg-teal-800/20 rounded-full blur-xl">
            </div>
        </div>

        <div class="relative px-6 py-6 space-y-2">
            <!-- Navigation Links with enhanced styling -->
            <a href="{{ route('home') }}"
                class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 font-medium transition-all duration-300 rounded-2xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 hover:shadow-lg hover:translate-x-2 group">
                <x-flux::icon.home variant="solid"
                    class="mr-4 w-4 h-4 text-primary-500 group-hover:scale-110 transition-transform duration-300" />
                <span>Home</span>
                <x-flux::icon.chevron-right
                    class="w-4 h-4 ml-auto opacity-0 group-hover:opacity-100 transition-all duration-300" />
            </a>


            <!-- About Submenu -->
            <div x-data="{ AboutOpen: false }" class="space-y-2">
                <button @click="AboutOpen = !AboutOpen"
                    class="flex items-center w-full px-4 py-3 text-gray-700 dark:text-gray-300 
           hover:text-primary-600 dark:hover:text-primary-400 font-medium 
           transition-all duration-300 rounded-2xl 
           hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 
           dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 
           hover:shadow-lg hover:translate-x-2 group">
                    <x-flux::icon.cog variant="solid"
                        class="mr-4 w-4 h-4 text-primary-500 
               group-hover:scale-110 transition-transform duration-300" />

                    <span>About</span>

                    <x-flux::icon.chevron-right class="ml-auto w-4 h-4 transition-transform duration-300"
                        ::class="{ 'rotate-180': AboutOpen }" />
                </button>

                <div x-show="AboutOpen" x-show x-collapse class="ml-8 space-y-1">
                    <a href="{{ route('about.overview') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.squares-plus variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Overview
                    </a>
                    <a href="{{ route('about.vision') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.eye variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Vision & Mission
                    </a>
                    <a href="{{ route('personal.auto.loans') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.hand-coins class="w-4 h-4 mr-3 text-primary-400" />
                        Loans & Credit
                    </a>
                    <a href="{{ route('about.career') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.briefcase variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Career
                    </a>

                    <a href="{{ route('about.faqs') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.question-mark-circle variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Faqs
                    </a>

                </div>
            </div>

            <!-- Services Submenu -->
            <div x-data="{ servicesOpen: false }" class="space-y-2">
                <button @click="servicesOpen = !servicesOpen"
                    class="flex items-center w-full px-4 py-3 text-gray-700 dark:text-gray-300 
           hover:text-primary-600 dark:hover:text-primary-400 font-medium 
           transition-all duration-300 rounded-2xl 
           hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 
           dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 
           hover:shadow-lg hover:translate-x-2 group">
                    <x-flux::icon.cog variant="solid"
                        class="mr-4 w-4 h-4 text-primary-500 
               group-hover:scale-110 transition-transform duration-300" />

                    <span>Services</span>

                    <x-flux::icon.chevron-right class="ml-auto w-4 h-4 transition-transform duration-300"
                        ::class="{ 'rotate-180': servicesOpen }" />
                </button>

                <div x-show="servicesOpen" x-cloak x-collapse class="ml-8 space-y-1">
                    <a href="{{ route('personal.overview') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.user variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Personal Banking
                    </a>
                    <a href="{{ route('business.overview') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.briefcase variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Business Banking
                    </a>
                    <a href="{{ route('nonprofit.overview') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.handshake class="w-4 h-4 mr-3 text-primary-400" />
                        Non-profit Banking
                    </a>
                    <a href="{{ route('personal.credit-cards') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.credit-card variant="solid" class="w-4 h-4 mr-3 text-primary-400" />
                        Cards
                    </a>
                    <a href="{{ route('frontend.grant') }}"
                        class="flex items-center px-4 py-2 text-gray-600 dark:text-gray-400 hover:text-primary-600 dark:hover:text-primary-400 text-sm transition-all duration-300 rounded-xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30">
                        <x-flux::icon.hand-coins class="w-4 h-4 mr-3 text-primary-400" />
                        Grants & Aid
                    </a>
                </div>
            </div>

            <a href="{{ route('about.contact') }}"
                class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 font-medium transition-all duration-300 rounded-2xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 hover:shadow-lg hover:translate-x-2 group">
                <x-flux::icon.envelope variant="solid"
                    class="w-4 h-4 mr-4 text-primary-500 group-hover:scale-110 transition-transform duration-300" />
                <span>Contact</span>
                <x-flux::icon.chevron-right variant="solid"
                    class="w-4 h-4 ml-auto text-xs opacity-0 group-hover:opacity-100 transition-all duration-300" />
            </a>
            <!-- Additional Mobile Links -->
            <a href="#"
                class="flex items-center px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 font-medium transition-all duration-300 rounded-2xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 hover:shadow-lg hover:translate-x-2 group">
                <x-flux::icon.device-phone-mobile variant="solid"
                    class="w-4 h-4 mr-4 text-primary-500 group-hover:scale-110 transition-transform duration-300" />
                <span>Mobile App</span>
                <x-flux::icon.chevron-right variant="solid"
                    class="w-4 h-4 ml-auto text-xs opacity-0 group-hover:opacity-100 transition-all duration-300" />
            </a>

            <!-- Enhanced Dark Mode Toggle for Mobile -->
            <div class="pt-4 mt-4 border-t border-primary-700/50">
                <button @click="darkMode = !darkMode; localStorage.setItem('darkMode', darkMode)"
                    class="flex items-center w-full px-4 py-3 text-gray-700 dark:text-gray-300 hover:text-primary-600 dark:hover:text-primary-400 font-medium transition-all duration-300 rounded-2xl hover:bg-linear-to-r hover:from-primary-50 hover:to-primary-100 dark:hover:from-primary-900/30 dark:hover:to-primary-800/30 hover:shadow-lg hover:translate-x-2 group">
                    <div
                        class="flex items-center justify-center w-8 h-8 mr-4 rounded-xl bg-linear-to-br from-yellow-400 to-orange-500 dark:from-blue-500 dark:to-purple-600 group-hover:scale-110 transition-transform duration-300">
                        <x-flux::icon.sun variant="solid"
                            class="w-4 h-4 text-white group-hover:rotate-180 transition-transform duration-500"
                            x-show="darkMode" />

                        <x-flux::icon.moon variant="solid"
                            class="w-4 h-4 text-white group-hover:rotate-12 transition-transform duration-300"
                            x-show="!darkMode" />
                    </div>
                    <span x-text="darkMode ? 'Switch to Light Mode' : 'Switch to Dark Mode'"></span>
                    <x-flux::icon.chevron-right variant="solid"
                        class="w-4 h-4 ml-auto opacity-0 group-hover:opacity-100 transition-all duration-300" />
                </button>
            </div>
        </div>
    </div>
</header>
