{{-- Compact Crypto Balance Cards --}}
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">

    @foreach ($this->cryptoBalances as $crypto)
        @php
            $isSelected = (string) $selectedCrypto === (string) $crypto->id;
        @endphp

        <div wire:key="crypto-card-{{ $crypto->id }}" wire:click="$set('selectedCrypto', '{{ $crypto->id }}')"
            class="relative cursor-pointer rounded-xl p-4 transition-all duration-200
                    flex justify-between items-center
                    {{ $isSelected
                        ? 'bg-sky-600 text-white shadow-lg scale-[1.03]'
                        : 'bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-100 hover:shadow-md hover:scale-[1.01]' }}">

            {{-- Left Section --}}
            <div class="flex items-center gap-3">
                <div
                    class="w-10 h-10 rounded-full flex items-center justify-center
                            bg-sky-100 text-sky-600 dark:bg-sky-900 dark:text-sky-300 text-lg">
                    🪙
                </div>

                <div>
                    <div class="text-sm font-semibold truncate">
                        {{ $crypto->label() }}
                    </div>
                    <div class="text-xs text-gray-400 dark:text-gray-300 uppercase tracking-wide">
                        Crypto Balance
                    </div>
                </div>
            </div>

            {{-- Right Section --}}
            <div class="text-right flex flex-col items-end gap-1">
                {{-- Available Balance --}}
                <div class="text-lg font-bold">
                    {{ $crypto->dashboard_balances['available'] }}
                </div>

                {{-- Status / Network --}}
                <div
                    class="text-xs px-2 py-0.5 rounded-full
                            {{ $isSelected ? 'bg-white text-sky-600 dark:bg-gray-800 dark:text-sky-400' : 'bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300' }}">
                    {{ strtoupper($crypto->network) }}
                </div>

                {{-- Rate --}}
                <div class="text-xs font-semibold text-gray-800 dark:text-gray-200">
                    ${{ number_format($crypto->getRate(), 2) }}
                </div>
            </div>

            {{-- Selected Check --}}
            @if ($isSelected)
                <div
                    class="absolute -top-2 -right-2 w-6 h-6 rounded-full
                            bg-white text-sky-600 dark:bg-gray-800 dark:text-sky-400
                            flex items-center justify-center text-xs font-bold shadow-md">
                    ✓
                </div>
            @endif

        </div>
    @endforeach

</div>
