<!-- User / Footer -->
<div class="border-t border-gray-200 dark:border-zinc-700 p-4 space-y-3">
    <a href="{{ route('user.settings.index') }}"
        class="flex items-center gap-3 px-3 py-2 rounded-lg
                hover:bg-gray-100 dark:hover:bg-zinc-800 transition">
        <div x-data="{ avatarUrl: '{{ $avatarUrl }}' }" x-on:profile-updated.window="avatarUrl = $event.detail.photoUrl ?? avatarUrl"
            class="h-9 w-9 rounded-full overflow-hidden cursor-pointer">
            <template x-if="avatarUrl">
                <img :src="avatarUrl" class="h-full w-full object-cover">
            </template>
            <template x-if="!avatarUrl">
                <span
                    class="flex items-center justify-center h-full w-full bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-200 font-semibold">
                    {{ $authUser->initials() }}
                </span>
            </template>

        </div>

        <div class="leading-tight">
            <p class="font-semibold text-gray-900 dark:text-white">{{ $authUser->name }}</p>
            <p class="text-xs text-gray-500">View profile</p>
        </div>
    </a>

    <form method="POST" action="{{ route('user.logout') }}">
        @csrf
        <button type="submit"
            class="w-full flex items-center gap-3 px-3 py-2 rounded-lg
                    text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/30 transition">
            <flux:icon name="arrow-left-start-on-rectangle" class="h-5 w-5" />
            <span class="text-sm font-semibold">Log out</span>
        </button>
    </form>
</div>
