<x-slot:title>
    {{ config('app.name') }} || Internal Transfer
</x-slot:title>

<div class="py-3 space-y-5">

    @if ($paymentMethods->isEmpty())
        {{-- ================= Empty State ================= --}}
        <x-deposit.empty-state title="Local Transfer" />
    @else
        {{-- Payment Methods Section --}}
        <div class="space-y-4">

            {{-- Selected Method Card --}}
            @if ($selectedMethod)
                @php
                    $current = $paymentMethods->firstWhere('id', $selectedMethod);
                @endphp

                <div class="flex items-center justify-between">
                    {{-- Header --}}

                    <x-payment-method-card :method="$current" :selected="true" />

                    {{-- Back Button --}}
                    <div class=" justify-end items-end hidden md:flex">
                        <a href="{{ route('user.dashboard') }}"
                            class="inline-flex items-center gap-2 text-sky-600 dark:text-sky-400 hover:text-sky-800 dark:hover:text-sky-300 font-semibold transition">
                            <x-flux::icon.arrow-left class="w-5 h-5" />
                            Back to Dashboard
                        </a>
                    </div>
                </div>

                <div x-data x-cloak x-show="$wire.selectedMethod !== null"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 translate-y-4 scale-95"
                    x-transition:enter-end="opacity-100 translate-y-0 scale-100"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0 scale-100"
                    x-transition:leave-end="opacity-0 translate-y-4 scale-95"
                    class="relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 shadow-lg">

                    {{-- Body --}}
                    <div>

                        {{-- ================= Instructions ================= --}}
                        <x-instruction-list :instructions="$instructions" title="International Transfer Instructions"
                            icon="send" />

                        {{-- Local transfer --}}
                        <livewire:pages::user.transfer.beneficiaries-card wire:key="beneficiaries-card-local"
                            :transferType="\App\Models\Beneficiary::LOCAL" />

                        <div class="p-5 space-y-3">
                            {{-- ================= Details ================= --}}
                            <x-details-grid :details="$details" />
                            {{-- Amount + Fee --}}
                            <form wire:submit.prevent="validateAndShowConfirmation" class="space-y-4">
                                {{-- Account Limits --}}
                                @if ($selectedAccount)
                                    <div wire:key="account-limits-{{ $selectedAccount }}" class="mb-4">
                                        <x-account.limits :account="$accounts->firstWhere('id', $selectedAccount)" />
                                    </div>
                                @endif

                                <div>
                                    <x-select wire:model.live.blur="selectedAccount" label="Select Account"
                                        placeholder="Select Account">
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">
                                                {{ $account->bank_account_type }} -
                                                {{ $account->masked_account_number }}
                                                -
                                                {{ $currencySymbol }}{{ number_format($account->available_balance, 2) }}
                                            </option>
                                        @endforeach
                                    </x-select>
                                </div>
                                {{-- Amount --}}
                                <div x-data="{ selected: null }" class="space-y-2 min-h-20">
                                    <x-flux::input wire:model.live.debounce.500ms="amount"
                                        x-on:input="selected = $event.target.value" :label="__('Amount')" type="number"
                                        placeholder="{{ $currencySymbol }}10" />

                                    {{-- Preset buttons container with fixed height --}}
                                    <div class="mt-2 flex flex-wrap gap-2">
                                        <template x-for="amt in [100,500,1000,5000]" :key="amt">
                                            <button type="button" @click="selected = amt; $wire.set('amount', amt)"
                                                :class="selected == amt ?
                                                    'bg-sky-600 text-white' :
                                                    'bg-sky-100 text-sky-800'"
                                                class="px-3 py-1 rounded text-xs font-semibold">
                                                {{ $currencySymbol }}<span x-text="amt"></span>
                                            </button>
                                        </template>
                                    </div>
                                </div>

                                {{-- ================= Dynamic Fields ================= --}}
                                @if (!empty($fields))
                                    <div class="grid grid-cols-1 sm:grid-cols-2 capitalize gap-4">
                                        @foreach ($fields as $field)
                                            @php
                                                $fieldName = $field['name'];
                                                $fieldType = $field['type'];
                                                $fieldLabel =
                                                    $field['label'] ?? ucfirst(str_replace('_', ' ', $fieldName));
                                                $colClass = in_array($fieldType, ['textarea', 'file'])
                                                    ? 'col-span-2'
                                                    : 'col-span-1';
                                                $placeholder =
                                                    $field['placeholder'] ?? 'Enter ' . strtolower($fieldLabel);
                                                $isAccountNumberField = $fieldName === 'account_number';
                                                $isRequired = $field['required'] ?? false; // Required flag
                                            @endphp

                                            <div class="{{ $colClass }}">
                                                {{-- Label --}}
                                                <label
                                                    class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                                    {{ $fieldLabel }}
                                                    @unless ($isRequired)
                                                        <span
                                                            class="ml-1 text-[10px] font-medium text-gray-400 dark:text-gray-500">
                                                            Optional
                                                        </span>
                                                    @endunless
                                                </label>

                                                {{-- Field Input --}}
                                                @if ($isAccountNumberField)
                                                    <x-input wire:model.live.debounce.600ms="fieldValues.account_number"
                                                        type="text" inputmode="numeric" pattern="[0-9]*"
                                                        placeholder="{{ $placeholder }}" :required="$isRequired" />

                                                    <div class="mt-1 text-sm">

                                                        {{-- Loading --}}
                                                        @if (!empty($fieldValues['account_number']) && strlen($fieldValues['account_number']) >= 8)
                                                            <span wire:loading wire:target="fieldValues.account_number"
                                                                class="text-gray-500">
                                                                Checking account…
                                                            </span>
                                                        @endif

                                                        {{-- Success --}}
                                                        @if (!empty($fieldValues['account_number']) && strlen($fieldValues['account_number']) >= 8 && $accountName)
                                                            <span wire:loading.remove
                                                                wire:target="fieldValues.account_number"
                                                                class="text-green-500 font-medium">
                                                                Account Holder: <strong>{{ $accountName }}</strong>
                                                            </span>
                                                        @endif

                                                    </div>
                                                @elseif ($fieldType === 'textarea')
                                                    <x-flux::textarea
                                                        wire:model.defer="fieldValues.{{ $fieldName }}"
                                                        placeholder="{{ $placeholder }}" :required="$isRequired" />
                                                @elseif ($fieldType === 'select')
                                                    <x-flux::select wire:model.defer="fieldValues.{{ $fieldName }}"
                                                        :required="$isRequired">
                                                        <option value="" disabled>Select {{ $fieldLabel }}
                                                        </option>
                                                        @foreach ($field['options'] ?? [] as $option)
                                                            <option value="{{ $option['value'] }}">
                                                                {{ $option['label'] }}</option>
                                                        @endforeach
                                                    </x-flux::select>
                                                @elseif ($fieldType === 'file')
                                                    <x-ui.custom-file-upload
                                                        wire:model.defer="dynamicUploads.{{ $fieldName }}"
                                                        accepted-file-types="image/*" placeholder="{{ $placeholder }}"
                                                        :required="$isRequired" />
                                                @else
                                                    <x-flux::input wire:model.defer="fieldValues.{{ $fieldName }}"
                                                        type="{{ $fieldType }}" placeholder="{{ $placeholder }}"
                                                        :required="$isRequired" />
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @endif

                                @if ($pinMissing)
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-400 flex items-center gap-1">
                                        <x-flux::icon name="exclamation-circle" class="h-4 w-4" />
                                        Transaction PIN not set.
                                    </p>
                                    <x-flux::button variant="primary" color="sky"
                                        @click="$dispatch('open-pin-modal')">Set
                                        PIN</x-flux::button>
                                @endif

                                @include('partials.errors')

                                {{-- Fee & Total --}}
                                <x-deposit.fee-total :charge="$fee" :total="$total" :currencySymbol="$currencySymbol"
                                    :amountEntered="strlen($amount ?? '') > 0" />
                                <div>
                                    <x-button type="submit" class="disabled:cursor-not-allowed bg-gray-400"
                                        wire:loading.attr="disabled" :disabled="$pinMissing || !$accountName">
                                        Review & Continue
                                    </x-button>
                                    <p class="text-xs text-red-400 capitalize">enter account number to review</p>
                                </div>
                            </form>

                            <x-confirmation-modal :accounts="$accounts" :paymentMethods="$paymentMethods" :prevalidatedData="$prevalidatedData"
                                :currencySymbol="$currencySymbol" />

                            <x-pin-modal />
                        </div>

                    </div>
                </div>
            @endif
            {{-- Example usage in any Blade file --}}
            @include('partials.transfer-methods', [
                'paymentMethods' => $paymentMethods,
                'title' => 'Select a Transfer Method',
            ])

        </div>
    @endif

</div>
