<!-- ================== BLADE ================== -->
<x-slot:title>Finished Onboarding</x-slot:title>

<div class="space-y-5">
    <div class="md:hidden">
        <x-auth-header :title="__('Welcome Onboard')" :description="__('Enter your details below to create your account')" />
    </div>

    <div class="mb-10">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-2xl font-semibold">Step {{ $step }} of 4</h2>
            <span class="text-sm font-medium text-sky-200 dark:text-sky-100">
                {{ ['Personal Info', 'Contact & Address', 'Account & Security', 'Confirm Info'][$step - 1] ?? '' }}
            </span>
        </div>

        <div class="flex h-3 bg-gray-100 rounded-full overflow-hidden">
            @for ($i = 1; $i <= 4; $i++)
                <div
                    class="flex-1
                    @if ($i < $step) bg-green-500
                    @elseif ($i === $step) bg-sky-500
                    @else bg-gray-200 @endif">
                </div>
                @if ($i < 4)
                    <div class="w-[2px] bg-white">
                    </div>
                @endif
            @endfor
        </div>
    </div>

    <form wire:submit.prevent class="space-y-6 p-1 overflow-hidden">
        @include('partials.errors')

        <div wire:transition>
            @switch($step)
                @case(1)
                    <div wire:key="step-1">
                        @include('partials.onboarding.step1')
                    </div>
                @break

                @case(2)
                    <div wire:key="step-2">
                        @include('partials.onboarding.step2')
                    </div>
                @break

                @case(3)
                    <div wire:key="step-3">
                        @include('partials.onboarding.step3')
                    </div>
                @break

                @case(4)
                    <div wire:key="step-4">
                        @include('partials.onboarding.step4')
                    </div>
                @break
            @endswitch
        </div>

        <!-- Navigation Buttons -->
        <div class="flex justify-between mt-4 gap-4">
            @if ($step > 1)
                <x-button wire:click="previousStep" variant="subtle" type="button">
                    Previous
                </x-button>
            @endif

            <x-button type="button" variant="primary" class="w-full"
                wire:click="{{ $step === 4 ? 'submit' : 'nextStep' }}">
                {{ $step === 4 ? 'Finish' : 'Next' }}
            </x-button>

        </div>

        <x-button wire:click="saveProgress" variant="secondary" type="button">Save
            & Continue Later </x-button>
</div>
</form>
</div>
