<div class="space-y-5">
    <x-slot:title>Account Login</x-slot:title>

    {{-- Header --}}
    <x-auth-header :title="__('Access Your Dashboard')" :description="$otpEnabled
        ? __('Enter your email & password below or receive a one-time password (OTP)')
        : __('Enter your email & password below')" />

    <form wire:submit.prevent="submit" class="flex flex-col gap-6">

        {{-- Email Address --}}
        <div>
            <x-input wire:model="email" label="Email Address" placeholder="example@email.com" />
        </div>

        {{-- Password Field --}}
        <div class="relative">
            <x-input wire:model="password" label="Password" type="password" autocomplete="current-password"
                placeholder="password" viewable />

            @if (Route::has('password.request'))
                <flux:link class="absolute top-0 text-sm end-0 text-gray-900 dark:text-gray-50"
                    :href="route('password.request')">
                    {{ __('Forgot your password?') }}
                </flux:link>
            @endif
        </div>

        {{-- Remember me --}}
        <div class="flex items-center justify-start">
            <flux:checkbox wire:model="remember" :label="__('Remember me')" :checked="old('remember')" />
        </div>

        {{-- Submit Button --}}
        <div class="flex items-center justify-end">
            <flux:button variant="primary" type="submit" class="w-full" color="sky" data-test="login-button">
                {{ __('Login') }}
            </flux:button>
        </div>
    </form>
</div>
