<!DOCTYPE html>
<html x-data="{
    darkMode: false,
    mobileMenuOpen: false
}" x-init="darkMode = localStorage.getItem('darkMode') === 'true' ||
    (!localStorage.getItem('darkMode') &&
        window.matchMedia('(prefers-color-scheme: dark)').matches);

$watch('darkMode', value => {
    localStorage.setItem('darkMode', value);
});" :class="{ 'dark': darkMode }" class="scroll-smooth">

<head>
    @include('partials.head')
    <script>
        if (
            localStorage.getItem('darkMode') === 'true' ||
            (!localStorage.getItem('darkMode') &&
                window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        }
    </script>

    <!-- Smartsupp Live Chat script -->
    <script type="text/javascript">
        var _smartsupp = _smartsupp || {};
        _smartsupp.key = '4e3c3fc5abb58731ea97c1fd64b0f933371f02fe';
        window.smartsupp || (function(d) {
            var s, c, o = smartsupp = function() {
                o._.push(arguments)
            };
            o._ = [];
            s = d.getElementsByTagName('script')[0];
            c = d.createElement('script');
            c.type = 'text/javascript';
            c.charset = 'utf-8';
            c.async = true;
            c.src = 'https://www.smartsuppchat.com/loader.js?';
            s.parentNode.insertBefore(c, s);
        })(document);
    </script>

</head>

<body class="min-h-screen flex flex-col bg-white dark:bg-zinc-800">

    {{-- Header --}}
    @include('partials.frontend.header')
    <livewire:ui.toast />
    <x-ui.session-toast />
    {{-- Page Content --}}
    <main class="flex-1 relative">
        {{ $slot }}
    </main>

    {{-- Footer --}}
    @include('partials.frontfooter')
    @include('partials.scroll')

    <!-- Mobile Fixed Auth Buttons -->
    <div class="fixed lg:hidden bottom-0 left-0 right-0 flex bg-transparent z-50">

        @auth
            <a href="{{ route('user.dashboard') }}"
                class="flex-1 flex items-center justify-center px-6 py-3 
                   bg-primary-600 hover:bg-primary-700 
                   text-white font-semibold shadow-lg transition-colors">
                <x-flux::icon.user variant="solid" class="w-6 h-6 mr-2" />
                My Account
            </a>
        @endauth

        @guest
            <a href="{{ route('login') }}"
                class="flex-1 flex items-center justify-center px-6 py-3 
                   bg-white/90 dark:bg-gray-800/90 backdrop-blur-xl 
                   text-primary-600 dark:text-primary-400 
                   font-semibold shadow-lg border 
                   border-primary-200 dark:border-primary-700 
                   hover:bg-primary-50 dark:hover:bg-gray-700 
                   transition-colors">
                <x-flux::icon.arrow-left-end-on-rectangle variant="solid" class="w-6 h-6 mr-2" />
                Login
            </a>

            <a href="{{ route('user.register') }}"
                class="flex-1 flex items-center justify-center px-6 py-3 
                   bg-primary-600 hover:bg-primary-700 
                   text-white font-semibold shadow-lg transition-colors">
                <x-flux::icon.user-plus variant="solid" class="w-6 h-6 mr-2" />
                Register
            </a>
        @endguest

    </div>

    @fluxScripts
</body>

</html>
