<!DOCTYPE html>
<html x-data="{
    darkMode: false,
    mobileMenuOpen: false
}" x-init="darkMode = localStorage.getItem('darkMode') === 'true' ||
    (!localStorage.getItem('darkMode') &&
        window.matchMedia('(prefers-color-scheme: dark)').matches);

$watch('darkMode', value => {
    localStorage.setItem('darkMode', value);
});" :class="{ 'dark': darkMode }" class="scroll-smooth">

<head>
    @include('partials.head')
    <script>
        if (
            localStorage.getItem('darkMode') === 'true' ||
            (!localStorage.getItem('darkMode') &&
                window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        }
    </script>
    <meta name="robots" content="index, follow">
</head>

<body class="min-h-screen bg-white dark:bg-zinc-800" x-data="{ opensidebar: false }" :class="{ 'overflow-hidden': opensidebar }">

    @php
        $avatarUrl =
            $authUser->profile->profile_photo && Storage::disk('public')->exists($authUser->profile->profile_photo)
                ? Storage::disk('public')->url($authUser->profile->profile_photo)
                : null;
    @endphp
    <!-- MOBILE SIDEBAR -->
    <aside x-show="opensidebar" x-cloak x-transition:enter="transition-transform duration-300"
        x-transition:enter-start="-translate-x-full" x-transition:enter-end="translate-x-0"
        x-transition:leave="transition-transform duration-300" x-transition:leave-start="translate-x-0"
        x-transition:leave-end="-translate-x-full"
        class="fixed inset-y-0 left-0 z-30 w-64 bg-white dark:bg-zinc-900 border-r border-gray-200 dark:border-zinc-700 flex flex-col lg:hidden">
        <!-- Brand -->
        <div class="px-6 py-6 border-b border-gray-200 dark:border-zinc-700">
            <div class="flex items-center gap-3 group">
                <div
                    class="h-10 w-10 rounded-xl bg-[#0E4D92] text-white flex items-center justify-center
                group-hover:scale-105 transition">
                    <x-app-logo-icon class="h-5 w-5 fill-current" />
                </div>
                <span class="text-lg font-bold tracking-wide text-gray-900 dark:text-white">
                    {{ config('app.name') }}
                </span>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 py-2 px-1 space-y-4 text-sm overflow-y-auto">
            @include('partials.admin.sidebar-links')
        </nav>

        <!-- User / Footer -->
        @include('partials.admin.sidebar-footer')
    </aside>

    <!-- DESKTOP SIDEBAR -->
    <aside
        class="hidden lg:flex lg:flex-col lg:fixed lg:inset-y-0 lg:left-0 lg:w-64 bg-white dark:bg-zinc-900 border-r border-gray-200 dark:border-zinc-700 z-20">
        <!-- Brand -->
        <div class="px-6 py-6 border-b border-gray-200 dark:border-zinc-700">
            <div class="flex flex-col items-center gap-3 group">
                <div
                    class="h-10 w-10 rounded-xl bg-[#0E4D92] text-white flex items-center justify-center
                group-hover:scale-105 transition">
                    <x-app-logo-icon class="h-5 w-5 fill-current" />
                </div>
                <span class="text-lg font-bold tracking-wide text-gray-900 dark:text-white">
                    {{ config('app.name') }}
                </span>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 py-2 px-1 space-y-4 text-sm overflow-y-auto">
            @include('partials.admin.sidebar-links')
        </nav>

        <!-- User / Footer -->
        @include('partials.admin.sidebar-footer')
    </aside>
    {{ $slot }}

    @fluxScripts
</body>

</html>
