<!DOCTYPE html>
<html x-data="{
    darkMode: false,
    mobileMenuOpen: false
}" x-init="darkMode = localStorage.getItem('darkMode') === 'true' ||
    (!localStorage.getItem('darkMode') &&
        window.matchMedia('(prefers-color-scheme: dark)').matches);

$watch('darkMode', value => {
    localStorage.setItem('darkMode', value);
});" :class="{ 'dark': darkMode }" class="scroll-smooth">

<head>
    @include('partials.head')

    {{-- External libraries MUST stay inside head --}}
    <script src="https://cdn.jsdelivr.net/npm/echarts@5/dist/echarts.min.js"></script>
    <script>
        if (
            localStorage.getItem('darkMode') === 'true' ||
            (!localStorage.getItem('darkMode') &&
                window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        }
    </script>
    <link rel="stylesheet" href="https://unpkg.com/trix@2.0.8/dist/trix.css" />
    <script src="https://unpkg.com/trix@2.0.8/dist/trix.umd.min.js"></script>

    <meta name="robots" content="noindex, nofollow">
</head>

<body class="min-h-screen bg-white dark:bg-zinc-800" x-data="{ opensidebar: false }" :class="{ 'overflow-hidden': opensidebar }">


    <!-- MOBILE SIDEBAR -->
    <aside x-show="opensidebar" x-cloak x-transition:enter="transition-transform duration-300"
        x-transition:enter-start="-translate-x-full" x-transition:enter-end="translate-x-0"
        x-transition:leave="transition-transform duration-300" x-transition:leave-start="translate-x-0"
        x-transition:leave-end="-translate-x-full"
        class="fixed inset-y-0 left-0 z-30 w-64 bg-white dark:bg-zinc-900 border-r border-gray-200 dark:border-zinc-700 flex flex-col lg:hidden">
        <!-- Brand -->
        <div class="px-6 py-6 border-b border-gray-200 dark:border-zinc-700">
            <div class="flex items-center gap-3 group">
                <div
                    class="h-10 w-10 rounded-xl bg-[#0E4D92] text-white flex items-center justify-center
                group-hover:scale-105 transition">
                    <x-app-logo-icon class="h-5 w-5 fill-current" />
                </div>
                <span class="text-lg font-bold tracking-wide text-gray-900 dark:text-white">
                    {{ config('app.name') }}
                </span>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 py-2 px-1 space-y-4 text-sm overflow-y-auto">
            <!-- Main Section -->
            <div class="space-y-1">
                <p class="px-2 text-xs font-semibold capitalize text-gray-400">Main</p>
                <x-sidebar.link icon="home" label="Dashboard" route="admin.dashboard" />
                <x-sidebar.link icon="user-group" label="Manage Users" route="admin.users.index"
                    activeRoute="admin.users*" />
            </div>

            <!-- SERVICES Section -->
            <div class="space-y-1">
                <p class="px-2 text-xs font-semibold capitalize text-gray-400">Finance</p>
                <x-sidebar.link icon="currency-dollar" label="Manage Deposit's" route="admin.deposit.index"
                    activeRoute="admin.deposit*" />
                <x-sidebar.link icon="strikethrough" label="Manage Withdrawal's" route="admin.withdrawal.index"
                    activeRoute="admin.withdrawal*" />
                <x-sidebar.link icon="send" :iconSolid="false" label="Manage Transfer" route="admin.transfer.index"
                    activeRoute="admin.transfer*" />
                <x-sidebar.link icon="hand-coins" :iconSolid="false" label="Manage Loans" route="admin.loans.index"
                    activeRoute="admin.loans*" />
                <x-sidebar.link icon="chart-pie" label="Manage Grants" route="admin.grants.manage" />
                <x-sidebar.link icon="circle-stack" label="Manage Tax Refunds" route="admin.refund.manage" />
            </div>

            <div class="space-y-1">
                <p class="px-2 text-xs font-semibold capitalize text-gray-400">Settings</p>

                <x-sidebar.dropdown icon="banknotes" label="Payment Method" :routes="[
                    'admin.methods-deposit',
                    'admin.methods-withdrawal',
                    'admin.methods-local_transfer',
                    'admin.methods-internal_transfer',
                    'admin.crypto.index',
                ]">
                    <x-sidebar.link label="Deposit Settings" route="admin.methods-deposit" :params="['type' => 'deposit']"
                        @click="opensidebar = false" />
                    <x-sidebar.link label="Withdrawal Settings" route="admin.methods-withdrawal" :params="['type' => 'withdrawal']"
                        @click="opensidebar = false" />
                    <x-sidebar.link label="Local Transfer Settings" route="admin.methods-local_transfer"
                        :params="['type' => 'local_transfer']" @click="opensidebar = false" />
                    <x-sidebar.link label="Other Bank Transfer Settings" route="admin.methods-international_transfer"
                        :params="['type' => 'international_transfer']" @click="opensidebar = false" />
                    <x-sidebar.link label="Crypto Management" route="admin.crypto.index" @click="opensidebar = false" />
                </x-sidebar.dropdown>

                <x-sidebar.link icon="question-mark-circle" label="Manage Tickets" route="admin.ticket.index" />
                <x-sidebar.link icon="cog-8-tooth" label="Settings" route="admin.setting" />
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button type="submit"
                        class="w-full flex items-center gap-3 px-3 py-2 rounded-lg
                       text-red-600 dark:text-red-400
                       hover:bg-red-50 dark:hover:bg-red-900/30 transition">
                        <flux:icon name="arrow-left-start-on-rectangle" class="h-5 w-5" />
                        <span class="text-sm font-semibold">Log out</span>
                    </button>
                </form>
            </div>

        </nav>

    </aside>

    <!-- DESKTOP SIDEBAR -->
    <aside
        class="hidden lg:flex lg:flex-col lg:fixed lg:inset-y-0 lg:left-0 lg:w-64 bg-white dark:bg-zinc-900 border-r border-gray-200 dark:border-zinc-700 z-20">
        <!-- Brand -->
        <div class="px-6 py-6 border-b border-gray-200 dark:border-zinc-700">
            <div class="flex flex-col items-center gap-3 group">
                <div
                    class="h-10 w-10 rounded-xl bg-[#0E4D92] text-white flex items-center justify-center
                group-hover:scale-105 transition">
                    <x-app-logo-icon class="h-5 w-5 fill-current" />
                </div>
                <span class="text-lg font-bold tracking-wide text-gray-900 dark:text-white">
                    {{ config('app.name') }}
                </span>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 py-2 px-1 space-y-4 text-sm overflow-y-auto">
            <!-- Main Section -->
            <div class="space-y-1">
                <p class="px-2 text-xs font-semibold capitalize text-gray-400">Main</p>
                <x-sidebar.link icon="home" label="Dashboard" route="admin.dashboard" />
                <x-sidebar.link icon="user-group" label="Manage Users" route="admin.users.index"
                    activeRoute="admin.users*" />
            </div>

            <!-- SERVICES Section -->
            <div class="space-y-1">
                <p class="px-2 text-xs font-semibold capitalize text-gray-400">Finance</p>
                <x-sidebar.link icon="currency-dollar" label="Manage Deposit's" route="admin.deposit.index"
                    activeRoute="admin.deposit*" />
                <x-sidebar.link icon="strikethrough" label="Manage Withdrawal's" route="admin.withdrawal.index"
                    activeRoute="admin.withdrawal*" />
                <x-sidebar.link icon="send" :iconSolid="false" label="Manage Transfer" route="admin.transfer.index"
                    activeRoute="admin.transfer*" />
                <x-sidebar.link icon="hand-coins" :iconSolid="false" label="Manage Loans" route="admin.loans.index"
                    activeRoute="admin.loans*" />
                <x-sidebar.link icon="chart-pie" label="Manage Grants" route="admin.grants.manage" />
                <x-sidebar.link icon="circle-stack" label="Manage Tax Refunds" route="admin.refund.manage" />
            </div>

            <div class="space-y-1">
                <p class="px-2 text-xs font-semibold capitalize text-gray-400">Settings</p>

                <x-sidebar.dropdown icon="banknotes" label="Payment Method" :routes="[
                    'admin.methods-deposit',
                    'admin.methods-withdrawal',
                    'admin.methods-local_transfer',
                    'admin.methods-internal_transfer',
                    'admin.crypto.index',
                ]">
                    <x-sidebar.link label="Deposit Settings" route="admin.methods-deposit" :params="['type' => 'deposit']"
                        @click="opensidebar = false" />
                    <x-sidebar.link label="Withdrawal Settings" route="admin.methods-withdrawal" :params="['type' => 'withdrawal']"
                        @click="opensidebar = false" />
                    <x-sidebar.link label="Local Transfer Settings" route="admin.methods-local_transfer"
                        :params="['type' => 'local_transfer']" @click="opensidebar = false" />
                    <x-sidebar.link label="Other Bank Transfer Settings" route="admin.methods-international_transfer"
                        :params="['type' => 'international_transfer']" @click="opensidebar = false" />
                    <x-sidebar.link label="Crypto Management" route="admin.crypto.index"
                        @click="opensidebar = false" />
                </x-sidebar.dropdown>

                <x-sidebar.link icon="question-mark-circle" label="Manage Tickets" route="admin.ticket.index" />
                <x-sidebar.link icon="cog-8-tooth" label="Settings" route="admin.setting" />
                <form method="POST" action="{{ route('admin.logout') }}">
                    @csrf
                    <button type="submit"
                        class="w-full flex items-center gap-3 px-3 py-2 rounded-lg
                       text-red-600 dark:text-red-400
                       hover:bg-red-50 dark:hover:bg-red-900/30 transition">
                        <flux:icon name="arrow-left-start-on-rectangle" class="h-5 w-5" />
                        <span class="text-sm font-semibold">Log out</span>
                    </button>
                </form>
            </div>

        </nav>

    </aside>
    {{ $slot }}
    @fluxScripts
</body>

</html>
