<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Transaction Receipt #{{ $transaction->id }}</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            margin: auto;
            border: 1px solid #ccc;
            padding: 20px;
            position: relative;
        }

        /* Subtle watermark */
        .watermark {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-30deg);
            font-size: 120px;
            font-weight: bold;
            color: rgba(0, 0, 0, 0.05);
            pointer-events: none;
            z-index: 0;
        }

        h1 {
            font-size: 20px;
            text-align: center;
            margin-bottom: 5px;
        }

        .status {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 12px;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 11px;
            margin-bottom: 20px;
            color: #fff;
        }

        .status.completed {
            background-color: #16a34a;
        }

        .status.pending {
            background-color: #facc15;
            color: #000;
        }

        .status.rejected {
            background-color: #dc2626;
        }

        .amount {
            text-align: center;
            font-size: 28px;
            font-weight: bold;
            margin: 15px 0;
        }

        .amount.positive {
            color: #16a34a;
        }

        .amount.negative {
            color: #dc2626;
        }

        .section {
            margin-top: 20px;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }

        .section-title {
            font-weight: bold;
            margin-bottom: 10px;
            font-size: 13px;
            color: #555;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td {
            padding: 5px 0;
            vertical-align: top;
        }

        td.label {
            width: 40%;
            font-weight: bold;
            color: #555;
        }

        .footer {
            font-size: 9px;
            color: #888;
            text-align: center;
            margin-top: 30px;
        }

        .transaction-meta {
            font-size: 10px;
            color: #999;
            text-align: right;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="watermark">{{ config('app.name') }}</div>

        <h1>Transaction Receipt</h1>
        <div class="transaction-meta">Transaction ID: {{ $transaction->id }}<br>{{ $transaction->created_at }}</div>

        <div style="text-align:center;">
            <span class="status {{ $transaction->status ?? 'pending' }}">
                {{ $transaction->statusLabel() ?? $transaction->status }}
            </span>
        </div>

        @foreach ($fields as $field)
            @if ($field['label'] === 'Amount')
                <div
                    class="amount {{ str_contains($field['value'], '+') ? 'positive' : '' }} {{ str_contains($field['value'], '-') ? 'negative' : '' }}">
                    {{ $field['value'] }}
                </div>
            @endif
        @endforeach

        <div class="section">
            <div class="section-title">Transaction Details</div>
            <table>
                @foreach ($fields as $field)
                    @if ($field['label'] !== 'Amount')
                        <tr>
                            <td class="label">{{ $field['label'] }}</td>
                            <td>{{ $field['value'] }}</td>
                        </tr>
                    @endif
                @endforeach
            </table>
        </div>

        @if (str_contains($transaction->type, 'transfer') && isset($transferFields) && count($transferFields))
            <div class="section">
                <div class="section-title">Transfer Information</div>
                <table>
                    @foreach ($transferFields as $field)
                        <tr>
                            <td class="label">{{ $field['label'] }}</td>
                            <td>{{ $field['value'] }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td class="label">Fee</td>
                        <td>{{ $transferFee ?? '' }}</td>
                    </tr>
                    <tr>
                        <td class="label"><strong>Total Debited</strong></td>
                        <td><strong>{{ $transferTotal ?? '' }}</strong></td>
                    </tr>
                </table>
            </div>
        @endif

        <div class="footer">
            This receipt is system-generated and valid without a signature.<br>
            Please retain this document for your records.
        </div>
    </div>
</body>

</html>
