<x-emails.layout :transaction="$transaction" :transactionMessage="$transactionMessage" :url="$url" :subject="$subject">
    <!-- Header Title -->
    <h1 style="margin:0 0 24px; font-size:28px; font-weight:700; color:#0369a1; text-align:center; letter-spacing:1px;">
        {{ $subject }}
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong>{{ $transaction->account->profile->user->name ?? 'Valued Customer' }}</strong>,
    </p>

    <!-- Transaction Message -->
    <p style="margin:0 0 30px; font-size:16px; line-height:1.6; color:#555;">
        {{ $transactionMessage }}
    </p>

    <!-- Status Badge -->
    <div style="text-align:center; margin-bottom:30px;">
        <span
            style="
                display:inline-block;
                padding:10px 25px;
                border-radius:12px;
                font-weight:600;
                font-size:15px;
                color:#fff;
                background: {{ $transaction->statusGradient() }};
                min-width:120px;
                box-shadow:0 2px 6px rgba(0,0,0,0.1);
            ">
            {{ ucfirst($transaction->status ?? 'pending') }}
        </span>
    </div>

    <!-- View Transactions Button -->
    <div style="text-align:center; margin-bottom:30px;">
        <a href="{{ $url }}"
            style="
                display:inline-block;
                background: linear-gradient(90deg, #0ea5e9, #0284c7);
                color:#ffffff;
                font-size:16px;
                font-weight:600;
                text-decoration:none;
                padding:14px 36px;
                border-radius:8px;
                box-shadow:0 4px 12px rgba(0,0,0,0.15);
                transition:all 0.2s ease-in-out;
           "
            onmouseover="this.style.background='linear-gradient(90deg, #0284c7, #0ea5e9)';"
            onmouseout="this.style.background='linear-gradient(90deg, #0ea5e9, #0284c7)';">
            View Transactions
        </a>
    </div>

    <!-- Info Section -->
    <p style="margin:0 0 20px 0; font-size:14px; color:#555; text-align:center;">
        Date: <strong>{{ now()->toDayDateTimeString() }}</strong>
    </p>

    <!-- Note -->
    <p style="font-size:13px; color:#888; text-align:center; margin-bottom:30px;">
        This is an automated message. Please do not reply.
    </p>

    <!-- Footer -->
    <p style="margin-top:40px; font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for banking with <strong>{{ config('app.name') }}</strong>.<br>
        &mdash; The {{ config('app.name') }} Team
    </p>
</x-emails.layout>
