<x-emails.layout :subject="'Tax Refund Receipt'" :headerTitle="config('app.name')" :headerUrl="route('user.dashboard')">

    <!-- Header -->
    <h1 style="margin:0 0 20px 0; font-size:28px; font-weight:700; color:#0369a1; text-align:center;">
        Tax Refund Receipt
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong>{{ $user->name }}</strong>,
    </p>

    <!-- Intro Message -->
    <p style="margin:0 0 30px 0; font-size:16px; line-height:1.6; color:#555;">
        Your tax refund request has been processed. Here are the details of your submission.
    </p>

    <!-- Refund Details -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Refund Details
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:20px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Filing Number</th>
            <td>{{ $refund->filing_number }}</td>
        </tr>
        <tr>
            <th align="left">Status</th>
            <td>{{ ucfirst($refund->status) }}</td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Submission Date</th>
            <td>{{ $refund->created_at->format('Y-m-d H:i:s') }}</td>
        </tr>
        <tr>
            <th align="left">Review Due Date</th>
            <td>{{ $refund->review_due_date?->format('Y-m-d') ?? '-' }}</td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Amount</th>
            <td>${{ number_format($refund->amount ?? 0, 2) }}</td>
        </tr>
    </table>

    <!-- User Details -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        User Details
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:20px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Full Name</th>
            <td>{{ $refund->full_name }}</td>
        </tr>
        <tr>
            <th align="left">Email</th>
            <td>{{ $refund->email }}</td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Country</th>
            <td>{{ $refund->country_code }}</td>
        </tr>
        <tr>
            <th align="left">State</th>
            <td>{{ $refund->state }}</td>
        </tr>
    </table>

    <!-- Tax Information -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Tax Information
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:20px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Filing Status</th>
            <td>{{ $refund->meta['filing_status'] ?? '-' }}</td>
        </tr>
        <tr>
            <th align="left">Income</th>
            <td>${{ number_format($refund->meta['income'] ?? 0, 2) }}</td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Taxes Withheld</th>
            <td>${{ number_format($refund->meta['taxes_withheld'] ?? 0, 2) }}</td>
        </tr>
        <tr>
            <th align="left">Deductions</th>
            <td>${{ number_format($refund->meta['deductions'] ?? 0, 2) }}</td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left">Credits</th>
            <td>${{ number_format($refund->meta['credits'] ?? 0, 2) }}</td>
        </tr>
    </table>

    <!-- Status History -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Status History
    </h2>
    <table width="100%" cellpadding="8" cellspacing="0"
        style="border-collapse:collapse; margin-bottom:30px; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left">Status</th>
            <th align="left">Notes</th>
            <th align="left">Changed At</th>
        </tr>
        @foreach ($statusHistories as $history)
            <tr @if ($loop->even) style="background:#f9f9f9;" @endif>
                <td>{{ ucfirst($history->status) }}</td>
                <td>{{ $history->notes ?? '-' }}</td>
                <td>{{ $history->changed_at?->format('Y-m-d H:i:s') ?? $history->created_at->format('Y-m-d H:i:s') }}
                </td>
            </tr>
        @endforeach
    </table>

    <!-- Download Button -->
    <div style="text-align:center; margin:30px 0;">
        <a href="{{ $downloadUrl ?? '#' }}"
            style="display:inline-block; background:#0369a1; color:#ffffff; font-size:16px; font-weight:600;
                  text-decoration:none; padding:14px 36px; border-radius:8px;">
            Download Receipt (PDF)
        </a>
    </div>

    <!-- Footer / Info -->
    <p style="font-size:13px; color:#888; text-align:center; line-height:1.5; margin-bottom:10px;">
        Date: <strong>{{ now()->toDayDateTimeString() }}</strong>
    </p>
    <p style="font-size:13px; color:#888; text-align:center; line-height:1.5; margin-bottom:20px;">
        This is an automated message. Please do not reply.
    </p>

    <p style="font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for choosing <strong>{{ config('app.name') }}</strong>.<br>
        &mdash; The {{ config('app.name') }} Team
    </p>

</x-emails.layout>
