<x-emails.layout :subject="'Tax Refund Update'" :headerTitle="config('app.name')" :headerUrl="route('user.dashboard')">

    <!-- Header -->
    <h1 style="margin:0 0 20px 0; font-size:28px; font-weight:700; color:#0369a1; text-align:center;">
        Tax Refund Request {{ ucfirst(str_replace('_', ' ', $status)) }}
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong>{{ $refund->user->name }}</strong>,
    </p>

    <!-- Refund Info Table -->
    <p style="margin:0 0 10px 0; font-size:16px; line-height:1.6; color:#555;">
        Your refund request details:
    </p>

    <table width="100%" cellpadding="8" cellspacing="0" style="border-collapse:collapse; font-size:14px;">
        @php
            $refundDetails = [
                'Refund ID' => $refund->id,
                'Status' => ucfirst(str_replace('_', ' ', $status)),
                'Amount' => $refund->formattedAmount(), // ✅ use user currency
                'Submitted On' => $refund->created_at->format('M d, Y'),
                'Admin Note' => $note ?? '—',
            ];
        @endphp

        @foreach ($refundDetails as $label => $value)
            <tr style="background: {{ $loop->even ? '#f9f9f9' : '#f2f2f2' }};">
                <th align="left" style="padding:8px; font-weight:600; color:#111; text-align:left;">
                    {{ $label }}
                </th>
                <td style="padding:8px; color:#333;">
                    {{ $value }}
                </td>
            </tr>
        @endforeach
    </table>

    <!-- Action Button -->
    <p style="text-align:center; margin:20px 0;">
        <a href="{{ route('user.tax.refund.track') }}"
            style="padding:10px 20px; background-color:#0369a1; color:#fff; border-radius:5px; text-decoration:none;">
            View Refund Status
        </a>
    </p>

    <!-- Footer -->
    <p style="margin-top:40px; font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for using <strong>{{ config('app.name') }}</strong>.<br>
        &mdash; The {{ config('app.name') }} Team
    </p>

</x-emails.layout>
