<x-emails.layout :subject="$subject" :headerTitle="$appName" :headerUrl="$headerUrl">

    <!-- Greeting -->
    <p style="font-size:16px; color:#333;">
        Hello <strong>{{ $userName }}</strong>,
    </p>

    <!-- Intro -->
    <p style="font-size:16px; color:#555;">
        Your grant application (#{{ $grantId ?? '-' }}) has been
        <strong>{{ $displayStatus }}</strong>.
        @if (!empty($note))
            <br>Note: {{ $note }}
        @endif
    </p>


    <!-- Grant Details -->
    <h2 style="color:#0369a1; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Grant Details
    </h2>

    <table width="100%" cellpadding="8" cellspacing="0" style="border-collapse:collapse; font-size:14px;">
        @foreach ($grantDetails as $label => $value)
            <tr style="background: {{ $loop->even ? '#f9f9f9' : '#f2f2f2' }};">
                <th align="left" style="padding:8px; font-weight:600; color:#111;">
                    {{ $label }}
                </th>
                <td style="padding:8px; color:#333;">
                    {{ $value }}
                </td>
            </tr>
        @endforeach

    </table>

    <!-- Status Badge -->
    <p style="margin:20px 0;">
        <span style="padding:6px 12px; border-radius:4px; background-color:{{ $statusColor }}; color:#fff;">
            {{ $displayStatus }}
        </span>
    </p>

    <!-- Call to Action -->
    @if ($buttonUrl)
        <div style="text-align:center; margin:30px 0;">
            <a href="{{ $buttonUrl }}" target="_blank"
                style="padding:12px 24px; background-color:{{ $buttonColor }}; color:#fff; text-decoration:none; border-radius:4px;">
                View Grant Details
            </a>
        </div>
    @endif

    <!-- Closing -->
    <p style="font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for choosing <strong>{{ $appName }}</strong>.<br>
        &mdash; The {{ $appName }} Team
    </p>

</x-emails.layout>
