<x-emails.layout :subject="'Grant Submission Confirmation'" :headerTitle="config('app.name')" :headerUrl="route('user.dashboard')">

    <!-- Header -->
    <h1 style="margin:0 0 20px 0; font-size:28px; font-weight:700; color:#0369a1; text-align:center;">
        Grant Submission Confirmation
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong>{{ $grant->user->name }}</strong>,
    </p>

    <!-- Intro -->
    <p style="margin:0 0 30px 0; font-size:16px; line-height:1.6; color:#555;">
        Thank you for submitting your grant application. Here are the details of your submission:
    </p>

    <!-- Grant Details -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        Grant Details
    </h2>
    <table width="100%" cellpadding="10" cellspacing="0" style="border-collapse:collapse; font-size:14px;">
        <!-- Type -->
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left" style="padding:8px;">Grant Type</th>
            <td style="padding:8px;">{{ ucfirst($grant->type) }}</td>
        </tr>

        <!-- Dynamic Title -->
        <tr>
            <th align="left" style="padding:8px;">Grant Title</th>
            <td style="padding:8px;">
                {{ $grant->type === 'company' ? 'Company Grant Application' : 'Personal Grant Application' }}
            </td>
        </tr>

        <!-- Requested Amount -->
        <tr style="background:#f9f9f9;">
            <th align="left" style="padding:8px;">Requested Amount</th>
            <td style="padding:8px;">${{ number_format($grant->amount, 2) }}</td>
        </tr>

        <!-- Company: Project Details -->
        @if ($grant->type === 'company' && !empty($grant->metadata['project']['title']))
            <tr>
                <th align="left" style="padding:8px;">Project Name</th>
                <td style="padding:8px;">{{ $grant->metadata['project']['title'] }}</td>
            </tr>
            <tr style="background:#f9f9f9;">
                <th align="left" style="padding:8px;">Project Description</th>
                <td style="padding:8px;">{{ $grant->metadata['project']['description'] }}</td>
            </tr>
        @endif

        <!-- Personal: Primary Purpose -->
        @if ($grant->type === 'personal' && !empty($grant->purposes))
            <tr style="background:#f2f2f2;">
                <th align="left" style="padding:8px;">Primary Purpose</th>
                <td style="padding:8px;">{{ ucwords(str_replace('_', ' ', $grant->purposes[0])) }}</td>
            </tr>
        @endif

        <!-- Optional: Additional Purposes -->
        @if (!empty($grant->purposes) && count($grant->purposes) > 1)
            <tr style="background:#f9f9f9;">
                <th align="left" style="padding:8px;">Other Purposes</th>
                <td style="padding:8px;">
                    {{ implode(', ', array_map(fn($p) => ucwords(str_replace('_', ' ', $p)), array_slice($grant->purposes, 1))) }}
                </td>
            </tr>
        @endif

        <!-- Organization Name -->
        @if (!empty($grant->metadata['organization']['name']))
            <tr style="background:#f2f2f2;">
                <th align="left" style="padding:8px;">Organization Name</th>
                <td style="padding:8px;">{{ $grant->metadata['organization']['name'] }}</td>
            </tr>
        @endif

        <!-- Status -->
        <tr style="background:#f9f9f9;">
            <th align="left" style="padding:8px;">Status</th>
            <td style="padding:8px;">{{ ucfirst($grant->status) }}</td>
        </tr>

        <!-- Submission Date -->
        <tr style="background:#f2f2f2;">
            <th align="left" style="padding:8px;">Submission Date</th>
            <td style="padding:8px;">{{ $grant->created_at->format('Y-m-d H:i:s') }}</td>
        </tr>
    </table>

    <!-- User Details -->
    <h2 style="color:#0369a1; margin-bottom:10px; font-size:18px; border-bottom:2px solid #0284c7; padding-bottom:4px;">
        User Details
    </h2>
    <table width="100%" cellpadding="10" cellspacing="0" style="border-collapse:collapse; font-size:14px;">
        <tr style="background:#f2f2f2; color:#0369a1;">
            <th align="left" style="padding:8px;">Full Name</th>
            <td style="padding:8px;">{{ $grant->user->name }}</td>
        </tr>
        <tr style="background:#f9f9f9;">
            <th align="left" style="padding:8px;">Email</th>
            <td style="padding:8px;">{{ $grant->user->email }}</td>
        </tr>
        @if (!empty($grant->contact_person))
            <tr style="background:#f2f2f2;">
                <th align="left" style="padding:8px;">Contact Person</th>
                <td style="padding:8px;">
                    {{ $grant->contact_person ?? ($grant->metadata['contact']['contact_person'] ?? 'N/A') }}
                </td>
            </tr>
        @endif
    </table>

    <!-- Closing Note -->
    <p style="margin:30px 0 20px 0; font-size:16px; line-height:1.6; color:#555;">
        Your application is currently under review. You will receive a notification once it has been processed.
    </p>

    <!-- Footer -->
    <p style="font-size:13px; color:#888; text-align:center; line-height:1.5; margin-bottom:10px;">
        Date: <strong>{{ now()->toDayDateTimeString() }}</strong>
    </p>
    <p style="font-size:13px; color:#888; text-align:center; line-height:1.5; margin-bottom:20px;">
        This is an automated message. Please do not reply.
    </p>

    <p style="font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for choosing <strong>{{ config('app.name') }}</strong>.<br>
        &mdash; The {{ config('app.name') }} Team
    </p>

</x-emails.layout>
