<x-emails.layout :subject="'Message Received'" :headerTitle="config('app.name')" :headerUrl="route('home')">

    <!-- Header -->
    <h1 style="margin:0 0 20px 0; font-size:28px; font-weight:700; color:#0369a1; text-align:center;">
        Message Received
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong>{{ $contact->fullname }}</strong>,
    </p>

    <!-- Contact Info -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#555;">
        Thank you for reaching out. We have received your message and will get back to you shortly. Here are the details you submitted:
    </p>

    <table width="100%" cellpadding="0" cellspacing="0" style="margin-bottom:20px;">
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Full Name:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ $contact->fullname }}</td>
        </tr>
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Email:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ $contact->email }}</td>
        </tr>
        @if($contact->phone)
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Phone:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ $contact->phone }}</td>
        </tr>
        @endif
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Subject:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ $contact->subject }}</td>
        </tr>
    </table>

    <!-- Message -->
    <p style="font-size:16px; line-height:1.6; color:#555;">
        Message:
    </p>
    <p style="font-size:16px; line-height:1.6; color:#333; padding:10px; background:#f9f9f9; border-radius:5px;">
        {{ $contact->message }}
    </p>

    <!-- Optional attachments -->
    @if($contact->attachments && count($contact->attachments))
        <p style="font-size:16px; line-height:1.6; color:#555; margin-top:20px;">
            Attachments:
        </p>
        <ul style="font-size:14px; color:#333; padding-left:20px;">
            @foreach($contact->attachments as $file)
                <li><a href="{{ asset('storage/'.$file) }}" target="_blank">{{ basename($file) }}</a></li>
            @endforeach
        </ul>
    @endif

    <!-- Footer -->
    <p style="margin-top:40px; font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for contacting <strong>{{ config('app.name') }}</strong>.<br>
        &mdash; The {{ config('app.name') }} Team
    </p>

</x-emails.layout>
