<?php

use Livewire\Component;

new class extends Component {
    public array $stats = [];
    public string $currencySymbol;

    public function mount(array $stats, string $currencySymbol)
    {
        $this->stats = $stats;
        $this->currencySymbol = $currencySymbol;
    }

    // Optional: if parent emits updated stats after an action
    public function refresh(array $stats)
    {
        $this->stats = $stats;
    }
};
?>

<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mt-4">

    <x-admin.stats-card title="Wallet Balance" icon="currency-dollar" icon-color="text-white" icon-bg="bg-green-500"
        icon-variant="solid" :value="$currencySymbol . number_format($stats['walletBalance'] ?? 0, 2)" />

    <x-admin.stats-card title="Total Deposits" icon="arrow-down-tray" icon-color="text-white" icon-bg="bg-blue-500"
        icon-variant="solid" :value="$currencySymbol . number_format($stats['totalDeposit'] ?? 0, 2)" />

    <x-admin.stats-card title="Total Withdrawals" icon="arrow-up-tray" icon-color="text-white" icon-bg="bg-red-500"
        icon-variant="solid" :value="$currencySymbol . number_format($stats['totalWithdrawal'] ?? 0, 2)" />

    <x-admin.stats-card title="Total Loans" icon="banknotes" icon-color="text-white" icon-bg="bg-purple-500"
        icon-variant="solid" :value="$currencySymbol . number_format($stats['totalLoan'] ?? 0, 2)" />

    <x-admin.stats-card title="Revenue" icon="banknotes" icon-color="text-white" icon-bg="bg-indigo-500"
        icon-variant="solid" :value="$currencySymbol . number_format($stats['revenue'] ?? 0, 2)" />

    <x-admin.stats-card title="Expenses" icon="credit-card" icon-color="text-white" icon-bg="bg-red-600"
        icon-variant="solid" :value="$currencySymbol . number_format($stats['expenses'] ?? 0, 2)" />

    <x-admin.stats-card title="Tickets Open" icon="ticket" icon-color="text-white" icon-bg="bg-yellow-500"
        icon-variant="solid" :value="$stats['ticketsOpen'] ?? 0" />

    <x-admin.stats-card title="Tickets Closed" icon="ticket" icon-color="text-white" icon-bg="bg-green-500"
        icon-variant="solid" :value="$stats['ticketsClosed'] ?? 0" />
</div>
