<?php

use Livewire\Component;

new class extends Component
{
    public $message;
    public $type = 'success'; // 'success', 'error', etc.
    public $visible = false;

    protected $listeners = ['showToast' => 'show'];
    public function show($message, $type = 'success')
    {
        $this->message = $message;
        $this->type = $type;
        $this->visible = true;

        $this->dispatch('start-toast-timer');
    }
    public function hide()
    {
        $this->visible = false;
    }


};