<div>
    <div x-data="{
        show: false,
        type: 'success',
        message: '',
        progress: 100,
        startTimer(newType, newMessage) {
            this.type = newType;
            this.message = newMessage;
            this.show = true;
            this.progress = 100;
            let interval = setInterval(() => {
                this.progress -= 100 / (3000 / 50); // reduce progress every 50ms for 3s
                if (this.progress <= 0) {
                    this.show = false;
                    clearInterval(interval);
                }
            }, 50);
        }
    }" x-cloak x-show="show" x-init="window.addEventListener('showToast', event => { startTimer(event.detail.type, event.detail.message) })" x-transition
        class="fixed top-5 left-5 z-50 px-4 py-3 rounded-md text-sm shadow-lg border-l-4 flex items-center space-x-2"
        :class="{
            'bg-green-100 border-green-500 text-green-700': type === 'success',
            'bg-red-100 border-red-500 text-red-700': type === 'error',
            'bg-yellow-100 border-yellow-500 text-yellow-700': type === 'warning'
        }">
        <!-- Icons -->
        <template x-if="type === 'success'">
            <x-flux::icon.check-circle class="w-5 h-5 shrink-0" />
        </template>
        <template x-if="type === 'error'">
            <x-flux::icon.x-circle class="w-5 h-5 shrink-0" />
        </template>
        <template x-if="type === 'warning'">
            <x-flux::icon.x-circle class="w-5 h-5 shrink-0" />
        </template>

        <div x-text="message"></div>

        <div class="absolute bottom-0 left-0 h-1 bg-current transition-all duration-50" :style="`width: ${progress}%`">
        </div>
    </div>

    <div wire:ignore x-data="{
        open: false,
        type: '',
        amount: '',
        title: '',
        iconClasses: {
            deposit: 'bg-green-100 text-green-600',
            withdrawal: 'bg-red-100 text-red-600',
            transfer: 'bg-blue-100 text-blue-600',
            default: 'bg-gray-100 text-gray-600'
        }
    }"
        x-on:transaction-success.window="
         open = true;
         type = $event.detail.type ?? 'default';
         amount = Number($event.detail.amount ?? 0)
             .toLocaleString('en-US', { style: 'currency', currency: 'USD' });
         title = type.charAt(0).toUpperCase() + type.slice(1) + ' Submitted';
     "
        x-cloak>

        <!-- Overlay -->
        <div x-show="open" x-transition.opacity class="fixed inset-0 bg-black/50 z-40" @click="open = false"></div>

        <!-- Modal Wrapper -->
        <div x-show="open" x-transition class="fixed inset-0 z-50 flex items-center justify-center px-4">
            <div class="bg-white dark:bg-gray-900 rounded-2xl shadow-xl max-w-md w-full p-6" @click.stop>

                <!-- Icon -->
                <div class="flex justify-center mb-4">
                    <div class="h-14 w-14 rounded-full flex items-center justify-center bg-green-600 text-white">
                        <x-flux::icon.check class="w-8 h-8" />
                    </div>
                </div>


                <!-- Title -->
                <h2 class="text-lg font-semibold text-center text-gray-900 dark:text-gray-100" x-text="title"></h2>

                <!-- Message -->
                <p class="text-sm text-center text-gray-500 dark:text-gray-400 mt-2">
                    Your <span x-text="type"></span> of
                    <span class="font-semibold" x-text="amount"></span>
                    has been submitted and is pending confirmation.
                </p>

                <!-- Actions -->
                <div class="mt-6 flex justify-center">
                    <button @click="open = false"
                        class="px-6 py-2 rounded-xl bg-indigo-600 text-white hover:bg-indigo-700 transition">
                        Done
                    </button>
                </div>

            </div>
        </div>
    </div>

</div>
