@props([
    'icon', // Icon component name, e.g. 'currency-dollar'
    'bgColor', // bg color class for light mode, e.g. 'bg-sky-100'
    'darkBgColor', // bg color class for dark mode, e.g. 'dark:bg-sky-800'
    'textColor', // icon color for light mode, e.g. 'text-sky-600'
    'darkTextColor', // icon color for dark mode, e.g. 'dark:text-sky-300'
    'label', // Small label, e.g. 'Amount'
    'value', // Main value to display, e.g. '$100'
])

<div class="flex flex-col items-center">
    <div class="w-10 h-10 rounded-full {{ $bgColor }} {{ $darkBgColor }} flex items-center justify-center mb-2">
        <x-dynamic-component :component="$icon" class="w-5 h-5 {{ $textColor }} {{ $darkTextColor }}" />
    </div>
    <span class="text-xs text-gray-400 dark:text-white uppercase">{{ $label }}</span>
    <span class="mt-1 text-gray-400 dark:text-white font-bold text-lg">{{ $value }}</span>
</div>
