@props(['items'])

<div class="space-y-4">

    {{-- SEARCH --}}
    @isset($search)
        <div>
            {{ $search }}
        </div>
    @endisset

    {{-- DESKTOP --}}
    <div class="hidden lg:block overflow-x-auto">
        <table
            class="w-full text-sm text-left rounded-xl overflow-hidden shadow-md
                   bg-white dark:bg-gray-900 text-gray-700 dark:text-gray-100">

            <thead class="bg-gray-100 dark:bg-gray-800 uppercase text-xs tracking-wider">
                <tr>{{ $head }}</tr>
            </thead>

            <tbody>
                {{ $body }}
            </tbody>
        </table>
    </div>

    {{-- MOBILE --}}
    <div class="block lg:hidden space-y-4">
        {{ $mobile }}
    </div>

    {{-- FOOTER --}}
    @isset($footer)
        <div>
            {{ $footer }}
        </div>
    @endisset

</div>
