<div {{ $attributes->merge(['class' => 'container mx-auto text-white space-y-6']) }}>
    {{-- Page Header --}}
    <div class="flex flex-wrap justify-between items-center gap-4">
        <h2 class="text-xl font-bold text-gray-100 dark:text-white">{{ $title ?? '' }}</h2>
        <div>
            {{ $headerActions ?? '' }}
        </div>
    </div>

    <div class="">

        {{-- Search Input --}}
        @if (!empty($search))
            <div>
                {{ $search }}
            </div>
        @endif

        {{-- Footer Section --}}
        @if (!empty($footer))
            <div
                class="flex flex-col md:flex-row justify-between items-center gap-4 pt-6 border-t border-gray-700 dark:border-gray-600 mt-4">
                {{ $footer }}
            </div>
        @endif
    </div>

    {{-- Status Messages --}}
    @foreach (['status' => 'green', 'error' => 'red'] as $type => $color)
        @if (session($type))
            <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 3000)"
                class="fixed top-5 left-5 z-50 bg-white shadow-lg border-l-4 border-{{ $color }}-500 px-4 py-3 rounded-md text-{{ $color }}-700 text-sm"
                style="display: none;">{{ session($type) }}
            </div>
        @endif
    @endforeach

    {{-- Sort Dropdown --}}
    @if (!empty($sortDropdown))
        <div>
            {{ $sortDropdown }}
        </div>
    @endif

    {{-- Data Table (Desktop) --}}
    <div class="hidden lg:block overflow-x-auto">{{ $table }}
    </div>

    {{-- Mobile Cards --}}
    <div class="block lg:hidden space-y-4">{{ $cards }}
    </div>

</div>
