@props([
    'icon' => null,
    'label',
    'iconSolid' => true, // 👈 solid by default
    'route',
    'activeRoute' => null, // wildcard for active check
    'params' => [],
    'count' => null,
])

@php
    $isActive =
        request()->routeIs($activeRoute ?? $route) &&
        collect($params)->every(fn($value, $key) => request()->route($key) == $value);
@endphp


<a href="{{ route($route, $params) }}" @if ($isActive) aria-current="page" @endif
    class="group relative flex items-center gap-3 px-2 py-2.5 rounded-lg text-sm font-medium
        transition-all duration-200
        focus:outline-none focus:ring-2 focus:ring-offset-1
        focus:ring-[#0E4D92]/40 dark:focus:ring-sky-300/40

        {{ $isActive
            ? 'bg-[#0E4D92]/10 text-[#0E4D92] dark:bg-sky-300/20 dark:text-sky-300'
            : 'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800 hover:text-gray-900 dark:hover:text-gray-100' }}
    ">

    {{-- Active indicator bar --}}
    @if ($isActive)
        <span
            class="absolute left-0 top-1/2 -translate-y-1/2 h-6 w-1 rounded-full
                   bg-[#0E4D92] dark:bg-sky-600">
        </span>
    @endif

    {{-- Icon (optional) --}}
    @if ($icon)
        <span
            class="flex h-8 w-8 items-center justify-center rounded-md
                bg-gray-100 dark:bg-gray-800
                text-gray-600 dark:text-gray-300
                transition-colors duration-200
                group-hover:bg-sky-100 group-hover:text-sky-600
                dark:group-hover:bg-sky-900/30
                {{ $isActive ? 'bg-sky-100 text-sky-600 dark:bg-sky-900/40' : '' }}">
            <x-flux::icon :variant="$iconSolid ? 'solid' : null" :name="$icon" class="w-4 h-4" />

        </span>
    @endif

    {{-- Label --}}
    <span class="flex-1 text-sm truncate">
        {{ $label }}
    </span>

    {{-- Count badge (optional) --}}
    @if (!is_null($count))
        <span
            class="ml-auto inline-flex items-center justify-center min-w-5.5
                px-2 py-0.5 rounded-full text-[11px] font-semibold
                transition aspect-square
                {{ $isActive
                    ? 'bg-[#0E4D92]/15 text-[#0E4D92] dark:bg-sky-300/30 dark:text-sky-600'
                    : 'bg-red-200 text-red-700 dark:bg-red-700 dark:text-red-300' }}">
            {{ $count }}
        </span>
    @endif
</a>
