@props([
    'label',
    'icon' => null,
    'iconSolid' => true, // 👈 solid by default
    'routes' => [], // 👈 route patterns
])

@php
    $isActive = collect($routes)->contains(fn($route) => request()->routeIs($route));
@endphp

<div x-data="{ open: {{ $isActive ? 'true' : 'false' }} }" class="space-y-1">

    <button type="button" @click="open = !open" @if ($isActive) aria-current="page" @endif
        class="group relative w-full flex items-center justify-between gap-1
            px-3 py-2.5 rounded-lg text-sm font-medium transition-all duration-200
            focus:outline-none focus:ring-2 focus:ring-offset-1
            focus:ring-[#0E4D92]/40 dark:focus:ring-[#0E4D92]/40

            {{ $isActive
                ? 'bg-[#0E4D92]/10 text-[#0E4D92] dark:bg-[#0E4D92]/20 dark:text-[#0E4D92]'
                : 'text-gray-600 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-800 hover:text-gray-900 dark:hover:text-gray-100' }}
        ">

        {{-- Active indicator --}}
        @if ($isActive)
            <span
                class="absolute left-0 top-1/2 -translate-y-1/2 h-6 w-1 rounded-full
                   bg-[#0E4D92] dark:bg-sky-600">
            </span>
        @endif
        {{-- Left --}}
        <div class="flex items-center gap-3">
            {{-- Icon (optional) --}}
            @if ($icon)
                <span
                    class="flex h-8 w-8 items-center justify-center rounded-md
                bg-gray-100 dark:bg-gray-800
                text-gray-600 dark:text-gray-300
                transition-colors duration-200
                group-hover:bg-sky-100 group-hover:text-sky-600
                dark:group-hover:bg-sky-900/30
                {{ $isActive ? 'bg-sky-100 text-sky-600 dark:bg-sky-900/40' : '' }}">
                    <x-flux::icon :variant="$iconSolid ? 'solid' : null" :name="$icon" class="w-4 h-4" />
                </span>
            @endif

            {{-- Label --}}
            <span class="flex-1 text-xs md:text-sm truncate">
                {{ $label }}
            </span>
        </div>

        {{-- Chevron --}}
        <svg class="w-4 h-4 transition-transform duration-300
                {{ $isActive ? 'text-sky-500 dark:text-[#0E4D92]' : 'text-gray-400 group-hover:text-gray-600' }}"
            :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    {{-- Children --}}
    <div x-show="open" x-collapse x-cloak
        class="relative ml-4 pl-2 space-y-1 border-l border-gray-200 dark:border-gray-700">
        {{ $slot }}
    </div>
</div>
