<div class="grid grid-cols-1 md:grid-cols-6 gap-6 items-start">
    {{-- Sidebar (2 cols) --}}
    <aside class="md:col-span-2 space-y-5 bg-white dark:bg-gray-800 p-5 rounded-lg shadow-md">
        <div class="mx-auto flex items-center justify-center text-center">
            <livewire:userphoto />
        </div>
        <nav class="">

            <x-sidebar.link icon="user" label="Profile" route="user.settings.index" />

            <x-sidebar.link icon="lock-closed" label="Password" route="user.settings.password" />
            <x-sidebar.link icon="shield-check" label="Two Factor Authentication" route="user.settings.two-factor" />
            <x-sidebar.link icon="credit-card" label="Transaction Pin" route="user.settings.transaction.pin" />
            <x-sidebar.link icon="device-phone-mobile" label="Trusted Device's" route="user.settings.trusted.device" />
        </nav>

        {{-- Optional Contact Card --}}
        <div class="mt-6 ">
            @include('partials.contact-card')
            <livewire:pages::user.settings.delete-user-form />

        </div>

    </aside>

    {{-- Mobile Separator --}}
    <div class="md:hidden my-4 border-t border-gray-300 dark:border-gray-600"></div>

    {{-- Content (4 cols) --}}
    <section class="md:col-span-4 bg-white dark:bg-gray-800 p-6 rounded-lg shadow-md">
        @if (isset($heading))
            <h1 class="text-2xl font-semibold text-gray-800 dark:text-gray-100">{{ $heading }}</h1>
        @endif

        @if (isset($subheading))
            <p class="mt-2 text-gray-500 dark:text-gray-300">{{ $subheading }}</p>
        @endif

        <div class="mt-5 space-y-6">
            {{ $slot }}
        </div>
    </section>
</div>
