@props([
    'title' => 'Comprehensive banking solutions tailored to your financial needs',
    'description' => '',
    'smCols' => null,
    'lgCols' => null,
    'iconDefaultBg' => 'bg-primary-50 dark:bg-primary-900/30',
    'iconDefaultColor' => 'text-primary-700 dark:text-primary-400',
    'cards' => [],
])

@php
    $count = count($cards);
    $smCols = $smCols ?? ($count >= 2 ? 2 : 1);
    $lgCols = $lgCols ?? ($count >= 3 ? 3 : $count);
    $gridClass = "grid gap-8 sm:grid-cols-{$smCols} lg:grid-cols-{$lgCols}";
@endphp

<section class="relative py-8 md:py-12 bg-white dark:bg-gray-950 border-t border-gray-200 dark:border-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">

        <!-- Section Header -->
     @if($title || $description)
<div class="text-center max-w-4xl mx-auto mb-16">
    @if($title)
        <p class="text-sm font-medium uppercase text-gray-500 dark:text-gray-400 tracking-widest mb-2">
            Our Services
        </p>
        <h2 class="text-3xl sm:text-4xl font-bold text-gray-900 dark:text-white leading-tight mb-4">
            {{ $title }}
        </h2>
        <div class="mx-auto w-20 h-1 bg-gray-300 dark:bg-gray-700 rounded-full mb-6"></div>
    @endif

    @if($description)
        <p class="text-lg text-gray-600 dark:text-gray-400 leading-relaxed">
            {{ $description }}
        </p>
    @endif
</div>
@endif


        <!-- Services Grid -->
        <div class="{{ $gridClass }}">
            @foreach($cards as $card)
                <div class="bg-gray-50 dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-lg p-8 transition-colors duration-200 hover:border-primary-300 dark:hover:border-primary-600">
                    
                    @if(!empty($card['icon']))
                        <div class="w-14 h-14 mb-6 flex items-center justify-center rounded-md
                            {{ $card['iconBg'] ?? $iconDefaultBg }}
                            {{ $card['iconColor'] ?? $iconDefaultColor }}">
                                <x-flux::icon :name="$card['icon']" class="w-6 h-6" />
                        </div>
                    @endif

                    @if(!empty($card['title']))
                        <h3 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">
                            {{ $card['title'] }}
                        </h3>
                    @endif

                    @if(!empty($card['description']))
                        <p class="text-gray-700 dark:text-gray-400 text-base mb-6 leading-relaxed">
                            {{ $card['description'] }}
                        </p>
                    @endif

                    @if(!empty($card['link']))
                        <a href="{{ $card['link'] }}" class="inline-flex items-center text-sm font-semibold text-primary-700 dark:text-primary-400 hover:underline">
                            Learn More
                        </a>
                    @endif

                </div>
            @endforeach
        </div>

    </div>
</section>
