@props(['title', 'actions', 'account' => null])

<div
    class="bg-white dark:bg-gray-800 rounded-xl p-4 shadow-sm dark:shadow-gray-900/25 border border-gray-100 dark:border-gray-700">

    <!-- Heading -->
    <div class="flex items-center justify-between text-gray-800 dark:text-gray-200">
        <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-4">{{ $title }}</h3>
    </div>

    <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
        @foreach ($actions as $action)
            @if (isset($action['href']))
                <a href="{{ $action['href'] }}" class="quick-action">
                    @include('components.quick-card-item', ['action' => $action])
                </a>
            @elseif (isset($action['modal']))
                <button type="button" @click="openModal = '{{ $action['modal'] }}'" class="quick-action w-full">
                    @include('components.quick-card-item', ['action' => $action])
                </button>
            @endif
        @endforeach

    </div>

    {{-- BANK DETAILS MODAL --}}
    <x-modal @open-export-modal.window="openModal()" @close-export-modal.window="close()">
        <div class="space-y-6">

            <!-- Header -->
            <div class="text-center space-y-2">
                <div class="w-12 h-12 bg-sky-800 rounded-xl mx-auto flex items-center justify-center text-white">
                    <x-flux::icon.building-library class="w-5 h-5" />
                </div>
                <h2 class="text-base font-semibold tracking-wide capitalize">Bank Account Details</h2>
                <span class="text-sm text-gray-600 dark:text-sky-200">{{ config('app.name') }}</span>
            </div>

            <!-- Account Information -->
            <div class="space-y-4">

                <!-- Section Header -->
                <div class="flex items-center gap-2 text-sky-600">
                    <x-flux::icon.information-circle class="w-5 h-5" />
                    <h3 class="font-semibold tracking-wide text-sm">Account Information</h3>
                </div>

                <!-- Account Fields -->
                <div class="grid grid-cols-1 gap-4">

                    <!-- Account Name -->
                    <div x-data="{ copied: false }"
                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">Account Name</h4>
                        <div class="flex items-center justify-between">
                            <span class="font-medium">{{ $authUser->name }}</span>
                            <button
                                @click="
                                    navigator.clipboard.writeText('{{ $authUser->name }}').then(() => {
                                        copied = true;
                                        setTimeout(() => copied = false, 2000);
                                    })
                                "
                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                <template x-if="!copied">
                                    <x-flux::icon.clipboard-document class="w-5 h-5" />
                                </template>
                                <template x-if="copied">
                                    <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                </template>
                            </button>
                        </div>
                    </div>

                    <!-- Account Number -->
                    <div x-data="{ copied: false }"
                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">Account Number
                        </h4>
                        <div class="flex items-center justify-between">
                            <span class="font-medium">{{ $account->account_number }}</span>
                            <button
                                @click="
                                    navigator.clipboard.writeText('{{ $account->account_number }}').then(() => {
                                        copied = true;
                                        setTimeout(() => copied = false, 2000);
                                    })
                                "
                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                <template x-if="!copied">
                                    <x-flux::icon.clipboard-document class="w-5 h-5" />
                                </template>
                                <template x-if="copied">
                                    <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                </template>
                            </button>
                        </div>
                    </div>

                    <!-- Bitcoin Wallet -->
                    <div x-data="{ copied: false }"
                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">Bitcoin Wallet
                        </h4>
                        <div class="flex items-center justify-between">
                            <span class="font-medium truncate">bc1fjjslsjjfflla123jdjd00</span>
                            <button
                                @click="
                                    navigator.clipboard.writeText('bc1fjjslsjjfflla123jdjd00').then(() => {
                                        copied = true;
                                        setTimeout(() => copied = false, 2000);
                                    })
                                "
                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                <template x-if="!copied">
                                    <x-flux::icon.clipboard-document class="w-5 h-5" />
                                </template>
                                <template x-if="copied">
                                    <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                </template>
                            </button>
                        </div>
                    </div>

                </div>

            </div>

            <!-- Security Notice -->
            <div
                class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg flex flex-col sm:flex-row gap-3 items-start sm:items-center shadow-sm">
                <x-flux::icon.shield-check class="w-5 h-5 text-green-500 shrink-0" />
                <div class="space-y-1">
                    <h3 class="font-semibold text-sm tracking-wide">Security Notice</h3>
                    <p class="text-xs text-gray-600 dark:text-sky-200 leading-relaxed">
                        Always contact <strong>{{ config('app.name') }}</strong> Support before making payments to
                        verify account details.
                    </p>
                </div>
            </div>

            <div class="flex items-end justify-end">
                <button type="button" @click="openModal = null"
                    class=" bg-red-700 text-white shadow-lg text-xs font-medium rounded-full p-2 hover:bg-red-600 hover:scale-110 transition-transform duration-150 flex items-center justify-center focus:outline-none focus:ring-2 focus:ring-red-400 capitalize">
                    <x-flux::icon.x-mark class="w-5 h-5" />
                    <span>cancel</span>
                </button>
            </div>
        </div>

        {{-- Bank details content --}}
    </x-modal>

</div>
